<?PHP

// ---------------------------------------------------------
// UPDATE LANGUAGE PACKS
// ---------------------------------------------------------

try {
    $db->exec("DROP TABLE IF EXISTS idevaff_languages;
DROP TABLE IF EXISTS idevaff_lang_phrases;
DROP TABLE IF EXISTS idevaff_language_custom_values");

    $re_showQ = "SHOW TABLES LIKE 'idevaff_lang_phrases' ";
    $re_result = $db->query($re_showQ);
    $re_rowCount = $re_result->rowCount();
    if (!$re_rowCount) {

try {
    $db->exec("TRUNCATE TABLE idevaff_language_packs");
} catch (Exception $e) {
    $ret_ajax['errors'][] = $e->getMessage();
}
		
$db->query("insert into idevaff_language_packs (name, status, def, table_name, user_created, direction) VALUES 
	('arabic', 8, 0, 'arabic', 0, 1),
	('chinese', 8, 0, 'chinese', 0, 0),
	('czech', 8, 0, 'czech', 0, 0),
	('danish', 8, 0, 'danish', 0, 0),
	('dutch', 8, 0, 'dutch', 0, 0),
	('english', 1, 1, 'english', 0, 0),
	('farsi', 8, 0, 'farsi', 0, 1),
	('finnish', 8, 0, 'finnish', 0, 0),
	('french', 8, 0, 'french', 0, 0),
	('german', 8, 0, 'german', 0, 0),
	('greek', 8, 0, 'greek', 0, 0),
	('hebrew', 8, 0, 'hebrew', 0, 1),
	('hungarian', 8, 0, 'hungarian', 0, 0),
	('indonesian', 8, 0, 'indonesian', 0, 0),
	('italian', 8, 0, 'italian', 0, 0),
	('japanese', 8, 0, 'japanese', 0, 0),
	('korean', 8, 0, 'korean', 0, 0),
	('mandarin chinese', 8, 0, 'mandarin_chinese', 0, 0),
	('norwegian', 8, 0, 'norwegian', 0, 0),
	('polish', 8, 0, 'polish', 0, 0),
	('portuguese', 8, 0, 'portuguese', 0, 0),
	('romanian', 8, 0, 'romanian', 0, 0),
	('russian', 8, 0, 'russian', 0, 0),
	('spanish', 8, 0, 'spanish', 0, 0),
	('swedish', 8, 0, 'swedish', 0, 0),
	('thai', 8, 0, 'thai', 0, 0),
	('turkish', 8, 0, 'turkish', 0, 0),
	('ukrainian', 8, 0, 'ukrainian', 0, 0),
	('vietnamese', 8, 0, 'vietnamese', 0, 0)
	");
	
        $query = "CREATE TABLE IF NOT EXISTS `idevaff_lang_phrases` (
                      `id` int(11) NOT NULL AUTO_INCREMENT,
                      `lang_id` INT(11) NOT NULL,
                      `key` VARCHAR (255) NOT NULL,
                      `value` LONGTEXT NULL,
                      PRIMARY KEY (`id`)
                    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;";
        $st = $db->prepare($query);
        $st->execute();

        $re_showQ = "SHOW TABLES LIKE 'idevaff_lang_phrases' ";
        $re_result = $db->query($re_showQ);
        $re_rowCount = $re_result->rowCount();
		
		// Do manually, names changed above
		$db->exec("DROP TABLE IF EXISTS idevaff_language_chinese_simplified");
		$db->exec("DROP TABLE IF EXISTS idevaff_language_chinese_traditional");

        if ($re_rowCount) {
            $query_packs = $db->query("SELECT * FROM idevaff_language_packs");
            if ($query_packs->rowCount() > 0) {

                foreach ($query_packs->fetchAll() as $item) {
                    $re_showQ = "SHOW TABLES LIKE 'idevaff_language_" . $item['table_name'] . "' ";
                    $re_result = $db->query($re_showQ);
                    $re_rowCount = $re_result->rowCount();

                    if (!$re_rowCount) {
                        continue;
                    }

                    $db->exec("DROP TABLE IF EXISTS idevaff_language_" . $item['table_name']);

                }


				$new_install_package = "english";
				include($path . '/includes/languages/english.php');
	        }
        }

        $get_custom_tokens = $db->query("SELECT `name` from idevaff_language_custom");
        $token_data = $get_custom_tokens->fetchAll();
        $get_lang_ids = $db->query("SELECT id from idevaff_language_packs");
        $lang_data = $get_lang_ids->fetchAll();
        if ($get_custom_tokens->rowCount()) {
            foreach ($token_data as $datum) {
                foreach ($lang_data as $row) {
                    $st = $db->prepare("insert into idevaff_lang_phrases (`lang_id`, `key`, `value`) VALUES (?, ?, ?)");
                    $st->execute(array($row['id'], $datum['name'], $datum['name']));
                }
            }
        }

    }
} catch (Exception $e) {
    $ret_ajax['errors'][] = $e->getMessage();
}


// ---------------------------------------------------------
// UPDATE EMAIL LANGUAGE PACKS
// ---------------------------------------------------------

try {
    $db->exec("DROP TABLE IF EXISTS idevaff_email_lang_phrases");
    $re_showQ = "SHOW TABLES LIKE 'idevaff_email_lang_phrases' ";
    $re_result = $db->query($re_showQ);
    $re_rowCount = $re_result->rowCount();

    if (!$re_rowCount) {
        $query = "
                CREATE TABLE IF NOT EXISTS `idevaff_email_lang_phrases` (
                      `id` int NOT NULL AUTO_INCREMENT,
                      `lang_id` INT NOT NULL,
                      `key` VARCHAR (255) NOT NULL,
                      `value` LONGTEXT NULL,
                      PRIMARY KEY (`id`)
                    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;";

        $st = $db->prepare($query);
        $st->execute();

        $re_showQ = "SHOW TABLES LIKE 'idevaff_email_lang_phrases' ";
        $re_result = $db->query($re_showQ);
        $re_rowCount = $re_result->rowCount();

        if ($re_rowCount) {
            $query_packs = $db->query("SELECT * FROM idevaff_email_language_packs");
            if ($query_packs->rowCount() > 0) {

                foreach ($query_packs->fetchAll() as $item) {
                    $re_showQ = "SHOW TABLES LIKE 'idevaff_email_" . $item['table_name'] . "' ";
                    $re_result = $db->query($re_showQ);

                    $re_rowCount = $re_result->rowCount();

                    if (!$re_rowCount) {
                        //echo "now no row count";
                        continue;
                    }

                    $query = $db->query("SELECT * FROM idevaff_email_" . $item['table_name']);
                    foreach ($query->fetch() as $key => $value) {
                        $stmt = $db->prepare("INSERT INTO idevaff_email_lang_phrases (`lang_id`, `key`, `value`) VALUES(?, ?, ?)");
                        $stmt->execute([$item['id'], $key, $value]);
                    }
                    $db->exec("DROP TABLE IF EXISTS idevaff_email_" . $item['table_name']);
                }
            }
        }
    }
} catch (Exception $e) {
    $ret_ajax['errors'][] = $e->getMessage();
}

?>