<?PHP

// ---------------------------------------------------------
// UPDATE FROM 9.3 TO 9.4
// ---------------------------------------------------------
	$version = '9.4';
// ---------------------------------------------------------

$db->query("DROP TABLE IF EXISTS idevaff_countries");
$db->query("DROP TABLE IF EXISTS idevaff_alert");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_countries (
  id int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  country_code text,
  country_code_2_digits text,
  country_name text,
  def tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  status int(10) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");

$db->query("INSERT INTO idevaff_countries (id, country_code, country_code_2_digits, country_name, def, status) VALUES
(1, 'AFG', 'AF', 'Afghanistan', 0, 1),
(2, 'ALA', 'AX', 'Åland Islands', 0, 1),
(3, 'ALB', 'AL', 'Albania', 0, 1),
(4, 'DZA', 'DZ', 'Algeria', 0, 1),
(5, 'ASM', 'AS', 'American Samoa', 0, 1),
(6, 'AND', 'AD', 'Andorra', 0, 1),
(7, 'AGO', 'AO', 'Angola', 0, 1),
(8, 'AIA', 'AI', 'Anguilla', 0, 1),
(9, 'ATA', 'AQ', 'Antarctica', 0, 1),
(10, 'ATG', 'AG', 'Antigua and Barbuda', 0, 1),
(11, 'ARG', 'AR', 'Argentina', 0, 1),
(12, 'ARM', 'AM', 'Armenia', 0, 1),
(13, 'ABW', 'AW', 'Aruba', 0, 1),
(14, 'AUS', 'AU', 'Australia', 0, 1),
(15, 'AUT', 'AT', 'Austria', 0, 1),
(16, 'AZE', 'AZ', 'Azerbaijan', 0, 1),
(17, 'BHS', 'BS', 'Bahamas', 0, 1),
(18, 'BHR', 'BH', 'Bahrain', 0, 1),
(19, 'BGD', 'BD', 'Bangladesh', 0, 1),
(20, 'BRB', 'BB', 'Barbados', 0, 1),
(21, 'BLR', 'BY', 'Belarus', 0, 1),
(22, 'BEL', 'BE', 'Belgium', 0, 1),
(23, 'BLZ', 'BZ', 'Belize', 0, 1),
(24, 'BEN', 'BJ', 'Benin', 0, 1),
(25, 'BMU', 'BM', 'Bermuda', 0, 1),
(26, 'BTN', 'BT', 'Bhutan', 0, 1),
(27, 'BOL', 'BO', 'Bolivia, Plurinational State of', 0, 1),
(28, 'BES', 'BQ', 'Bonaire, Sint Eustatius and Saba', 0, 1),
(29, 'BIH', 'BA', 'Bosnia and Herzegovina', 0, 1),
(30, 'BWA', 'BW', 'Botswana', 0, 1),
(31, 'BVT', 'BV', 'Bouvet Island', 0, 1),
(32, 'BRA', 'BR', 'Brazil', 0, 1),
(33, 'IOT', 'IO', 'British Indian Ocean Territory', 0, 1),
(34, 'BRN', 'BN', 'Brunei Darussalam', 0, 1),
(35, 'BGR', 'BG', 'Bulgaria', 0, 1),
(36, 'BFA', 'BF', 'Burkina Faso', 0, 1),
(37, 'BDI', 'BI', 'Burundi', 0, 1),
(38, 'KHM', 'KH', 'Cambodia', 0, 1),
(39, 'CMR', 'CM', 'Cameroon', 0, 1),
(40, 'CAN', 'CA', 'Canada', 0, 1),
(41, 'CPV', 'CV', 'Cape Verde', 0, 1),
(42, 'CYM', 'KY', 'Cayman Islands', 0, 1),
(43, 'CAF', 'CF', 'Central African Republic', 0, 1),
(44, 'TCD', 'TD', 'Chad', 0, 1),
(45, 'CHL', 'CL', 'Chile', 0, 1),
(46, 'CHN', 'CN', 'China', 0, 1),
(47, 'CXR', 'CX', 'Christmas Island', 0, 1),
(48, 'CCK', 'CC', 'Cocos (Keeling) Islands', 0, 1),
(49, 'COL', 'CO', 'Colombia', 0, 1),
(50, 'COM', 'KM', 'Comoros', 0, 1),
(51, 'COG', 'CG', 'Congo', 0, 1),
(52, 'COD', 'CD', 'Congo, the Democratic Republic of the', 0, 1),
(53, 'COK', 'CK', 'Cook Islands', 0, 1),
(54, 'CRI', 'CR', 'Costa Rica', 0, 1),
(55, 'CIV', 'CI', 'Côte d\'Ivoire', 0, 1),
(56, 'HRV', 'HR', 'Croatia', 0, 1),
(57, 'CUB', 'CU', 'Cuba', 0, 1),
(58, 'CUW', 'CW', 'Curaçao', 0, 1),
(59, 'CYP', 'CY', 'Cyprus', 0, 1),
(60, 'CZE', 'CZ', 'Czech Republic', 0, 1),
(61, 'DNK', 'DK', 'Denmark', 0, 1),
(62, 'DJI', 'DJ', 'Djibouti', 0, 1),
(63, 'DMA', 'DM', 'Dominica', 0, 1),
(64, 'DOM', 'DO', 'Dominican Republic', 0, 1),
(65, 'ECU', 'EC', 'Ecuador', 0, 1),
(66, 'EGY', 'EG', 'Egypt', 0, 1),
(67, 'SLV', 'SV', 'El Salvador', 0, 1),
(68, 'GNQ', 'GQ', 'Equatorial Guinea', 0, 1),
(69, 'ERI', 'ER', 'Eritrea', 0, 1),
(70, 'EST', 'EE', 'Estonia', 0, 1),
(71, 'ETH', 'ET', 'Ethiopia', 0, 1),
(72, 'FLK', 'FK', 'Falkland Islands (Malvinas)', 0, 1),
(73, 'FRO', 'FO', 'Faroe Islands', 0, 1),
(74, 'FJI', 'FJ', 'Fiji', 0, 1),
(75, 'FIN', 'FI', 'Finland', 0, 1),
(76, 'FRA', 'FR', 'France', 0, 1),
(77, 'GUF', 'GF', 'French Guiana', 0, 1),
(78, 'PYF', 'PF', 'French Polynesia', 0, 1),
(79, 'ATF', 'TF', 'French Southern Territories', 0, 1),
(80, 'GAB', 'GA', 'Gabon', 0, 1),
(81, 'GMB', 'GM', 'Gambia', 0, 1),
(82, 'GEO', 'GE', 'Georgia', 0, 1),
(83, 'DEU', 'DE', 'Germany', 0, 1),
(84, 'GHA', 'GH', 'Ghana', 0, 1),
(85, 'GIB', 'GI', 'Gibraltar', 0, 1),
(86, 'GRC', 'GR', 'Greece', 0, 1),
(87, 'GRL', 'GL', 'Greenland', 0, 1),
(88, 'GRD', 'GD', 'Grenada', 0, 1),
(89, 'GLP', 'GP', 'Guadeloupe', 0, 1),
(90, 'GUM', 'GU', 'Guam', 0, 1),
(91, 'GTM', 'GT', 'Guatemala', 0, 1),
(92, 'GGY', 'GG', 'Guernsey', 0, 1),
(93, 'GIN', 'GN', 'Guinea', 0, 1),
(94, 'GNB', 'GW', 'Guinea-Bissau', 0, 1),
(95, 'GUY', 'GY', 'Guyana', 0, 1),
(96, 'HTI', 'HT', 'Haiti', 0, 1),
(97, 'HMD', 'HM', 'Heard Island and McDonald Islands', 0, 1),
(98, 'VAT', 'VA', 'Holy See (Vatican City State)', 0, 1),
(99, 'HND', 'HN', 'Honduras', 0, 1),
(100, 'HKG', 'HK', 'Hong Kong', 0, 1),
(101, 'HUN', 'HU', 'Hungary', 0, 1),
(102, 'ISL', 'IS', 'Iceland', 0, 1),
(103, 'IND', 'IN', 'India', 0, 1),
(104, 'IDN', 'ID', 'Indonesia', 0, 1),
(105, 'IRN', 'IR', 'Iran, Islamic Republic of', 0, 1),
(106, 'IRQ', 'IQ', 'Iraq', 0, 1),
(107, 'IRL', 'IE', 'Ireland', 0, 1),
(108, 'IMN', 'IM', 'Isle of Man', 0, 1),
(109, 'ISR', 'IL', 'Israel', 0, 1),
(110, 'ITA', 'IT', 'Italy', 0, 1),
(111, 'JAM', 'JM', 'Jamaica', 0, 1),
(112, 'JPN', 'JP', 'Japan', 0, 1),
(113, 'JEY', 'JE', 'Jersey', 0, 1),
(114, 'JOR', 'JO', 'Jordan', 0, 1),
(115, 'KAZ', 'KZ', 'Kazakhstan', 0, 1),
(116, 'KEN', 'KE', 'Kenya', 0, 1),
(117, 'KIR', 'KI', 'Kiribati', 0, 1),
(118, 'PRK', 'KP', 'Korea, Democratic People\'s Republic of', 0, 1),
(119, 'KOR', 'KR', 'Korea, Republic of', 0, 1),
(120, 'KWT', 'KW', 'Kuwait', 0, 1),
(121, 'KGZ', 'KG', 'Kyrgyzstan', 0, 1),
(122, 'LAO', 'LA', 'Lao People\'s Democratic Republic', 0, 1),
(123, 'LVA', 'LV', 'Latvia', 0, 1),
(124, 'LBN', 'LB', 'Lebanon', 0, 1),
(125, 'LSO', 'LS', 'Lesotho', 0, 1),
(126, 'LBR', 'LR', 'Liberia', 0, 1),
(127, 'LBY', 'LY', 'Libya', 0, 1),
(128, 'LIE', 'LI', 'Liechtenstein', 0, 1),
(129, 'LTU', 'LT', 'Lithuania', 0, 1),
(130, 'LUX', 'LU', 'Luxembourg', 0, 1),
(131, 'MAC', 'MO', 'Macao', 0, 1),
(132, 'MKD', 'MG', 'Macedonia, the former Yugoslav Republic of', 0, 1),
(133, 'MDG', 'MW', 'Madagascar', 0, 1),
(134, 'MWI', 'MY', 'Malawi', 0, 1),
(135, 'MYS', 'MV', 'Malaysia', 0, 1),
(136, 'MDV', 'ML', 'Maldives', 0, 1),
(137, 'MLI', 'MT', 'Mali', 0, 1),
(138, 'MLT', 'MH', 'Malta', 0, 1),
(139, 'MHL', 'MQ', 'Marshall Islands', 0, 1),
(140, 'MTQ', 'MR', 'Martinique', 0, 1),
(141, 'MRT', 'MU', 'Mauritania', 0, 1),
(142, 'MUS', 'YT', 'Mauritius', 0, 1),
(143, 'MYT', 'MX', 'Mayotte', 0, 1),
(144, 'MEX', 'FM', 'Mexico', 0, 1),
(145, 'FSM', 'MD', 'Micronesia, Federated States of', 0, 1),
(146, 'MDA', 'MC', 'Moldova, Republic of', 0, 1),
(147, 'MCO', 'MN', 'Monaco', 0, 1),
(148, 'MNG', 'ME', 'Mongolia', 0, 1),
(149, 'MNE', 'MS', 'Montenegro', 0, 1),
(150, 'MSR', 'MA', 'Montserrat', 0, 1),
(151, 'MAR', 'MZ', 'Morocco', 0, 1),
(152, 'MOZ', 'MM', 'Mozambique', 0, 1),
(153, 'MMR', 'NA', 'Myanmar', 0, 1),
(154, 'NAM', 'NR', 'Namibia', 0, 1),
(155, 'NRU', 'NP', 'Nauru', 0, 1),
(156, 'NPL', 'NL', 'Nepal', 0, 1),
(157, 'NLD', 'NC', 'Netherlands', 0, 1),
(158, 'NCL', 'NZ', 'New Caledonia', 0, 1),
(159, 'NZL', 'NI', 'New Zealand', 0, 1),
(160, 'NIC', 'NE', 'Nicaragua', 0, 1),
(161, 'NER', 'NG', 'Niger', 0, 1),
(162, 'NGA', 'NU', 'Nigeria', 0, 1),
(163, 'NIU', 'NF', 'Niue', 0, 1),
(164, 'NFK', 'MK', 'Norfolk Island', 0, 1),
(165, 'MNP', 'MP', 'Northern Mariana Islands', 0, 1),
(166, 'NOR', 'NO', 'Norway', 0, 1),
(167, 'OMN', 'OM', 'Oman', 0, 1),
(168, 'PAK', 'PK', 'Pakistan', 0, 1),
(169, 'PLW', 'PW', 'Palau', 0, 1),
(170, 'PSE', 'PS', 'Palestinian Territory, Occupied', 0, 1),
(171, 'PAN', 'PA', 'Panama', 0, 1),
(172, 'PNG', 'PG', 'Papua New Guinea', 0, 1),
(173, 'PRY', 'PY', 'Paraguay', 0, 1),
(174, 'PER', 'PE', 'Peru', 0, 1),
(175, 'PHL', 'PH', 'Philippines', 0, 1),
(176, 'PCN', 'PN', 'Pitcairn', 0, 1),
(177, 'POL', 'PL', 'Poland', 0, 1),
(178, 'PRT', 'PT', 'Portugal', 0, 1),
(179, 'PRI', 'PR', 'Puerto Rico', 0, 1),
(180, 'QAT', 'QA', 'Qatar', 0, 1),
(181, 'REU', 'RE', 'Réunion', 0, 1),
(182, 'ROU', 'RO', 'Romania', 0, 1),
(183, 'RUS', 'RU', 'Russian Federation', 0, 1),
(184, 'RWA', 'RW', 'Rwanda', 0, 1),
(185, 'BLM', 'BL', 'Saint Barthélemy', 0, 1),
(186, 'SHN', 'SH', 'Saint Helena, Ascension and Tristan da Cunha', 0, 1),
(187, 'KNA', 'KN', 'Saint Kitts and Nevis', 0, 1),
(188, 'LCA', 'LC', 'Saint Lucia', 0, 1),
(189, 'MAF', 'MF', 'Saint Martin (French part)', 0, 1),
(190, 'SPM', 'PM', 'Saint Pierre and Miquelon', 0, 1),
(191, 'VCT', 'VC', 'Saint Vincent and the Grenadines', 0, 1),
(192, 'WSM', 'WS', 'Samoa', 0, 1),
(193, 'SMR', 'SM', 'San Marino', 0, 1),
(194, 'STP', 'ST', 'Sao Tome and Principe', 0, 1),
(195, 'SAU', 'SA', 'Saudi Arabia', 0, 1),
(196, 'SEN', 'SN', 'Senegal', 0, 1),
(197, 'SRB', 'RS', 'Serbia', 0, 1),
(198, 'SYC', 'SC', 'Seychelles', 0, 1),
(199, 'SLE', 'SL', 'Sierra Leone', 0, 1),
(200, 'SGP', 'SG', 'Singapore', 0, 1),
(201, 'SXM', 'SX', 'Sint Maarten (Dutch part)', 0, 1),
(202, 'SVK', 'SK', 'Slovakia', 0, 1),
(203, 'SVN', 'SI', 'Slovenia', 0, 1),
(204, 'SLB', 'SB', 'Solomon Islands', 0, 1),
(205, 'SOM', 'SO', 'Somalia', 0, 1),
(206, 'ZAF', 'ZA', 'South Africa', 0, 1),
(207, 'SGS', 'GS', 'South Georgia and the South Sandwich Islands', 0, 1),
(208, 'SSD', 'SS', 'South Sudan', 0, 1),
(209, 'ESP', 'ES', 'Spain', 0, 1),
(210, 'LKA', 'LK', 'Sri Lanka', 0, 1),
(211, 'SDN', 'SD', 'Sudan', 0, 1),
(212, 'SUR', 'SR', 'Suriname', 0, 1),
(213, 'SJM', 'SJ', 'Svalbard and Jan Mayen', 0, 1),
(214, 'SWZ', 'SZ', 'Swaziland', 0, 1),
(215, 'SWE', 'SE', 'Sweden', 0, 1),
(216, 'CHE', 'CH', 'Switzerland', 0, 1),
(217, 'SYR', 'SY', 'Syrian Arab Republic', 0, 1),
(218, 'TWN', 'TW', 'Taiwan, Province of China', 0, 1),
(219, 'TJK', 'TJ', 'Tajikistan', 0, 1),
(220, 'TZA', 'TZ', 'Tanzania, United Republic of', 0, 1),
(221, 'THA', 'TH', 'Thailand', 0, 1),
(222, 'TLS', 'TL', 'Timor-Leste', 0, 1),
(223, 'TGO', 'TG', 'Togo', 0, 1),
(224, 'TKL', 'TK', 'Tokelau', 0, 1),
(225, 'TON', 'TO', 'Tonga', 0, 1),
(226, 'TTO', 'TT', 'Trinidad and Tobago', 0, 1),
(227, 'TUN', 'TN', 'Tunisia', 0, 1),
(228, 'TUR', 'TR', 'Turkey', 0, 1),
(229, 'TKM', 'TM', 'Turkmenistan', 0, 1),
(230, 'TCA', 'TC', 'Turks and Caicos Islands', 0, 1),
(231, 'TUV', 'TV', 'Tuvalu', 0, 1),
(232, 'UGA', 'UG', 'Uganda', 0, 1),
(233, 'UKR', 'UA', 'Ukraine', 0, 1),
(234, 'ARE', 'AE', 'United Arab Emirates', 0, 1),
(235, 'GBR', 'GB', 'United Kingdom', 0, 1),
(236, 'USA', 'US', 'United States', 1, 1),
(237, 'UMI', 'UM', 'United States Minor Outlying Islands', 0, 1),
(238, 'URY', 'UY', 'Uruguay', 0, 1),
(239, 'UZB', 'UZ', 'Uzbekistan', 0, 1),
(240, 'VUT', 'VU', 'Vanuatu', 0, 1),
(241, 'VEN', 'VE', 'Venezuela, Bolivarian Republic of', 0, 1),
(242, 'VNM', 'VN', 'Viet Nam', 0, 1),
(243, 'VGB', 'VG', 'Virgin Islands, British', 0, 1),
(244, 'VIR', 'VI', 'Virgin Islands, U.S.', 0, 1),
(245, 'WLF', 'WF', 'Wallis and Futuna', 0, 1),
(246, 'ESH', 'EH', 'Western Sahara', 0, 1),
(247, 'YEM', 'YE', 'Yemen', 0, 1),
(248, 'ZMB', 'ZM', 'Zambia', 0, 1),
(249, 'ZWE', 'ZW', 'Zimbabwe', 0, 1)
");



// ---------------------------------------------------------
// LANGUAGE PACK UPDATES
// ---------------------------------------------------------
     include_once("upgrade/language_updates/" . $version . "/updates.php");
	 
	 
// ---------------------------------------------------------
// GENERAL DB UPDATES NOW
// ---------------------------------------------------------
try {
    $db->query('CREATE TABLE idevaff_admin_temp LIKE idevaff_admin');
	
    $db->query("ALTER TABLE `idevaff_admin_temp` 
					CHANGE record record tinyint UNSIGNED NOT NULL AUTO_INCREMENT,
					CHANGE super super tinyint unsigned NOT NULL DEFAULT 0,
					CHANGE email email varchar(255) NULL,
					CHANGE code code bigint unsigned NOT NULL DEFAULT 0
					");
	
    $db->query("INSERT INTO idevaff_admin_temp SELECT * FROM idevaff_admin");
    $db->query("DROP TABLE `idevaff_admin`");
    $db->query("RENAME TABLE `idevaff_admin_temp` TO `idevaff_admin`");

} catch ( Exception $ex ) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try {
    $db->query('CREATE TABLE `idevaff_affiliates_temp` LIKE `idevaff_affiliates`');

    $db->query("ALTER TABLE `idevaff_affiliates_temp` 
                    CHANGE id id int unsigned NOT NULL auto_increment,
                    CHANGE username username varchar(512) NULL,
                    CHANGE password password varchar(512) NULL,
                    CHANGE approved approved tinyint unsigned NOT NULL DEFAULT 0,
                    CHANGE suspended suspended tinyint unsigned NOT NULL DEFAULT 0,
					CHANGE payable payable varchar(64) NULL,
					CHANGE tax_id_ssn tax_id_ssn blob NULL,
					CHANGE company company varchar(128) NULL,
					CHANGE f_name f_name varchar(64) NULL,
					CHANGE l_name l_name varchar(64) NULL,
					CHANGE email email varchar(64) NULL,
					CHANGE address_1 address_1 varchar(64) NULL,
					CHANGE address_2 address_2 varchar(64) NULL,
					CHANGE city city varchar(64) NULL,
					CHANGE state state varchar(40) NULL,
					CHANGE zip zip varchar(20) NULL,
					CHANGE country country varchar(64) NULL,
					CHANGE phone phone varchar(40) NULL,
					CHANGE fax fax varchar(40) NULL,
					CHANGE url url varchar(128) NULL,
                    CHANGE pp pp tinyint unsigned NOT NULL DEFAULT 0,
					CHANGE paypal paypal varchar(64) NULL,
                    CHANGE hits_in hits_in int unsigned NOT NULL DEFAULT 0,
                    CHANGE unique_hits_in unique_hits_in int unsigned NOT NULL DEFAULT 0,
                    CHANGE conv conv int unsigned NOT NULL DEFAULT 0,
                    CHANGE type type tinyint unsigned NOT NULL DEFAULT 0,
                    CHANGE level level tinyint unsigned NOT NULL DEFAULT 0,
                    CHANGE a1 a1 tinyint unsigned NOT NULL DEFAULT 1,
                    CHANGE a2 a2 tinyint unsigned NOT NULL DEFAULT 1,
                    CHANGE a3 a3 tinyint unsigned NOT NULL DEFAULT 1,
                    CHANGE alert alert tinyint unsigned NOT NULL DEFAULT 0,
                    CHANGE installed installed tinyint unsigned NOT NULL DEFAULT 0,
                    CHANGE signup_date signup_date bigint unsigned NOT NULL DEFAULT 0,
					CHANGE email_override email_override varchar(64) NULL,
                    CHANGE tc_status tc_status tinyint unsigned NOT NULL DEFAULT 0,
					CHANGE ip ip varchar(64) NULL,
                    CHANGE pay_method pay_method tinyint unsigned NOT NULL DEFAULT 0,
                    CHANGE vat_override vat_override tinyint unsigned NOT NULL DEFAULT 0,
                    CHANGE expire expire int unsigned NOT NULL DEFAULT 0,
                    CHANGE expire_type expire_type tinyint unsigned NOT NULL DEFAULT 0,
                    CHANGE expire_stamp expire_stamp bigint unsigned NOT NULL DEFAULT 0
                    ");

    $db->query("INSERT INTO `idevaff_affiliates_temp` SELECT * FROM `idevaff_affiliates`");
    $db->query("DROP TABLE `idevaff_affiliates`");
    $db->query("RENAME TABLE `idevaff_affiliates_temp` TO `idevaff_affiliates`");

} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try {

    $db->query("CREATE TABLE idevaff_archive_temp LIKE idevaff_archive");

    $db->query("ALTER TABLE idevaff_archive_temp 
                            CHANGE record record int unsigned NOT NULL auto_increment,
                            CHANGE id id int unsigned NOT NULL DEFAULT 0,
                            CHANGE tier tier int unsigned NOT NULL DEFAULT 0,
							CHANGE top_tier_tag top_tier_tag tinyint unsigned NOT NULL DEFAULT 0,
                            CHANGE bonus bonus tinyint unsigned NOT NULL DEFAULT 0,
                            CHANGE stamp stamp bigint unsigned NOT NULL DEFAULT 0,
                            CHANGE tier_id tier_id int unsigned NOT NULL DEFAULT 0,
							CHANGE tracking tracking varchar(64) NULL,
							CHANGE op1 op1 varchar(64) NULL,
							CHANGE op2 op2 varchar(64) NULL,
							CHANGE op3 op3 varchar(64) NULL,
                            CHANGE type type tinyint unsigned NOT NULL DEFAULT 0,
							CHANGE split split varchar(128) NULL,
                            CHANGE profile profile int unsigned NOT NULL DEFAULT 0,
							CHANGE tid1 tid1 varchar(255) NULL,
							CHANGE tid2 tid2 varchar(255) NULL,
							CHANGE tid3 tid3 varchar(255) NULL,
							CHANGE tid4 tid4 varchar(255) NULL,
							CHANGE sub_id sub_id varchar(64) NULL,
							CHANGE payment_rec payment_rec varchar(255) NULL,
							CHANGE converted_amount converted_amount decimal(20,2) NOT NULL DEFAULT 0.00,
                            CHANGE override override tinyint unsigned NOT NULL DEFAULT 0,
                            CHANGE override_id override_id int unsigned NOT NULL DEFAULT 0,    
                            CHANGE code code bigint unsigned NOT NULL DEFAULT 0,
                            CHANGE geo geo varchar(2) NULL,
                            CHANGE amount amount decimal(20,2) NOT NULL default 0.00,
                            CHANGE payment payment decimal(20,2) NOT NULL default 0.00,
							CHANGE currency currency varchar(10) NULL,
							CHANGE target_url target_url varchar(500) NULL,
							CHANGE referring_url referring_url varchar(500) NULL
                            ");

    $db->query("INSERT INTO idevaff_archive_temp SELECT * FROM idevaff_archive");
    $db->query("DROP TABLE idevaff_archive");
    $db->query("RENAME TABLE idevaff_archive_temp TO idevaff_archive");

} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try {
    $db->query("ALTER TABLE idevaff_custom_links CHANGE url url varchar(500) NULL");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try {
    $db->query("CREATE TABLE idevaff_deleted_accounts_temp LIKE idevaff_deleted_accounts");
    $db->query("ALTER TABLE idevaff_deleted_accounts_temp 
                        CHANGE id id int unsigned NOT NULL auto_increment,
                        CHANGE username username varchar(512) NULL,
                        CHANGE password password varchar(512) NULL,
                        CHANGE approved approved tinyint unsigned NOT NULL DEFAULT 0,
                        CHANGE suspended suspended tinyint unsigned NOT NULL DEFAULT 0,
                        CHANGE pp pp tinyint unsigned NOT NULL DEFAULT 0,
                        CHANGE hits_in hits_in int unsigned NOT NULL DEFAULT 0,
                        CHANGE unique_hits_in unique_hits_in int unsigned NOT NULL DEFAULT 0,
                        CHANGE conv conv int unsigned NOT NULL DEFAULT 0,
                        CHANGE type type tinyint unsigned NOT NULL DEFAULT 0,
                        CHANGE level level tinyint unsigned NOT NULL DEFAULT 0,
                        CHANGE a1 a1 tinyint unsigned NOT NULL DEFAULT 1,
                        CHANGE a2 a2 tinyint unsigned NOT NULL DEFAULT 1,
                        CHANGE a3 a3 tinyint unsigned NOT NULL DEFAULT 1,
                        CHANGE alert alert tinyint unsigned NOT NULL DEFAULT 0,
                        CHANGE installed installed tinyint unsigned NOT NULL DEFAULT 0,
                        CHANGE signup_date signup_date bigint unsigned NOT NULL DEFAULT 0, 
                        CHANGE tc_status tc_status tinyint unsigned NOT NULL DEFAULT 0,
                        CHANGE pay_method pay_method tinyint unsigned NOT NULL DEFAULT 0, 
                        CHANGE vat_override vat_override tinyint unsigned NOT NULL DEFAULT 0, 
                        CHANGE expire expire int unsigned NOT NULL DEFAULT 0,
                        CHANGE expire_type expire_type tinyint unsigned NOT NULL DEFAULT 0, 
                        CHANGE expire_stamp expire_stamp bigint unsigned NOT NULL DEFAULT 0
                        ");

    $db->query("INSERT INTO idevaff_deleted_accounts_temp SELECT * FROM idevaff_deleted_accounts");
    $db->query("DROP TABLE idevaff_deleted_accounts");
    $db->query("RENAME TABLE idevaff_deleted_accounts_temp TO idevaff_deleted_accounts");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try {
    $db->query("CREATE TABLE idevaff_deleted_sales_temp LIKE idevaff_deleted_sales");

    $db->query("ALTER TABLE idevaff_deleted_sales_temp 
                        CHANGE record record int unsigned NOT NULL auto_increment,
                        CHANGE id id int unsigned NOT NULL DEFAULT 0,
                        CHANGE top_tier_tag top_tier_tag tinyint unsigned NOT NULL DEFAULT 0,
                        CHANGE bonus bonus tinyint unsigned NOT NULL DEFAULT 0, 
                        CHANGE approved approved tinyint unsigned NOT NULL DEFAULT 0, 
                        CHANGE code code bigint unsigned NOT NULL DEFAULT 0, 
                        CHANGE tier_id tier_id int unsigned NOT NULL DEFAULT 0, 
                        CHANGE rec_id rec_id int unsigned NOT NULL DEFAULT 0, 
                        CHANGE type type tinyint unsigned NOT NULL DEFAULT 0,
                        CHANGE payment payment decimal(20,2) NOT NULL DEFAULT 0.00, 
                        CHANGE amount amount decimal(20,2) NOT NULL DEFAULT 0.00, 
                        CHANGE profile profile int unsigned NOT NULL DEFAULT 0, 
                        CHANGE delay delay int unsigned NOT NULL DEFAULT 0, 
                        CHANGE override override tinyint unsigned NOT NULL DEFAULT 0,
                        CHANGE override_id override_id int unsigned NOT NULL DEFAULT 0, 
                        CHANGE geo geo varchar(2) NULL, 
                        CHANGE conversion_time conversion_time bigint unsigned NOT NULL DEFAULT 0, 
                        CHANGE alt_amt alt_amt tinyint unsigned NOT NULL DEFAULT 0,
						CHANGE currency currency varchar(10) NULL,
						CHANGE target_url target_url varchar(500) NULL,
						CHANGE referring_url referring_url varchar(500) NULL
                        ");
    $db->query("INSERT INTO idevaff_deleted_sales_temp SELECT * FROM idevaff_deleted_sales");
    $db->query("DROP TABLE idevaff_deleted_sales");
    $db->query("RENAME TABLE idevaff_deleted_sales_temp TO idevaff_deleted_sales");

} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("CREATE TABLE idevaff_general_sales_temp LIKE idevaff_general_sales");

    $db->query("ALTER TABLE idevaff_general_sales_temp 
						CHANGE id id int unsigned NOT NULL auto_increment,
						CHANGE time_stamp time_stamp bigint unsigned NOT NULL DEFAULT 0,
                        CHANGE order_number order_number varchar(64) NULL, 
						CHANGE geo geo varchar(2) NULL, 
                        CHANGE sale_amount sale_amount decimal(20,2) NOT NULL default 0.00, 
						CHANGE customer_ip customer_ip varchar(64) NULL, 
                        CHANGE converted_amount converted_amount decimal(20,2) NOT NULL default 0.00,
						CHANGE currency currency varchar(10) NULL
                        ");

    $db->query("INSERT INTO idevaff_general_sales_temp SELECT * FROM idevaff_general_sales");
    $db->query("DROP TABLE idevaff_general_sales");
    $db->query("RENAME TABLE idevaff_general_sales_temp TO idevaff_general_sales");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try {
    $db->query("CREATE TABLE idevaff_invoice_temp LIKE idevaff_invoice");
    $db->query("ALTER TABLE idevaff_invoice_temp CHANGE invoice_prefix invoice_prefix varchar(50) NULL");
    $db->query("INSERT INTO idevaff_invoice_temp SELECT * FROM idevaff_invoice");
    $db->query("DROP TABLE idevaff_invoice");
    $db->query("RENAME TABLE idevaff_invoice_temp TO idevaff_invoice");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}


try {
    // create temp table
    $db->query('CREATE TABLE idevaff_iptracking_temp LIKE idevaff_iptracking;');

    $db->query("ALTER TABLE idevaff_iptracking_temp 
                        CHANGE id id int unsigned NOT NULL auto_increment,
                        CHANGE acct_id acct_id int unsigned NOT NULL DEFAULT 0,
						CHANGE ip ip varchar(64) NULL,
						CHANGE refer refer varchar(500) NULL,
                        CHANGE stamp stamp bigint unsigned NOT NULL DEFAULT 0,
						CHANGE hit_time hit_time varchar(128) NULL,
						CHANGE hit_date hit_date varchar(128) NULL,
                        CHANGE src1 src1 int unsigned NOT NULL DEFAULT 0, 
                        CHANGE src2 src2 int unsigned NOT NULL DEFAULT 0,
						CHANGE split split varchar(128) NULL,
						CHANGE sub_id sub_id varchar(64) NULL,
						CHANGE tid1 tid1 varchar(64) NULL,
						CHANGE tid2 tid2 varchar(64) NULL,
						CHANGE tid3 tid3 varchar(64) NULL,
						CHANGE tid4 tid4 varchar(64) NULL,
                        CHANGE target_url target_url varchar(500) NULL, 
                        CHANGE geo geo varchar(2) NULL
                        ");

    // CODE FROM db_index.php START
    try {
        $st = $db->prepare("SHOW KEYS FROM `idevaff_iptracking_temp` WHERE Key_name='acct_id'");
        $st->execute();
        if ( $st->rowCount() == 0 ) {
            $db->query("ALTER TABLE idevaff_iptracking_temp ADD INDEX (acct_id)");
        }
    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }
    try {
        $st = $db->prepare("SHOW KEYS FROM `idevaff_iptracking_temp` WHERE Key_name='stamp'");
        $st->execute();

        if ( $st->rowCount() == 0 ) {
            $db->query("ALTER TABLE idevaff_iptracking_temp ADD INDEX (stamp)");
        }
    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }
    try {
        $st = $db->prepare("SHOW KEYS FROM `idevaff_iptracking_temp` WHERE Key_name='ip'");
        $st->execute();

        if ( $st->rowCount() == 0 ) {
            $db->query("ALTER TABLE idevaff_iptracking_temp ADD INDEX (ip)");
        }
    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }

    // CODE FROM db_index.php END


    // Copy All data
    $db->query("INSERT INTO idevaff_iptracking_temp SELECT * FROM idevaff_iptracking");

    // rename old/current table
    $db->exec("DROP TABLE `idevaff_iptracking`");

    // rename temp table to old table
    $db->exec("RENAME TABLE `idevaff_iptracking_temp` TO `idevaff_iptracking`");

} catch (Exception $exception) {
    $ret_ajax['errors'][] = $exception->getMessage();
}

try {
    // create temp table
    $db->query('CREATE TABLE idevaff_payments_temp LIKE idevaff_payments;');
    $db->query("ALTER TABLE idevaff_payments_temp 
                            CHANGE record record int unsigned NOT NULL auto_increment,
                            CHANGE stamp stamp bigint unsigned NOT NULL DEFAULT 0,
                            CHANGE export export tinyint unsigned NOT NULL DEFAULT 0, 
                            CHANGE code code bigint unsigned NOT NULL DEFAULT 0
                            ");

    // Copy All data
    $db->query("INSERT INTO idevaff_payments_temp SELECT * FROM idevaff_payments");

    // rename old/current table
    $db->exec("DROP TABLE `idevaff_payments`");

    // rename temp table to old table
    $db->exec("RENAME TABLE `idevaff_payments_temp` TO `idevaff_payments`");

} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try {
    // create temp table
    $db->query('CREATE TABLE idevaff_sales_temp LIKE idevaff_sales;');
    $db->query("ALTER TABLE idevaff_sales_temp 
                        CHANGE record record int unsigned NOT NULL auto_increment, 
                        CHANGE id id int unsigned NOT NULL DEFAULT 0, 
                        CHANGE top_tier_tag top_tier_tag tinyint unsigned NOT NULL DEFAULT 0, 
                        CHANGE bonus bonus tinyint unsigned NOT NULL DEFAULT 0, 
                        CHANGE approved approved tinyint unsigned NOT NULL DEFAULT 0, 
						CHANGE ip ip varchar(64)NULL,
                        CHANGE code code bigint unsigned NOT NULL DEFAULT 0, 
						CHANGE tracking tracking varchar(64)NULL,
                        CHANGE tier_id tier_id int unsigned NOT NULL DEFAULT 0, 
                        CHANGE rec_id rec_id int unsigned NOT NULL DEFAULT 0, 
                        CHANGE type type tinyint unsigned NOT NULL DEFAULT 0, 
                        CHANGE payment payment decimal(20,2) NOT NULL DEFAULT 0.00, 
						CHANGE op1 op1 varchar(64)NULL,
						CHANGE op2 op2 varchar(64)NULL,
						CHANGE op3 op3 varchar(64)NULL,
                        CHANGE amount amount decimal(20,2) NOT NULL DEFAULT 0.00, 
						CHANGE split split varchar(128)NULL,
						CHANGE adm_alert adm_alert tinyint unsigned NOT NULL DEFAULT 0,
						CHANGE aff_alert aff_alert tinyint unsigned NOT NULL DEFAULT 0,
						CHANGE sub_id sub_id varchar(64)NULL,
						CHANGE tid1 tid1 varchar(255)NULL,
						CHANGE tid2 tid2 varchar(255)NULL,
						CHANGE tid3 tid3 varchar(255)NULL,
						CHANGE tid4 tid4 varchar(255)NULL,
                        CHANGE profile profile int unsigned NOT NULL DEFAULT 0, 
                        CHANGE delay delay int unsigned NOT NULL DEFAULT 0, 
                        CHANGE target_url target_url varchar(500) NULL, 
                        CHANGE override override tinyint unsigned NOT NULL DEFAULT 0, 
                        CHANGE override_id override_id int unsigned NOT NULL DEFAULT 0,
                        CHANGE geo geo varchar(2) NULL,
                        CHANGE conversion_time conversion_time bigint unsigned NOT NULL DEFAULT 0,
                        CHANGE alt_amt alt_amt tinyint unsigned NOT NULL DEFAULT 0,
						CHANGE currency currency varchar(10) NULL,
						CHANGE converted_amount converted_amount decimal(20,2) NOT NULL default 0.00,
						CHANGE referring_url referring_url varchar(500) NULL
                        ");
					
    try {
        $st = $db->prepare("SHOW KEYS FROM `idevaff_sales_temp` WHERE Key_name='bonus_approved'");
        $st->execute();
        if ( $st->rowCount() == 0 ) {
            $db->query("ALTER TABLE idevaff_sales_temp ADD INDEX bonus_approved (bonus,approved)");
        }
    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }
	
	//$db->query("ALTER TABLE idevaff_sales_temp ADD KEY bonus_approved (bonus,approved)");

    // Copy All data
    $db->query("INSERT INTO idevaff_sales_temp SELECT * FROM idevaff_sales");

    // rename old/current table
    $db->exec("DROP TABLE `idevaff_sales`");

    // rename temp table to old table
    $db->exec("RENAME TABLE `idevaff_sales_temp` TO `idevaff_sales`");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try {
    $db->query("ALTER TABLE idevaff_video_cats CHANGE id id int unsigned NOT NULL DEFAULT 0");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try {
    $db->query("ALTER TABLE idevaff_video_library 
                            CHANGE id id int unsigned NOT NULL auto_increment,
                            CHANGE video_cat video_cat int unsigned NOT NULL DEFAULT 0,
                            CHANGE video_enabled video_enabled tinyint unsigned NOT NULL DEFAULT 1 
                            ");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try {
    $db->query("ALTER TABLE idevaff_video_options 
                            CHANGE id id int unsigned NOT NULL auto_increment,
                            CHANGE days_initial days_initial int unsigned NOT NULL DEFAULT 0,
                            CHANGE days_recurring days_recurring int unsigned NOT NULL DEFAULT 0,
                            CHANGE days days int unsigned NOT NULL DEFAULT 0
                            ");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try {
    $db->query("ALTER TABLE idevaff_video_settings
                            CHANGE enabled enabled tinyint unsigned NOT NULL DEFAULT 0,
                            CHANGE sidebar sidebar tinyint unsigned NOT NULL DEFAULT 0
                            ");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try {
    $db->query("ALTER TABLE idevaff_ads
                            CHANGE id id int unsigned NOT NULL auto_increment,
                            CHANGE grp grp int unsigned NOT NULL DEFAULT 0,
							CHANGE title title varchar(64) NULL,
							CHANGE `text` `text` TEXT CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
							CHANGE hits hits int unsigned NOT NULL DEFAULT 0,
							CHANGE conv conv int unsigned NOT NULL DEFAULT 0,
							CHANGE sort sort int NOT NULL DEFAULT 0
                            ");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try {
    $db->query("ALTER TABLE idevaff_ads_default
                            CHANGE ad_target ad_target varchar(10) NULL,
							CHANGE BoxWidth BoxWidth varchar(10) NULL,
							CHANGE OutlineColor OutlineColor varchar(10) NULL,
							CHANGE TitleTextColor TitleTextColor varchar(10) NULL,
							CHANGE TitleTextBackgroundColor TitleTextBackgroundColor varchar(10) NULL,
							CHANGE LinkColor LinkColor varchar(10) NULL,
							CHANGE TextColor TextColor varchar(10) NULL,
							CHANGE TextBackgroundColor TextBackgroundColor varchar(10) NULL,
							CHANGE title title varchar(64) NULL,
							CHANGE content content text NULL
                            ");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try {
    $db->query("ALTER TABLE idevaff_banned_email
                            CHANGE id id int unsigned NOT NULL auto_increment,
							CHANGE email_address email_address varchar(255) NULL
                            ");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("ALTER TABLE idevaff_banned_ip
                            CHANGE id id int unsigned NOT NULL auto_increment,
							CHANGE ip_address ip_address varchar(255) NULL
                            ");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("ALTER TABLE idevaff_ipblock
                            CHANGE id id int unsigned NOT NULL auto_increment,
							CHANGE blocked_ip blocked_ip varchar(64) NULL
                            ");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("ALTER TABLE idevaff_custom
                            CHANGE id id int unsigned NOT NULL auto_increment,
							CHANGE name name TEXT NULL
                            ");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try {
    $db->query("ALTER TABLE idevaff_language_packs
                            CHANGE id id int unsigned NOT NULL auto_increment,
							CHANGE name name varchar(255) NULL
                            ");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}


$checkForColumninv = $db->query("SHOW COLUMNS FROM idevaff_archive LIKE 'email';");
if ( ! $checkForColumninv->rowCount() ) {
    try {
        $db->exec("ALTER TABLE idevaff_archive ADD email varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL");
    } catch (PDOException $e) {
        $ret_ajax['errors'][] = $e->getMessage();
    }
}
$checkForColumninv = $db->query("SHOW COLUMNS FROM idevaff_sales LIKE 'email';");
if ( ! $checkForColumninv->rowCount() ) {
    try {
        $db->exec("ALTER TABLE idevaff_sales ADD email varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL");
    } catch (PDOException $e) {
        $ret_ajax['errors'][] = $e->getMessage();
    }
}
$checkForColumninv = $db->query("SHOW COLUMNS FROM idevaff_config LIKE 'email_tracking';");
if ( ! $checkForColumninv->rowCount() ) {
    try {
        $db->exec("ALTER TABLE idevaff_config ADD email_tracking tinyint(3) unsigned NOT NULL DEFAULT 0");
    } catch (PDOException $e) {
        $ret_ajax['errors'][] = $e->getMessage();
    }
}

$db->query("ALTER TABLE idevaff_currency CHANGE currency_code currency_code varchar(10) character set utf8 NULL DEFAULT NULL");
$db->query("ALTER TABLE idevaff_geo_target CHANGE id id int unsigned NOT NULL auto_increment");

// -------------------------------
// UPDATE VERSION
// -------------------------------
try {
    $query = $db->prepare("update idevaff_config set version = ?");
    $query->execute(array($version));
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}


?>