<?PHP

// ---------------------------------------------------------
// UPDATE FROM 9.2 TO 9.3
// ---------------------------------------------------------
$version = '9.3';
// ---------------------------------------------------------

// ---------------------------------------------------------
// TABLE DROPS
// ---------------------------------------------------------
// NONE
$db->query("DROP TABLE IF EXISTS idevaff_sessions");
$db->query("DROP TABLE IF EXISTS idevaff_sessions_aff");
$db->query("DROP TABLE IF EXISTS idevaff_admin_lockout");
$db->query("DROP TABLE IF EXISTS idevaff_aff_lockout");

// ---------------------------------------------------------
// TABLE ADDS
// ---------------------------------------------------------

$db->query("CREATE TABLE IF NOT EXISTS idevaff_allowed_tracking_domains (
    id bigint UNSIGNED NOT NULL,
    domain varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_products_excluded (
  id int UNSIGNED NOT NULL auto_increment,
  product_id varchar(255) character set utf8 NULL DEFAULT NULL,
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_product_feed (
  id int UNSIGNED NOT NULL DEFAULT '0',
  sku varchar(100) character set utf8 NULL DEFAULT NULL,
  name varchar(400) character set utf8 NULL DEFAULT NULL,
  url varchar(400) character set utf8 NULL DEFAULT NULL,
  image varchar(400) character set utf8 NULL DEFAULT NULL,
  price varchar(50) character set utf8 NULL DEFAULT NULL,
  description text NULL,
  UNIQUE KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_product_feed_settings (
  feed_sort tinyint NOT NULL DEFAULT 1,
  feed_gui tinyint NOT NULL DEFAULT 1,
  feed_csv tinyint NOT NULL DEFAULT 1,
  feed_raw tinyint NOT NULL DEFAULT 1,
  KEY sort (feed_sort)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");

$db->query("INSERT INTO idevaff_product_feed_settings (feed_sort, feed_gui, feed_csv, feed_raw) VALUES(1, 1, 1, 1)");


try {
    // Check if Geo stats table is exist.
    $showQ = "SHOW TABLES LIKE 'idevaff_geo_stats'";
    $result = $db->query( $showQ );

    $rowCount = $result->rowCount();

    if ( ! $rowCount ) {
        try {
            $qStatment = "CREATE TABLE IF NOT EXISTS idevaff_geo_stats (
						  id int UNSIGNED NOT NULL AUTO_INCREMENT,
						  country_code varchar(15) character set utf8 NULL DEFAULT NULL,
						  visitor_count bigint UNSIGNED NOT NULL DEFAULT '0',
                          PRIMARY KEY (id),
                          INDEX country_code (country_code)
                        ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;";

            $table_create = $db->exec( $qStatment );
        } catch (PDOException $e){
            $ret_ajax['errors'][] = $e->getMessage();
        }

        $re_showQ = "SHOW TABLES LIKE 'idevaff_geo_stats'";
        $re_result = $db->query( $re_showQ );

        $re_rowCount = $re_result->rowCount();

        if ($re_rowCount) {
            $query = "SELECT count(idevaff_iptracking.id) as cnt, idevaff_iptracking.geo FROM idevaff_iptracking group by idevaff_iptracking.geo";

            $st = $db->prepare($query);
            $st->execute();

            $ip_datas = $st->fetchAll();

            $geo_countries = array();
            $map_data = array();
            $map_count = array();

            if (count($ip_datas) > 0){
                foreach ( $ip_datas as $ip_data ) {
                    $country_code   = $ip_data['geo'];
                    $count          = $ip_data['cnt'];

                    $statement = $db->prepare("INSERT INTO idevaff_geo_stats(country_code, visitor_count) VALUES(?, ?);");
                    $statement->execute([$country_code, $count]);
                }
            }
        }
    }
}
catch (Exception $e) {
    $ret_ajax['errors'][] = $e->getMessage();
}


$debug = array();
try {
    // Check if Geo stats table is exist.
    $showQ = "SHOW TABLES LIKE 'idevaff_monthly_traffic_activity' " ;
    $result = $db->query( $showQ );

    $rowCount = $result->rowCount();

    if ( ! $rowCount ) {
        try {
            $qStatment = "    
                    CREATE TABLE IF NOT EXISTS idevaff_monthly_traffic_activity (
					  ID int UNSIGNED NOT NULL AUTO_INCREMENT,
					  account_ID int UNSIGNED NOT NULL DEFAULT '0',
					  ip_address varchar(45) character set utf8 NULL DEFAULT NULL,
					  created_at timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                      PRIMARY KEY (ID),
                      KEY ip_address (ip_address)
                    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
                ";

            $table_create = $db->exec( $qStatment );
        } catch (PDOException $e){
            $ret_ajax['errors'][] = $e->getMessage();
        }

        $re_showQ = "SHOW TABLES LIKE 'idevaff_monthly_traffic_activity'";
        $re_result = $db->query( $re_showQ );

        $re_rowCount = $re_result->rowCount();

        if ($re_rowCount) {
            $query = "
                SELECT DISTINCT ip as ip_address, acct_id, stamp FROM idevaff_iptracking 
                WHERE stamp BETWEEN UNIX_TIMESTAMP(DATE_SUB(NOW(), INTERVAL 30 DAY)) AND UNIX_TIMESTAMP(NOW())
                GROUP BY ip, acct_id, stamp
                ORDER BY stamp";

            $st = $db->prepare($query);
            $st->execute();

            $ip_datas = $st->fetchAll();

            if (count($ip_datas) > 0){
                foreach ( $ip_datas as $row ) {
                    $account_ID = $row['acct_id'];
                    $ip = $row['ip_address'];
                    $created_at = date( 'Y-m-d',$row['stamp']);
                    $statement = $db->prepare("INSERT INTO idevaff_monthly_traffic_activity(account_ID, ip_address, created_at) VALUES(?, ?, ?);");
                    $statement->execute([$account_ID, $ip, $created_at]);
                }
            }
        }
    }
}
catch (Exception $e) {
    $ret_ajax['errors'][] = $e->getMessage();
}

$checkForColumninv = $db->query("SHOW COLUMNS FROM idevaff_invoice LIKE 'include_invoice_number';");
if ( ! $checkForColumninv->rowCount() ) {
    try {
        $db->exec("ALTER TABLE idevaff_invoice ADD include_invoice_number tinyint UNSIGNED NOT NULL default '0'");
    } catch (PDOException $e) {
        $ret_ajax['errors'][] = $e->getMessage();
    }
}
$checkForColumninv = $db->query("SHOW COLUMNS FROM idevaff_invoice LIKE 'invoice_prefix';");
if ( ! $checkForColumninv->rowCount() ) {
    try {
        $db->exec("ALTER TABLE idevaff_invoice ADD invoice_prefix varchar(255) DEFAULT NULL");
        $db->query("update idevaff_invoice set invoice_prefix = 'INV-'");
    } catch (PDOException $e) {
        $ret_ajax['errors'][] = $e->getMessage();
    }
}

$checkForColumn = $db->query("SHOW COLUMNS FROM idevaff_affiliates LIKE 'unique_hits_in';");
if ( ! $checkForColumn->rowCount() ) {
    try {
        $db->exec("ALTER TABLE idevaff_affiliates ADD unique_hits_in INT(255) NOT NULL DEFAULT '0' AFTER hits_in;");
        $db->exec("ALTER TABLE idevaff_deleted_accounts ADD unique_hits_in INT(255) NOT NULL DEFAULT '0' AFTER hits_in;");
    } catch (PDOException $e) {
        $ret_ajax['errors'][] = $e->getMessage();
    }

    $checkForColumnAgain = $db->query("SHOW COLUMNS FROM idevaff_affiliates LIKE 'unique_hits_in';");

    if ( $checkForColumnAgain->rowCount() ) {
        $unique_traffic_query = $db->query("SELECT COUNT(DISTINCT ip) AS unique_hits, acct_id AS ID FROM idevaff_iptracking GROUP BY acct_id");

        $unique_traffic_data = $unique_traffic_query->fetchAll();

        if ( $unique_traffic_query->rowCount() ) {
            foreach ( $unique_traffic_data as $unique_traffic ) {
                $statement = $db->prepare("UPDATE idevaff_affiliates SET unique_hits_in = ? where id = ?");

                $statement->execute(array($unique_traffic['unique_hits'], $unique_traffic['ID']));
            }
        }

    }
}


/**
 * Migrate customers from old announcement table
 * to newly created table and logic.
 */
try{
    $col_query = $db->prepare('DESCRIBE `idevaff_announcements`');
    $col_query->execute();
    $columns = $col_query->fetchAll(PDO::FETCH_COLUMN);

    if (in_array('facebook_message', $columns)) {

        $facebook_campaign = $twitter_campaign = $pinterest_campaign = [];

        $announcements =$db->query("select * from idevaff_announcements");

        if ($announcements->rowCount() > 0) {
            foreach ($announcements->fetchAll() as $row) {

                // Facebook
                if (strlen($row['facebook_message']) > 0) {
                    $facebook_campaign[] = [
                        'grp' => $row['grp'] ?? "",
                        'announcement_name' => $row['announcement_name'] ?? "",
                        'channel' => 'facebook',
                        'message' => $row['facebook_message'] ?? "",
                        'picture' => $row['facebook_picture'] ?? "",
                        'sort' => $row['sort'] ?? "",
                        'local' => $row['local'] ?? "",
                    ];
                }

                // Twitter
                if (strlen($row['twitter_message']) > 0) {
                    $twitter_campaign[] = [
                        'grp' => $row['grp'] ?? "",
                        'announcement_name' => $row['announcement_name'] ?? "",
                        'channel' => 'twitter',
                        'message' => $row['twitter_message'] ?? "",
                        'picture' => null,
                        'sort' => $row['sort'] ?? "",
                        'local' => $row['local'] ?? "",
                    ];
                }

                // Pinterest
                if (strlen($row['pinterest_message']) > 0) {
                    $twitter_campaign[] = [
                        'grp' => $row['grp'] ?? "",
                        'announcement_name' => $row['announcement_name'] ?? "",
                        'channel' => 'pinterest',
                        'message' => $row['pinterest_message'] ?? "",
                        'picture' => $row['pinterest_picture'] ?? "",
                        'sort' => $row['sort'] ?? "",
                        'local' => $row['pinterest_local'] ?? "",
                    ];
                }


            }
        }

        $all_announcements = array_merge($facebook_campaign, $twitter_campaign, $pinterest_campaign);

        try {
            $create_announcements = $db->exec('
                      DROP TABLE IF EXISTS `idevaff_announcements`;
                      CREATE TABLE IF NOT EXISTS `idevaff_announcements` (
                      `number` int(10) unsigned NOT NULL AUTO_INCREMENT,
                      `grp` int(10) unsigned NOT NULL DEFAULT \'0\',
                      `announcement_name` varchar(255) DEFAULT NULL,
                      `channel` varchar(60) DEFAULT NULL,
                      `message` text,
                      `picture` varchar(255) DEFAULT NULL,
                      `sort` int(11) NOT NULL DEFAULT \'0\',
                      `local` tinyint(3) unsigned NOT NULL DEFAULT \'0\',
                      PRIMARY KEY (`number`)
                    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;');
        } catch (Exception $e) {
            $ret_ajax['errors'][] = $e->getMessage();
        }

        if (sizeof($all_announcements) > 0) {
            foreach ($all_announcements as $announcement) {
                try {
                    $stmt = $db->prepare('INSERT INTO `idevaff_announcements` 
                                    (`grp`, `announcement_name`, `channel`, `message`, `picture`, `sort`, `local`) 
                                    VALUES (?, ?, ?, ?, ?, ?, ?)');
                    $stmt->execute([$announcement['grp'], $announcement['announcement_name'], $announcement['channel'], $announcement['message'], $announcement['picture'], $announcement['sort'], $announcement['local']]);
                } catch (Exception $e) {
                    $ret_ajax['errors'][] = $e->getMessage();
                }

            }
        }
    }
} catch (Exception $e) {
    $ret_ajax['errors'][] = $e->getMessage();
}

// Create Facebook Tokens table.
$db->query("CREATE TABLE IF NOT EXISTS `idevaff_facebook_tokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `aff_id` int(11) NOT NULL DEFAULT 0,
  `access_token` text,
  `page_token` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");


// Create Facebook Tokens table.
$db->query("CREATE TABLE IF NOT EXISTS `idevaff_linkedin_tokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `aff_id` int(11) NOT NULL NOT NULL DEFAULT 0,
  `access_token` text CHARACTER SET utf8,
  `person_id` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;");


// Create Social media Settings table.
$db->query("CREATE TABLE IF NOT EXISTS `idevaff_social_media_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channel` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `client_id` varchar(64) CHARACTER SET utf8 DEFAULT NULL,
  `client_secret` varchar(64) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;");

// DROPPED ABOVE
// RECREATING HERE TO GET UNIQUE KEY ADDED
// UNIQUE KEY ADDED BELOW
$db->query("CREATE TABLE IF NOT EXISTS idevaff_admin_lockout (
  id int UNSIGNED NOT NULL auto_increment,
  ip varchar(64) character set utf8 NULL DEFAULT NULL,
  attempts tinyint UNSIGNED NOT NULL DEFAULT '0',
  code bigint UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_aff_lockout (
  id int UNSIGNED NOT NULL auto_increment,
  ip varchar(64) character set utf8 NULL DEFAULT NULL,
  attempts tinyint UNSIGNED NOT NULL DEFAULT '0',
  code bigint UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_sessions (
  id char(128) character set utf8 NULL DEFAULT NULL,
  set_time char(10) character set utf8 NULL DEFAULT NULL,
  data text NULL,
  session_key char(128) character set utf8 NULL DEFAULT NULL,
  user_id varchar(255) character set utf8 NULL DEFAULT NULL,
  UNIQUE KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_sessions_aff (
  id char(128) character set utf8 NULL DEFAULT NULL,
  set_time char(10) character set utf8 NULL DEFAULT NULL,
  data text NULL,
  session_key char(128) character set utf8 NULL DEFAULT NULL,
  user_id int UNSIGNED DEFAULT NULL,
  UNIQUE KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_general_leads (
  id int(10) UNSIGNED NOT NULL auto_increment,
  profile int(10) UNSIGNED DEFAULT '0',
  acct_id int(10) UNSIGNED NOT NULL DEFAULT '0',
  ip_address varchar(255) DEFAULT NULL,
  time_stamp bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  geo varchar(2) DEFAULT NULL,
  lead_id varchar(250) DEFAULT NULL,
  lead_value varchar(250) DEFAULT NULL,
  customer_name varchar(250) DEFAULT NULL,
  customer_email varchar(250) DEFAULT NULL,
  opt1 varchar(250) DEFAULT NULL,
  opt2 varchar(250) DEFAULT NULL,
  opt3 varchar(250) DEFAULT NULL,
  opt4 varchar(250) DEFAULT NULL,
  tracking_method varchar(255) DEFAULT NULL,
  conversion_time bigint(20) DEFAULT '0',
  target_url varchar(500) DEFAULT NULL,
  referring_url varchar(500) DEFAULT NULL,
  notes text,
  PRIMARY KEY (id),
  KEY (acct_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_general_leads_integrations (
  id int(10) UNSIGNED NOT NULL auto_increment,
  name varchar(255) DEFAULT NULL,
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_general_leads_settings (
  lead_sec_key tinyint(4) NOT NULL DEFAULT '0',
  lead_ip_blocks tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (lead_sec_key)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");

$db->query("INSERT INTO idevaff_general_leads_settings (lead_sec_key, lead_ip_blocks) VALUES(0, 1)");

// ---------------------------------------------------------
// DATA UPDATES
// ---------------------------------------------------------

$db->query("update idevaff_config set idev_date_format = '3', idev_time_format = '12'");

// ---------------------------------------------------------
// FIELD CHANGES
// ---------------------------------------------------------

    // in db_check.php

// ---------------------------------------------------------
// FIELD UPDATES
// ---------------------------------------------------------

try { $db->query("ALTER TABLE idevaff_carts DROP cat");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try { $db->query("ALTER TABLE idevaff_carts DROP module_location");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try { $db->query("ALTER TABLE idevaff_carts DROP protection_eligible");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try { $db->query("ALTER TABLE idevaff_carts DROP coupon_code_eligible");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try { $db->query("ALTER TABLE idevaff_carts DROP per_product_eligible");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try { $db->query("ALTER TABLE idevaff_carts DROP profile_protection_eligible");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try { $db->query("ALTER TABLE idevaff_carts DROP recurring_supported");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try { $db->query("ALTER TABLE idevaff_carts DROP alternate_commission");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try {
    $db->query("ALTER TABLE idevaff_carts DROP version");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try {
    $db->query("ALTER TABLE idevaff_config ADD last_updated_video int UNSIGNED NOT NULL default 0");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try {
    $db->query("ALTER TABLE idevaff_config ADD payment_pdf tinyint UNSIGNED NOT NULL default 0");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("ALTER TABLE idevaff_config ADD lead_notify_admin tinyint UNSIGNED NOT NULL default 0");
    $db->query("update idevaff_config set lead_notify_admin = '1'");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("ALTER TABLE idevaff_config ADD roi_enabled tinyint NOT NULL DEFAULT 0");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("ALTER TABLE idevaff_config ADD roi_type tinyint NOT NULL DEFAULT 0");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("ALTER TABLE idevaff_config ADD roi_percentage decimal(10,3) NOT NULL DEFAULT 0.000");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("ALTER TABLE idevaff_config ADD cloud_level int NOT NULL default '0'");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("ALTER TABLE idevaff_config ADD recaptcha_site_key varchar(255) character set utf8 NULL DEFAULT NULL after emails_allowed");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("ALTER TABLE idevaff_config ADD recaptcha_secret_key varchar(255) character set utf8 NULL DEFAULT NULL after recaptcha_site_key");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("ALTER TABLE idevaff_config ADD ipv6 tinyint unsigned NOT NULL DEFAULT 0");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}



// ---------------------------------------------------------
// Update email language templates
// ---------------------------------------------------------

$get_language_tables = $db->query("select table_name from idevaff_email_language_packs");
if ($get_language_tables->rowCount()) {
    while ($qry = $get_language_tables->fetch()) {
        $tmp_tbl = $qry['table_name'];
        try {
            $db->query("ALTER TABLE idevaff_email_{$tmp_tbl} ADD invite_sub text NULL");
            $db->query("update idevaff_email_{$tmp_tbl} set invite_sub = 'Invitation To {company_name} Affiliate Program'");
        } catch (Exception $ex) {
            $ret_ajax['errors'][] = $ex->getMessage();
        }
        try {
            $db->query("ALTER TABLE idevaff_email_{$tmp_tbl} ADD invite_body text NULL");
            $db->query("update idevaff_email_{$tmp_tbl} set invite_body = 'Hi {recipient_name},\r\n\r\nYou are invited to join the {company_name} affiliate program! Please take a moment to create your affiliate account at the link below. Once logged in to your account, you\'ll have access to exclusive marketing content, have the ability to share content to your social media feeds and check all your traffic and commissions statistics.\r\n\r\n{signup_page}\r\n\r\nWe\'re excited to have you on board!'");
        } catch (Exception $ex) {
            $ret_ajax['errors'][] = $ex->getMessage();
        }
        try {
            $db->query("ALTER TABLE idevaff_email_{$tmp_tbl} ADD admin_lead_subject text NULL");
            $db->query("update idevaff_email_{$tmp_tbl} set admin_lead_subject = 'New Lead Generated on {company_name}'");
        } catch (Exception $ex) {
            $ret_ajax['errors'][] = $ex->getMessage();
        }
        try {
            $db->query("ALTER TABLE idevaff_email_{$tmp_tbl} ADD admin_lead_body text NULL");
            $db->query("update idevaff_email_{$tmp_tbl} set admin_lead_body = 'Dear Admin,\r\n\r\nYou have a new lead on your {company_name} affiliate program. You can see the details of the lead in your iDevAffiliate admin center in the Reports > Leads Generated section.'");
        } catch (Exception $ex) {
            $ret_ajax['errors'][] = $ex->getMessage();
        }
    }
}

    $db->query("update idevaff_config set use_security = '0'");

// -------------------------------
// UPDATE VERSION
// -------------------------------
try {
    $query = $db->prepare("update idevaff_config set version = ?");
    $query->execute(array($version));
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}


?>