<?PHP
	$current_memory = ini_get('memory_limit');
	$current_memory = preg_replace('/\D/', '', $current_memory);

	if ($current_memory < '512') {
	ini_set('memory_limit','-1');
	$current_memory = ini_get('memory_limit');
	$current_memory = preg_replace('/\D/', '', $current_memory);
	}

include_once("../API/debug.php");
include_once("../includes/package.php");
include_once("../API/path.php");
$installcheck = true;

if(session_id() == '') {
	session_start();
}

function better_key( $length = 64 ) {
	$better_token = "";
    $uid = uniqid("", true);
    $data = "";
    $data .= isset( $_SERVER['REQUEST_TIME'] ) ? $_SERVER['REQUEST_TIME'] : '';
    $data .= isset( $_SERVER['HTTP_USER_AGENT'] ) ? $_SERVER['HTTP_USER_AGENT'] : '';
    $data .= isset( $_SERVER['LOCAL_ADDR'] ) ? $_SERVER['LOCAL_ADDR'] : '';
    $data .= isset( $_SERVER['LOCAL_PORT'] ) ? $_SERVER['LOCAL_PORT'] : '';
    $data .= isset( $_SERVER['REMOTE_ADDR'] ) ? $_SERVER['REMOTE_ADDR'] : '';
    $data .= isset( $_SERVER['REMOTE_PORT'] ) ? $_SERVER['REMOTE_PORT'] : '';
    $toHash = $uid . md5($data); //unique id

    // Avoid Collision Attacks with different algorithms
    $tempHash = '';
    $algorithms = array('sha512', 'ripemd320', 'whirlpool');
    foreach($algorithms as $algo) {
        $tempHash .= hash($algo, $toHash);
    }
    //reset hash length
    $toHash = hash('whirlpool', $tempHash);
    $better_token = substr($toHash,0,$length);
    return $better_token;
}

$version = "9.4";
$ca_version = "1.0.6.05";
$version_available_for_upgrade = array(
		'6.0.4',
		'7.0',
		'7.1',
		'7.2',
		'7.3',
		'7.4',
		'8.0',
		'8.1',
		'9.0',
		'9.1',
		'9.2',
		'9.3',
		'9.4'
);

function getPlatform() {
	if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
		$platform = "windows";
	} else {
		$platform = "unix";
	}
	return($platform);
}

function isWritable ($file) {
	$rtnVal = false;
	$platform = getPlatform();
	if($platform == 'windows') {
		$dir_separator = "\\";
	}

	if($platform == 'unix') {
		$dir_separator = '/';
	}

	if (@is_dir($file)) {
		if($platform == 'windows') {
			$file = preg_replace('/\\\\$/', '', $file). $dir_separator . md5(uniqid('', true));
		} else {
			$file = preg_replace('/\/\/$/', '', $file) . $dir_separator . md5(uniqid('',true));
		}
		$unlink = true;
	} else {
		$unlink = !file_exists($file);
	}

	if ($fp = @fopen($file, 'ab')) {
		@fclose($fp);
		if ($unlink) {
			@unlink($file);
		}
		$rtnVal = true;
	} else {
		$rtnVal = false;
	}

	return($rtnVal);
}

$license = false;
function chk( & $var ) {
	if ( !isset($var) ) {
		return NULL;
	} else {
		return $var;
	}
}

include_once("../API/path.php");
include_once($path . "/API/database.php");

$get_exist_ver = $db->query("select version from idevaff_config");
if ($get_exist_ver->rowCount()) {
	$get_exist_ver = $get_exist_ver->fetch();
	$current_version = $get_exist_ver['version'];
} else { $current_version = null; }


$error_message = null;
if (!isset($error_message)) {
	try {
		$db = new PDO("mysql:host=$dbhost;dbname=$dbname;charset=utf8", $dbuser, $dbpass);
		$db->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION );
		$db->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
	}
	catch(PDOException $e) {
			$error_message = "<div class=\"alert alert-danger\"><strong>Error!</strong> No connection to the database could be made. Please check your settings.</div>";
	}
	if($error_message==""){
		$res1 = null; $res2 = null; $res3 = null;
		$res1 = $db->query("CREATE TABLE IF NOT EXISTS idevaff_test (record tinyint(10) NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
		$res2 = $db->query("INSERT into idevaff_test (record) VALUES ('1')");
		$res3 = $db->query('DROP TABLE IF EXISTS idevaff_test');
		if (($res1 === false) || ($res2 === false) || ($res3 === false)) {
			$error_message = "<div class=\"alert alert-danger\"><strong>Error!</strong> Please issue full privileges to your MySQL user, for your MySQL database.</div>";
		} else {
			$db->query('DROP TABLE IF EXISTS idevaff_test');
		}
	}
}

// CHECK VERSION IS OK TO UPGRADE
if (!isset($error_message)) {
if (version_compare($current_version, '6.0.4') == -1 || (!isset($current_version))) {
$error_message = "<div class=\"alert alert-danger\"><h3><strong>Error Detected</strong></h3></div>
<div class=\"well\">
<font type=\"arial\">You must be running one of the following versions of iDevAffiliate in order to upgrade to iDevAffiliate " . $version . ".<br /><br />
- 6.0.4<br />
- 7.0<br />
- 7.1<br />
- 7.2<br />
- 7.3<br />
- 7.4<br />
- 8.0<br />
- 8.1<br />
- 9.0<br />
- 9.1<br />
- 9.2<br />
- 9.3<br /><br />
Please first update your current installation to one of the above versions, then try again.</font>
</div>";
} }



// CHECK IF UPGRADE IS REQUIRED
if (!isset($error_message)) {
	if (($current_version == $version) && (!isset($_POST['install_step']))) {
		$error_message = "<div class=\"alert alert-info\"><h4>No upgrade available.</h4>Your system is currently up-to-date.</div>";
	}
}

		$cnt = $db->query("SELECT COUNT(*) FROM idevaff_iptracking");
		$count = $cnt->fetchColumn();

// CHECK IF DATABASE IS TOO BIG
/*
if (!isset($error_message)) {
	if (($count > '800000') && (!isset($_POST['install_step']))) {
		$error_message = "<div class=\"alert alert-info\"><h4>Custom Upgrade Required</h4>Please take a moment now to delete the <strong>/install</strong> folder and contact our support department.
		<br /><br /><a class='btn btn-danger' target='_blank' href='https://www.idevdirect.com/contact.php'>Contact Us</a>
		<br /><br />Data Rows: " . number_format($count) . "</div>";
	}
}
*/

// STOP! THROW ERROR IF NEEDED
if (isset($error_message) && !isset($_POST['ajax_upgrade'])) {
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>iDevAffiliate <?PHP echo $write_edition; ?> Upgrade Program</title>
<link href="templates/bootstrap/css/bootstrap.css" rel="stylesheet">
<link href="templates/bootstrap/css/custom.css" rel="stylesheet">
<script src="templates/bootstrap/js/jquery-2.0.3.min.js"></script>
<script src="templates/bootstrap/js/bootstrap.min.js"></script>
</head>
<body>
<div class="navbar navbar-inverse navbar-fixed-top" role="navigation">
<div class="container">
<div class="navbar-header" style="margin-top:6px;"><!--<img src="../admin/images/idevaffiliate_logo.png">--></div>
<div class="navbar-collapse collapse">
<span class="pull-right" style="margin-top:8px;"><font style="font-size:24px; color:#cbcbcb;"><?PHP echo $write_edition; ?> Upgrade</font>
</div>
</div>
</div>
<div id="wrap">
<div class="container">

<?PHP echo $error_message; ?>

</div>
</div>
<div id="footer">
<div class="container">
<p class="text-muted credit pull-right">Copyright 1999-<?PHP echo date("Y"); ?> - iDevAffiliate Inc. - <a href="https://www.idevdirect.com/" target="_blank">iDevAffiliate</a></p>
</div>
</div>
</div>
</div>
</body>
</html>
<?PHP exit();
} elseif( isset($error_message) && isset($_POST['ajax_upgrade']) ) {
	$ret_ajax['error'] = $error_message;
	//header('Content-Type: application/json');
	echo json_encode($ret_ajax);
	exit;
}
if (isset($_POST['license'])) { $license = $_POST['license']; } else { $license = ''; }
if (isset($_POST['license_method'])) { $license_method = $_POST['license_method']; } else { $license_method = ''; }

// ------------------------------------------------
// LICENSING START
// ------------------------------------------------

function make_token() { return md5('1b1ddcb4ed069d9565cc6a5a9ecf553e'.time()); }

function phpaudit_exec_curl($array)
    {
    $array=@explode("?", $array);

    $link=curl_init();
    curl_setopt($link, CURLOPT_URL, $array[0]);
    curl_setopt($link, CURLOPT_POSTFIELDS, $array[1]);
    curl_setopt($link, CURLOPT_VERBOSE, 0);
    curl_setopt($link, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($link, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($link, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($link, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($link, CURLOPT_MAXREDIRS, 6);
    curl_setopt($link, CURLOPT_CONNECTTIMEOUT, 30);
    curl_setopt($link, CURLOPT_TIMEOUT, 15); // 60
    $results=curl_exec($link);
	if (curl_errno($link)>0)
		{
		curl_close($link);
		return false;
		}
    curl_close($link);

	if (@strpos($results, "verify")===false) { return false; }

    return $results;
    }

function phpaudit_exec_socket($http_host, $http_dir, $http_file, $querystring)
	{
	$fp=@fsockopen($http_host, 80, $errno, $errstr, 10); // was 5
	if (!$fp) { return false; }
	else
		{
		$header="POST ".($http_dir.$http_file)." HTTP/1.0\r\n";
		$header.="Host: ".$http_host."\r\n";
		$header.="Content-type: application/x-www-form-urlencoded\r\n";
		$header.="User-Agent: PHPAudit v2 (http://www.phpaudit.com)\r\n";
		$header.="Content-length: ".@strlen($querystring)."\r\n";
		$header.="Connection: close\r\n\r\n";
		$header.=$querystring;

		$data=false;
		if (@function_exists('stream_set_timeout')) { stream_set_timeout($fp, 20); }
		@fputs($fp, $header);

		if (@function_exists('socket_get_status')) { $status=@socket_get_status($fp); }
		else { $status=true; }

		while (!@feof($fp)&&$status)
			{
			$data.=@fgets($fp, 1024);

			if (@function_exists('socket_get_status')) { $status=@socket_get_status($fp); }
			else
				{
			    if (@feof($fp)==true) { $status=false; }
				else { $status=true; }
				}
			}

		@fclose ($fp);

		// echo "<textarea rows='100' cols='100'>".$data."</textarea>"; die;

		if (!strpos($data, '200')) { return false; }

		if (!$data) { return false; }

		$data=@explode("\r\n\r\n", $data, 2);

		if (!$data[1]) { return false; }
		if (@strpos($data[1], "verify")===false) { return false; }

		return $data[1];
		}
	}

function path_translated()
	{
	if (isset($_SERVER['PATH_TRANSLATED']))
		{
		return @substr($_SERVER['PATH_TRANSLATED'], 0, @strrpos($_SERVER['PATH_TRANSLATED'], "/"));
		}

	if (isset($_SERVER['SCRIPT_FILENAME']))
		{
		$local_path=substr($_SERVER['SCRIPT_FILENAME'], 0, @strrpos($_SERVER['SCRIPT_FILENAME'], "/"));
		if (!$local_path)
			{
			$local_path=@substr($_SERVER['SCRIPT_FILENAME'], 0, @strrpos($_SERVER['SCRIPT_FILENAME'], "\\"));
			}

		return $local_path;
		}

	return @substr($_SERVER['ORIG_PATH_TRANSLATED'], 0, @strrpos($_SERVER['ORIG_PATH_TRANSLATED'], "\\"));
	}

function server_addr()
            {
if (isset($_SERVER['SERVER_ADDR'])) {
return ($_SERVER['SERVER_ADDR'])?$_SERVER['SERVER_ADDR']:$_SERVER['LOCAL_ADDR'];
} else { }
}


if (isset($_POST['license_submit']))
	{
	$server='https://www.idevstore.com/'; // main server
	$methods=array('phpaudit_exec_socket', 'phpaudit_exec_curl', 'file_get_contents');

	$enable_dns_spoof='yes';

	$query_string="license=".$_POST['license'];
	$query_string.="&product_id=".$prid;
	$query_string.="&access_directory=".str_replace('install', 'admin', path_translated());
	$query_string.="&access_ip=".server_addr();
	$query_string.="&access_host=".$_SERVER['HTTP_HOST'];
	$query_string.='&access_token=';
	$query_string.=$token=make_token();


	$data=false;
	foreach($methods as $license_method)
		{
		$sinfo=@parse_url($server);


		if ($license_method=='phpaudit_exec_socket'&&!$data)
			{
			$data=@phpaudit_exec_socket($sinfo['host'], $sinfo['path'], '/validate_internal.php', $query_string);
			}


		if ($license_method=='phpaudit_exec_curl'&&!$data)
			{
			$data=@phpaudit_exec_curl("{$server}/validate_internal.php?{$query_string}");
			}


		if ($license_method=='file_get_contents'&&!$data)
			{
			$data=@file_get_contents("{$server}validate_internal.php?{$query_string}");
			}

		if ($data) { break; }
		}

	$parser=@xml_parser_create('');
	@xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
	@xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
	@xml_parse_into_struct($parser, $data, $values, $tags);
	@xml_parser_free($parser);

	$returned=$values[0]['attributes'];
	if (empty($returned)) { $returned['status']="invalid"; }

	if ($returned['status']!="active"&&$returned['status']!="reissued")
		{
		unset($_POST);
		$fail_message=false;
		if ($returned['status']=="suspended")
			{
			$fail_message='<strong>Error!</strong> This license has been suspended.';
			}
		else if ($returned['status']=="pending")
			{
			$fail_message='<strong>Error!</strong> This license is pending approval.';
			}
		else if ($returned['status']=="expired")
			{
			$fail_message='<strong>Error!</strong> This license is expired.';
			}
		else if ($returned['status']=='active'
			&&strcmp(md5('1b1ddcb4ed069d9565cc6a5a9ecf553e'.$token), $returned['access_token'])!=0
			&&$enable_dns_spoof=='yes'
			&&!$skip_dns_spoof)
			{
			$fail_message='<strong>Error!</strong> This license has an invalid checksum.';
			}
		else { $fail_message='<strong>Error!</strong> This license appears to be invalid.'; }
		}

	unset($query_string, $per_server, $per_install, $per_site, $server, $data, $parser, $values, $tags, $sinfo, $token);
	}

// ------------------------------------------------
// LICENSING END
// ------------------------------------------------

if (!isset($_POST['install_step'])) {
	$tr_class_1 = null; $label_1 = "To Do"; $label_color_1 = "default";
	$tr_class_2 = null; $label_2 = "To Do"; $label_color_2 = "default";
	$tr_class_3 = null; $label_3 = "To Do"; $label_color_3 = "default";
	$tr_class_4 = null; $label_4 = "To Do"; $label_color_4 = "default";
	$tr_class_5 = null; $label_5 = "To Do"; $label_color_5 = "default";
	$percentage_complete = 0;
	$progress_color = "primary";

} elseif ((isset($_POST['install_step'])) && ($_POST['install_step'] == '1')) {
	$tr_class_1 = "warning"; $label_1 = "Working"; $label_color_1 = "danger";
	$tr_class_2 = null; $label_2 = "To Do"; $label_color_2 = "default";
	$tr_class_3 = null; $label_3 = "To Do"; $label_color_3 = "default";
	$tr_class_4 = null; $label_4 = "To Do"; $label_color_4 = "default";
	$tr_class_5 = null; $label_5 = "To Do"; $label_color_5 = "default";
	$percentage_complete = 0;
	$progress_color = "primary";

} elseif ((isset($_POST['install_step'])) && ($_POST['install_step'] == '2')) {
	$tr_class_1 = null; $label_1 = "Done"; $label_color_1 = "success";
	$tr_class_2 = "warning"; $label_2 = "Working"; $label_color_2 = "danger";
	$tr_class_3 = null; $label_3 = "To Do"; $label_color_3 = "default";
	$tr_class_4 = null; $label_4 = "To Do"; $label_color_4 = "default";
	$tr_class_5 = null; $label_5 = "To Do"; $label_color_5 = "default";
	$percentage_complete = 25;
	$progress_color = "primary";

} elseif ((isset($_POST['install_step'])) && ($_POST['install_step'] == '3')) {
	$tr_class_1 = null; $label_1 = "Done"; $label_color_1 = "success";
	$tr_class_2 = null; $label_2 = "Done"; $label_color_2 = "success";
	$tr_class_3 = "warning"; $label_3 = "Working"; $label_color_3 = "danger";
	$tr_class_4 = null; $label_4 = "Done"; $label_color_4 = "success";
	$tr_class_5 = null; $label_5 = "To Do"; $label_color_5 = "default";
	$percentage_complete = 50;
	$progress_color = "primary";

} elseif ((isset($_POST['install_step'])) && ($_POST['install_step'] == '4')) {
	$tr_class_1 = null; $label_1 = "Done"; $label_color_1 = "success";
	$tr_class_2 = null; $label_2 = "Done"; $label_color_2 = "success";
	$tr_class_3 = null; $label_3 = "Done"; $label_color_3 = "success";
	$tr_class_4 = "warning"; $label_4 = "Working"; $label_color_4 = "danger";
	$tr_class_5 = null; $label_5 = "Done"; $label_color_5 = "success";
	$percentage_complete = 75;
	$progress_color = "primary";

} elseif ((isset($_POST['install_step'])) && ($_POST['install_step'] == '5')) {
	$tr_class_1 = null; $label_1 = "Done"; $label_color_1 = "success";
	$tr_class_2 = null; $label_2 = "Done"; $label_color_2 = "success";
	$tr_class_3 = null; $label_3 = "Done"; $label_color_3 = "success";
	$tr_class_4 = null; $label_4 = "Done"; $label_color_4 = "success";
	$tr_class_5 = "warning"; $label_5 = "Complete!"; $label_color_5 = "primary";
	$percentage_complete = 100;
	$progress_color = "primary";

}


if (isset($_POST['install_tables']) && !isset($_POST['ajax_upgrade'])) {

	include_once("../API/path.php");
	include_once($path . "/API/database.php");

	$query=$db->query("SHOW TABLES LIKE 'idevaff_config'");
	if($query->rowCount()==1) {
		$success_message = "<strong>Success!</strong> The database has been updated.";
	} else {
		$fail_message = "<strong>Error!</strong> Upgrade cannot continue.&nbsp; <a href=\"https://www.idevsupport.com/\" target=\"_blank\">Contact Support</a>";
	}
} elseif (isset($_POST['install_tables']) && isset($_POST['ajax_upgrade'])) {

	include_once($path . "/includes/functions.php");
	$ret_ajax = array();

	$ret_ajax['upgrade_started'] = '1';
	$now_include = $_POST['now_include'];
	include_once("upgrade_routines.php");
	$ret_ajax['upgrade_end'] = 1;

	$query=$db->query("SHOW TABLES LIKE 'idevaff_config'");
	if($query->rowCount()==1) {
		$ret_ajax['success'] = 'yes';
		$ret_ajax['message'] = "<strong>Success!</strong> The database has been updated.";

	} else {
		$ret_ajax['error'] = "<strong>Error!</strong> Upgrade cannot continue.&nbsp; <a href=\"https://www.idevsupport.com/\" target=\"_blank\">Contact Support</a>";
	}

	//header('Content-Type: application/json');
	echo json_encode($ret_ajax);
	exit;
}

if (isset($_POST['media_move'])) {
include("media_move.php");
if (isset($move_error)) {
$fail_message = "<strong>Error!</strong> Media could not be moved. Please manually move media via FTP. Check the following folders for existing files.<br /><br />
- Copy ALL files in the /banners/ folder to the new /media/banners/ folder.<br />
- Copy ALL email attachment PDF files in the /docs/ folder to the new /media/email_attachments/ folder.<br />
- Copy ALL files in the /lightboxes/ folder to the new /media/lightboxes/ folder.<br />
- Copy ALL files in the /peels/ folder to the new /media/pagepeels/ folder.<br />
- Copy ALL marketing and training PDF files in the /docs/ folder to the new /media/pdf/ folder.<br />
- Copy ALL files in the /logos/ folder to the new /assets/logos/ folder.<br />
<br />
<form class=\"form-horizontal\" role=\"form\" method=\"post\" action=\"upgrade.php\" style=\"display:inline-block;\">
<button type=\"submit\" class=\"btn btn-danger btn-sm\">Continue To Next Step</button>
<input type=\"hidden\" name=\"install_step\" value=\"3\">
<input type=\"hidden\" name=\"license\" value=\"" . $license . "\">
<input type=\"hidden\" name=\"license_method\" value=\"" . $license_method . "\">
</form>
";
}
}

if (isset($_POST['create'])) {

include_once("../API/path.php");
include_once($path . "/API/database.php");

$fail_message = null;
$fail_notify_for_account_creation = true;

if(strlen(trim($_POST['ad_username'])) < 4) {
$fail_message .= "- Username must be 4-12 characters in length.<br />"; }

if(strlen(trim($_POST['ad_username'])) > 12) {
$fail_message .= "- Username must be 4-12 characters in length.<br />"; }

if(strlen(trim($_POST['ad_password'])) < 4) {
$fail_message .= "- Password must be 4-12 characters in length.<br />"; }

if(strlen(trim($_POST['ad_password'])) > 12) {
$fail_message .= "- Password must be 4-12 characters in length.<br />"; }

if((preg_match("/[^a-z0-9_]/i", $_POST['ad_username']))) {
$fail_message .= "- Username may only contain letters, numbers and underscores.<br />"; }

if((preg_match("/[^a-z0-9_]/i", $_POST['ad_password']))) {
$fail_message .= "- Password may only contain letters, numbers and underscores.<br />"; }

if (!$_POST['ad_username']) {
$fail_message .= "- Missing username.<br />"; }

if (!$_POST['ad_password']) {
$fail_message .= "- Missing password.<br />"; }

if (($_POST['ad_password']) != ($_POST['vr_password'])) {
$fail_message .= "- Passwords do not match.<br />"; }

$email = $_POST['email'];
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) { $fail_message .= "- Invalid email address.<br />"; }

if (!isset($fail_message)) {
	$writeadmin = $_POST['ad_username'];
	$writepassw = $_POST['ad_password'];
	$writeemail = $_POST['email'];
	$writepassw = sha1('idev_secret'.$writepassw);
	$st = $db->prepare ("insert into idevaff_admin (adminid, adminpass, super, email) values (?, ?, ?, ?)");
	$st->execute(array($writeadmin,$writepassw,'1',$writeemail));

	$st2 = $db->prepare ("update idevaff_email_settings set address = ?, alternate_email_address = ?");
	$st2->execute(array($writeemail,$writeemail));
	$success_message = "<strong>Success!</strong> Your account has been created!";
}
}

?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>iDevAffiliate <?PHP echo $write_edition; ?> Upgrade Program</title>
    <link href="templates/bootstrap/css/bootstrap.css" rel="stylesheet">
	<link href="templates/bootstrap/css/custom.css" rel="stylesheet">
	<link href="templates/jquery.progressTimer.css" rel="stylesheet">
	<script src="templates/bootstrap/js/jquery-2.0.3.min.js"></script>
	<script src="templates/bootstrap/js/bootstrap.min.js"></script>
	<script src="templates/jquery.progressTimer.js"></script>
  </head>
  <body>


      <div class="navbar navbar-inverse navbar-fixed-top" role="navigation">
      <div class="container">
        <div class="navbar-header" style="margin-top:6px;"><!--<img src="../admin/images/idevaffiliate_logo.png">--></div>
        <div class="navbar-collapse collapse">
<span class="pull-right" style="margin-top:8px;"><font style="font-size:24px; color:#cbcbcb;"><?PHP echo $write_edition; ?> Upgrade</font>
        </div>
      </div>
    </div>



<div id="wrap">
<div class="container">

<h4>Upgrade Progress: <?PHP echo $percentage_complete; ?>% Complete<?PHP if ($version > $current_version) { ?><span class="pull-right label label-success">Upgrading from iDevAffiliate <?PHP echo $current_version; ?> to <?PHP echo $version; ?></span><?PHP } ?></h4>
<div class="progress progress-striped active">
<div class="progress-bar progress-bar-<?PHP echo $progress_color; ?>"  role="progressbar" aria-valuenow="<?PHP echo $percentage_complete; ?>" aria-valuemin="0" aria-valuemax="100" style="width: <?PHP echo $percentage_complete; ?>%">
<span class="sr-only"><?PHP echo $percentage_complete; ?>% Complete</span>
</div>
</div>


<div class="row">
<div class="col-md-12">

<div class="col-md-3">
<table class="table table-striped">
<tbody>
<tr class="<?PHP echo $tr_class_1; ?>"><td>Step 1: Licensing<div class="pull-right"><div class="label label-<?PHP echo $label_color_1; ?>"><?PHP echo $label_1; ?></div></div></td></tr>
<tr class="<?PHP echo $tr_class_2; ?>"><td>Step 2: Folder Permissions<div class="pull-right"><div class="label label-<?PHP echo $label_color_2; ?>"><?PHP echo $label_2; ?></div></div></td></tr>
<tr class="<?PHP echo $tr_class_3; ?>"><td>Step 3: Update Database<div class="pull-right"><div class="label label-<?PHP echo $label_color_3; ?>"><?PHP echo $label_3; ?></div></div></td></tr>
<tr class="<?PHP echo $tr_class_4; ?>"><td>Step 4: Admin Login<div class="pull-right"><div class="label label-<?PHP echo $label_color_4; ?>"><?PHP echo $label_4; ?></div></div></td></tr>
<tr class="<?PHP echo $tr_class_5; ?>"><td>Step 5: Review<div class="pull-right"><div class="label label-<?PHP echo $label_color_5; ?>"><?PHP echo $label_5; ?></div></div></td></tr>
</tbody>
</table>

<div><a href="https://www.idevdirect.com/video_tutorials.php?tab=2&video_id=201" target="_blank" class="btn btn-block btn-warning">Watch Upgrade Video</a></div>

</div>
<div class="col-md-9">

<?PHP if (!isset($_POST['install_step'])) { ?>

<?PHP
if ((file_exists($path . '/admin/filename_license_key.php')) && (!file_exists($path . '/plugin_keys/filename_license_key.php'))) { $plugin_fn_key_exists = true; }
if ((file_exists($path . '/admin/private_license_key.php')) && (!file_exists($path . '/plugin_keys/private_license_key.php'))) { $plugin_pl_key_exists = true; }
if ((file_exists($path . '/admin/qr_license_key.php')) && (!file_exists($path . '/plugin_keys/qr_license_key.php'))) { $plugin_qr_key_exists = true; }
if ((file_exists($path . '/admin/seo_license_key.php')) && (!file_exists($path . '/plugin_keys/seo_license_key.php'))) { $plugin_seo_key_exists = true; }
if ((file_exists($path . '/admin/social_media_license_key.php')) && (!file_exists($path . '/plugin_keys/social_media_license_key.php'))) { $plugin_sm_key_exists = true; }
if ((file_exists($path . '/admin/vanity_codes_key.php')) && (!file_exists($path . '/plugin_keys/vanity_codes_key.php'))) { $plugin_vc_key_exists = true; }
if ( !isWritable("../API/") ) { $throw_error = true; }
if ( !isWritable("../connect/") ) { $throw_error = true; }

if ((isset($plugin_fn_key_exists)) || (isset($plugin_pl_key_exists)) || (isset($plugin_qr_key_exists)) || (isset($plugin_seo_key_exists)) || (isset($plugin_sm_key_exists)) || (isset($plugin_vc_key_exists))) {
$plugin_update_needed = true; }

?>

						<?PHP
						$sql_mode = $db->query("SELECT @@sql_mode");
						$sql_mode = $sql_mode->fetch();
						if(strpos($sql_mode['@@sql_mode'], 'STRICT_TRANS_TABLES') !== false) {
						?>
						<p><span style="color:#CC0000;"><strong>Upgrade Error!</strong></span> Upgrade cannot continue. Please disable <strong>MySQL STRICT MODE</strong> on your hosting account. If needed, please contact your hosting provider and/or server admin for help with this task.</p>
						<form class="form-horizontal" role="form" method="post" action="upgrade.php" style="display:inline-block;">
						<button type="submit" class="btn btn-danger btn-sm mt-2">Try Again Now</button>
						</form>
						<?PHP
						exit();
						}
						?>

<?PHP //if (!isset($plugin_update_needed)) { ?>
<form class="form-horizontal" role="form" method="post" action="upgrade.php">
<h4>
<button type="submit" class="btn btn-primary btn-sm">I've Read The Information Below, Start My Upgrade</button>
<input type="hidden" name="install_step" value="1">
<span class="pull-right"><small>Review upgrade information.</small></span></h4>
</form>
<?PHP //} ?>

<?PHP if (isset($plugin_update_needed)) { ?>
<hr style="margin-bottom:15px;">
<div class="alert alert-info">
<strong><font size="3">Important Plugin Notice</font></strong><br />
You have plugins installed that are not included with this edition. Please update the license keys for each of the following plugins. To do so, take a current download of the license key from the downloads section of your <a href="https://www.idevstore.com/customers/index.php?task=login" target="_blank" class="btn btn-xs btn-danger">account</a> on our website. Unzip the package and upload each license key file the <strong>/plugin_keys</strong> folder.
<br /><br />
<?PHP if (isset($plugin_fn_key_exists)) { echo "<strong>- Custom Filename</strong><br />"; } ?>
<?PHP if (isset($plugin_pl_key_exists)) { echo "<strong>- Private Signup</strong><br />"; } ?>
<?PHP if (isset($plugin_qr_key_exists)) { echo "<strong>- QR Codes</strong><br />"; } ?>
<?PHP if (isset($plugin_seo_key_exists)) { echo "<strong>- SEO Links</strong><br />"; } ?>
<?PHP if (isset($plugin_sm_key_exists)) { echo "<strong>- Social Media Marketing</strong><br />"; } ?>
<?PHP if (isset($plugin_vc_key_exists)) { echo "<strong>- Vanity Codes</strong>"; } ?>
<br /><br />Please take a moment to do this now. <strong>This task can be completed later but any plugins you have now will not be enabled in your new version until this is done.</strong> Note the existing license key file(s) will <strong>not</strong> work with this version of iDevAffiliate and are actually removed during the upgrade process.
</div>
<?PHP } ?>

<hr style="margin-bottom:15px;">
<p><strong><font size="5">Video Tutorial</font></strong><br />Please watch the video tutorial for more detailed information and instructions to complete your upgrade.</p>
<hr style="margin-bottom:15px;">
<p><strong><font size="5">Page Peels</font></strong><br />Any page peels currently in use by your affiliates will become non-functional. This is due to the fact that going forward with version 8+, all FLASH related items have been removed from iDevAffiliate. Why? Adobe Flash is not compatible with mobile devices such as smart phones, tablets, etc. Any Flash based features have been updated to use HTML 5 and/or CSS instead. Your affiliates will need to login and get new page peel linking code once you have completed your upgrade.</p>
<hr style="margin-bottom:15px;">
<p><strong><font size="5">Flash Banners</font></strong><br />The ability to upload Flash banners has been removed. Existing Flash banners current in use by your affiliates will still work but will no longer be available to obtain from within the affiliate control panel. Once your upgrade is complete, we recommend removing any Flash banners you are currently offering your affiliates.</p>
<?PHP } ?>


<?PHP if ((isset($_POST['install_step'])) && ($_POST['install_step'] == 1)) { ?>

<h4>Upgrade Step #1<span class="pull-right"><small>Enter your iDevAffiliate license key.</small></span></h4>
<hr style="margin-bottom:15px;">

<?PHP
if ((isset($_POST['license_submit'])) && (!isset($fail_message))) { $success_message = "<strong>Success!</strong> License key accepted."; }
include("includes/notifications.php");
?>

<?PHP if ((isset($_POST['license_submit'])) && (!isset($fail_message))) { ?>
<form class="form-horizontal" role="form" method="post" action="upgrade.php">
<button type="submit" class="btn btn-success btn-sm">Continue To Next Step</button>
<input type="hidden" name="install_step" value="2">
<input type="hidden" name="license" value="<?PHP echo $license; ?>">
<input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
</form>
<?PHP

} else {

$result = $db->query('select * from idevaff_config limit 1');
$fields = array_keys($result->fetch(PDO::FETCH_ASSOC));
$columns = count($fields);
for ($i = 0; $i < $columns; $i++) { $field_array[] = $fields[$i]; }
if (in_array('license', $field_array)) {
$check4lic = $db->query("select license from idevaff_config");
$check4lic = $check4lic->fetch();
$license = $check4lic['license'] ?? "";
}

?>
<p style="margin-bottom:30px;">Your license key can be found by logging into the <a href="https://www.idevstore.com/customers/index.php?task=dashboard" target="_blank">Client Area</a> on our website.</p>
<form class="form-horizontal" role="form" method="post" action="upgrade.php">
<div class="form-group">
<label class="col-md-3 control-label">License Key</label>
<div class="col-md-9"><input type="text" name="license" value="<?PHP echo ($license)?$license:''; ?>" class="form-control" />
</div>
</div>
<div class="form-group">
<div class="col-sm-offset-3 col-sm-9">
<button type="submit" class="btn btn-primary btn-sm">Submit License Key</button>
</div>
</div>
<input type="hidden" name="install_step" value="1">
<input type="hidden" name="license_submit" value="1">
</form>
<?PHP } } ?>

<?PHP if ((isset($_POST['install_step'])) && ($_POST['install_step'] == 2)) { ?>

<?PHP
$move_required = null;
$throw_error = null;
$banner_count = null;
$pdf_email_count = null;
$lightbox_count = null;
$pagepeels_count = null;
$pdf_count = null;
$logo_count = null;


$q=$db->query("SHOW TABLES LIKE 'idevaff_banners'");
if($q->rowCount()==1) {
$get_files = $db->query("select image from idevaff_banners");
if ($get_files->rowCount()) { $banner_count = true; $move_required = true; } }

$q=$db->query("SHOW TABLES LIKE 'idevaff_email_attachments'");
if($q->rowCount()==1) {
$get_files = $db->query("select filename from idevaff_email_attachments");
if ($get_files->rowCount()) { $pdf_email_count = true; $move_required = true; } }

$q=$db->query("SHOW TABLES LIKE 'idevaff_lightboxes'");
if($q->rowCount()==1) {
$get_files = $db->query("select image75 from idevaff_lightboxes");
if ($get_files->rowCount()) { $lightbox_count = true; $move_required = true; } }

$q=$db->query("SHOW TABLES LIKE 'idevaff_peels'");
if($q->rowCount()==1) {
$get_files = $db->query("select image500 from idevaff_peels");
if ($get_files->rowCount()) { $pagepeels_count = true; $move_required = true; } }

$q=$db->query("SHOW TABLES LIKE 'idevaff_pdf'");
if($q->rowCount()==1) {
$get_files = $db->query("select filename from idevaff_pdf");
if ($get_files->rowCount()) { $pdf_count = true; $move_required = true; } }

$q=$db->query("SHOW TABLES LIKE 'idevaff_logos'");
if($q->rowCount()==1) {
$get_files = $db->query("select filename from idevaff_logos");
if ($get_files->rowCount()) { $logo_count = true; $move_required = true; } }
?>

<?PHP
function directory_status_label($dir_name) {
$write_successful = false;
$result = false;
if(file_exists($dir_name)) {
$write_successful = isWritable($dir_name);
if(!$write_successful) {
$dir_name = str_replace("..", "", $dir_name);
$dir_name = substr_replace($dir_name ,"",-1);
echo "<font color='#CC0000'>" . $dir_name . "</font>";
} else {
$dir_name = str_replace("..", "", $dir_name);
$dir_name = substr_replace($dir_name ,"",-1);
echo $dir_name; } } }

function directory_status($dir_name) {
$write_successful = false;
$result = false;
if(file_exists($dir_name)) {
$write_successful = isWritable($dir_name);
if(!$write_successful) {
echo "<div class='label label-danger'>Not Writeable</div>";
} else {
echo "<div class='label label-success'>Writeable</div>"; } } }

?>
<h4>Upgrade Step #2<span class="pull-right"><small>Set folder permissions.</small></span></h4>
<hr style="margin-bottom:15px;" />

<?PHP
if ((isset($_POST['media_move'])) && (!isset($fail_message))) { $success_message = "<strong>Success!</strong> Media has been successfully moved."; }
include("includes/notifications.php");
?>

<?PHP if ((isset($_POST['media_move'])) && (!isset($fail_message))) { ?>
<form class="form-horizontal" role="form" method="post" action="upgrade.php" style="display:inline-block;">
<button type="submit" class="btn btn-success btn-sm">Continue To Next Step</button>
<input type="hidden" name="install_step" value="3">
<input type="hidden" name="media_move" value="1">
<input type="hidden" name="license" value="<?PHP echo $license; ?>">
<input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
</form>
<?PHP } else { ?>

<?PHP
if ($current_version >= 8) { $move_required = null; }
if (isset($move_required)) {
?>

<p style="margin-bottom:30px;">We are moving some marketing materials to a new location. The following folders need <u>write</u> permissions. If you need help with this task, please contact your web hosting provider for information on how you can changer folder permissions.</p>

<?PHP
if ((isset($banner_count)) && (!isWritable("../media/banners/"))) { $throw_error = true; }
if ((isset($pdf_email_count)) && (!isWritable("../media/email_attachments/"))) { $throw_error = true; }
if ((isset($lightbox_count)) && (!isWritable("../media/lightboxes/"))) { $throw_error = true; }
if ((isset($pagepeels_count)) && (!isWritable("../media/pagepeels/"))) { $throw_error = true; }
if ((isset($pdf_count)) && (!isWritable("../media/pdf/"))) { $throw_error = true; }
if ((isset($logo_count)) && (!isWritable("../assets/logos/"))) { $throw_error = true; }
?>


<?PHP if (isset($throw_error)) { ?>
<div class="alert alert-danger">
<h4>Important Notice!</h4>
We can't continue past this point until the required folders have write permissions. Please see the list below.<br />
</div>
<?PHP } ?>

<div>
<span class="pull-right">
<form class="form-horizontal" role="form" method="post" action="upgrade.php" style="display:inline-block;">
<button type="submit" class="btn btn-primary btn-sm">Refresh This Page</button>
<input type="hidden" name="install_step" value="2">
<input type="hidden" name="license" value="<?PHP echo $license; ?>">
<input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
</form>

<?PHP if (!isset($throw_error)) { ?><form class="form-horizontal" role="form" method="post" action="upgrade.php" style="display:inline-block;">
<button type="submit" class="btn btn-success btn-sm">Continue To Next Step</button>
<?PHP if ($current_version < 8) { ?>
<input type="hidden" name="install_step" value="2">
<input type="hidden" name="media_move" value="1">
<?PHP } else { ?>
<input type="hidden" name="install_step" value="3">
<?PHP } ?>
<input type="hidden" name="license" value="<?PHP echo $license; ?>">
<input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
</form><?PHP } ?>
</span>
</div>

<br /><br />

<table class="table table-striped table-bordered">
<thead>
<tr>
<th>Folder Name</th>
<th>Status</th>
</tr>
</thead>
<tbody>
<?PHP if (isset($banner_count)) { ?>
<tr>
<td><?PHP echo directory_status_label("../media/banners/"); ?></td>
<td><?PHP directory_status("../media/banners/"); ?><span class="pull-right"><div class="label label-info">Required</div></span></td>
</tr>
<?PHP } ?>
<?PHP if (isset($pdf_email_count)) { ?>
<tr>
<td><?PHP echo directory_status_label("../media/email_attachments/"); ?></td>
<td><?PHP directory_status("../media/email_attachments/"); ?><span class="pull-right"><div class="label label-info">Required</div></span></td>
</tr>
<?PHP } ?>
<?PHP if (isset($lightbox_count)) { ?>
<tr>
<td><?PHP echo directory_status_label("../media/lightboxes/"); ?></td>
<td><?PHP directory_status("../media/lightboxes/"); ?><span class="pull-right"><div class="label label-info">Required</div></span></td>
</tr>
<?PHP } ?>
<?PHP if (isset($pagepeels_count)) { ?>
<tr>
<td><?PHP echo directory_status_label("../media/pagepeels/"); ?></td>
<td><?PHP directory_status("../media/pagepeels/"); ?><span class="pull-right"><div class="label label-info">Required</div></span></td>
</tr>
<?PHP } ?>
<?PHP if (isset($pdf_count)) { ?>
<tr>
<td><?PHP echo directory_status_label("../media/pdf/"); ?></td>
<td><?PHP directory_status("../media/pdf/"); ?><span class="pull-right"><div class="label label-info">Required</div></span></td>
</tr>
<?PHP } ?>
<?PHP if (isset($logo_count)) { ?>
<tr>
<td><?PHP echo directory_status_label("../assets/logos/"); ?></td>
<td><?PHP directory_status("../assets/logos/"); ?><span class="pull-right"><div class="label label-info">Required</div></span></td>
</tr>
<?PHP } ?>
<tr>
<td><?PHP echo directory_status_label("../plugin_keys/"); ?></td>
<td><?PHP directory_status("../plugin_keys/"); ?><span class="pull-right"><div class="label label-info">Required</div></span></td>
</tr>
<tr>
<td><?PHP echo directory_status_label("../assets/pictures/"); ?></td>
<td><?PHP directory_status("../assets/pictures/"); ?></td>
</tr>
<tr>
<td><?PHP echo directory_status_label("../assets/note_images/"); ?></td>
<td><?PHP directory_status("../assets/note_images/"); ?></td>
</tr>
<tr>
<td><?PHP echo directory_status_label("../media/qr_codes/"); ?></td>
<td><?PHP directory_status("../media/qr_codes/"); ?></td>
</tr>
<tr>
<td><?PHP echo directory_status_label("../API/"); ?></td>
<td><?PHP directory_status("../API/"); ?></td>
</tr>
<tr>
<td><?PHP echo directory_status_label("../connect/"); ?></td>
<td><?PHP directory_status("../connect/"); ?></td>
</tr>
</tbody>
</table>

<?PHP } else { ?>

<p style="margin-bottom:30px;">We are creating new files and need the following folders to have <strong>write</strong> permissions.</p>

<?PHP if (!isWritable("../API/")) { $throw_error = true; } ?>
<?PHP if (!isWritable("../admin/carts/")) { $throw_error = true; } ?>
<?PHP if (!isWritable("../connect/")) { $throw_error = true; } ?>

<?PHP if (isset($throw_error)) { ?>
<div class="alert alert-danger">
<h4>Important Notice!</h4>
We can't continue past this point until the required folders have write permissions. Please see the list below.<br />
</div>
<?PHP } ?>

<div>
<span class="pull-right">
<form class="form-horizontal" role="form" method="post" action="upgrade.php" style="display:inline-block;">
<button type="submit" class="btn btn-primary btn-sm">Refresh This Page</button>
<input type="hidden" name="install_step" value="2">
<input type="hidden" name="license" value="<?PHP echo $license; ?>">
<input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
</form>

<?PHP if (!isset($throw_error)) { ?><form class="form-horizontal" role="form" method="post" action="upgrade.php" style="display:inline-block;">
<button type="submit" class="btn btn-success btn-sm">Continue To Next Step</button>
<?PHP if ($current_version < 8) { ?>
<input type="hidden" name="install_step" value="2">
<?PHP } else { ?>
<input type="hidden" name="install_step" value="3">
<?PHP } ?>
<input type="hidden" name="license" value="<?PHP echo $license; ?>">
<input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
</form><?PHP } ?>
</span>
</div>

<br /><br />

<table class="table table-striped table-bordered">
<thead>
<tr>
<th>Folder Name</th>
<th>Status</th>
</tr>
</thead>
<tbody>
<tr>
<td><?PHP echo directory_status_label("../API/"); ?></td>
<td><?PHP directory_status("../API/"); ?></td>
</tr>
<tr>
<td><?PHP echo directory_status_label("../connect/"); ?></td>
<td><?PHP directory_status("../connect/"); ?></td>
</tr>
<tr>
<td><?PHP echo directory_status_label("../admin/carts/"); ?></td>
<td><?PHP directory_status("../admin/carts/"); ?></td>
</tr>
<tr>
<td><?PHP echo directory_status_label("../plugin_keys/"); ?></td>
<td><?PHP directory_status("../plugin_keys/"); ?></td>
</tr>
</tbody>
</table>

<?PHP } } } ?>

<?PHP if ((isset($_POST['install_step'])) && ($_POST['install_step'] == 3)) { ?>

<h4>Upgrade Step #3<span class="pull-right"><small>Update the database.</small></span></h4>
<hr style="margin-bottom:15px;" />

<?PHP include("includes/notifications.php"); ?>

<?PHP if (!isset($_POST['install_tables'])) { ?>
<p style="margin-bottom:30px;">Please take a moment now to make sure you have a backup of your existing database.  Once this is done, click the button below to complete the update.</p>
<?PHP } ?>
<form class="form-horizontal" role="form" method="post" action="upgrade.php" id="db_upgrade_form">
<input type="hidden" name="license" value="<?PHP echo isset($license) ? $license : ''; ?>">
<input type="hidden" name="license_method" value="<?PHP echo isset($license_method) ? $license_method : ''; ?>">

<?PHP if (!isset($_POST['install_tables'])) { ?>
<input type="hidden" name="install_step" value="3">
<input type="hidden" name="install_tables" value="1">
<button type="submit" class="btn btn-success btn-sm" id="install_database">Update My Database</button>

<?PHP } else { ?>
<input type="hidden" name="install_step" value="4">
<input type="hidden" name="license" value="<?PHP echo isset($license) ? $license : ''; ?>">
<input type="hidden" name="license_method" value="<?PHP echo isset($license_method) ? $license_method : ''; ?>">
<button type="submit" class="btn btn-success btn-sm">Continue To Next Step</button>

<?PHP } ?>

</form>

	<div class="modal fade" id="myModal" tabindex="-1" role="dialog">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-body" style="text-align: center;">

					<p id="db_update_modal_msg">We are completing your upgrade. This may take a few minutes...</p>

					<div class="progress">
						<div class="progress-bar progress-bar-success progress-bar-striped" id="upgradeProgressbarMain" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="min-width: 2em;"></div>
					</div>

					<p id="current_upgrade_message"></p>

					<div id="current_upgrade_process_bar">
						<div class="loading-progress"></div>
					</div>

				</div>
			</div><!-- /.modal-content -->
		</div><!-- /.modal-dialog -->
	</div><!-- /.modal -->
<?php
//generate variables

$current_version_key = 0;
if( in_array($current_version, $version_available_for_upgrade) ) {
	$current_version_key = array_search( $current_version, $version_available_for_upgrade );
}

$next_version_to_upgrade = "";
$next_version_key = 0;
if( in_array($current_version, $version_available_for_upgrade) ) {
	$key_now = array_search( $current_version, $version_available_for_upgrade );
	$key_now++;
	if ( array_key_exists($key_now, $version_available_for_upgrade) ) {
		$next_version_to_upgrade = $version_available_for_upgrade[$key_now];
		$next_version_key = $key_now;
	}
}

$total_upgrade_available = 0;

$total_versions_count = count($version_available_for_upgrade);
$total_upgrade_available = $total_versions_count - $current_version_key - 1;


?>


<script type="text/javascript">
	jQuery(function($) {
		var latest_version = '<?php echo $version; ?>';
		var available_versions = <?php echo json_encode($version_available_for_upgrade); ?>;

		var current_version = '<?php echo $current_version; ?>';
		var current_version_key = <?php echo $current_version_key; ?>;

		var next_version_to_upgrade ='<?php  echo $next_version_to_upgrade; ?>';

		var next_version_key = <?php  echo $next_version_key; ?>;

		var total_versions_count = <?php echo $total_versions_count; ?>;
		var total_upgrade_available = <?php echo $total_upgrade_available; ?>;

		var db_check_completed = false;

		var time_limit = 600;

		var db_indexes_updated = false;
		var db_ip_updated = false;
        
        var check_version_interval;
        var progress;
        
		function call_ajax()  {
			//check upgrade is done or not
			if ( current_version == latest_version ) {

				if ( db_check_completed == true ) {

					include_db_index();

					return;

				} else {
					time_limit = 2400;
					db_check_completed = true;
				}
			}

			//change upgrade text
			if ( db_check_completed == false ) {
				$('#current_upgrade_message').html('Upgrading from iDevAffiliate ' + current_version + ' to ' +  next_version_to_upgrade);
			}
			else {
				$('#current_upgrade_message').html('Normalizing Database');
			}


			//show last progressbar
			$('#current_upgrade_process_bar').html('<div class="loading-progress"></div>');

			progress = $(".loading-progress").progressTimer({
				timeLimit: time_limit,
				warningThreshold: time_limit / 3
			});

			//call ajax
			if(current_version == latest_version){
			    var now_include_var = 'db_check';   
			}
			else{
			    var now_include_var = '';   
			}
// 			$.post('upgrade.php',{ajax_upgrade:'1', install_step:'3', install_tables: '1',now_include:now_include_var, license: '<?PHP echo isset($license) ? $license : '' ; ?>', license_method:'<?PHP echo isset($license_method) ? $license_method: '' ; ?>' }, function(data){
// 				data = $.trim(data);
// 				data = data.replace(/\n/g, "");
// 				data = data.replace(/\r/g, "");
// 				data = JSON.parse(data);

// 				if (data.success) {

// 					//complete second progressbar
// 					progress.progressTimer('complete');

// 					//show main progressbar
// 					var progress1Value = 100 / (total_upgrade_available + 2);
// 					$('#upgradeProgressbarMain').css('width', progress1Value + '%').attr('aria-valuenow', progress1Value);

// 					if ( current_version == latest_version ) {
// 						//upgrade completed
// 						if ( db_check_completed == true ) {

//                             include_db_index();
//                             return;
                            
							

// 						} else {
// 							call_ajax();
// 						}

// 					} else {
// 						total_upgrade_available = total_upgrade_available - 1;

// 						//get next update version
// 						current_version = next_version_to_upgrade;
// 						current_version_key = next_version_key;

// 						next_version_key = next_version_key + 1;
// 						next_version_to_upgrade = available_versions[next_version_key];

// 						//call ajax again
// 						if ( current_version != latest_version || db_check_completed != true) {
// 							call_ajax();
// 						}
// 					}



// 				}

// 				if (data.error) {
// 					$('#db_update_modal_msg').html(data.error);
// 					//th.attr('disabled', false);
// 					progress.progressTimer('error', {
// 						errorText:'ERROR!',
// 						onFinish:function(){
// 							//alert('There was an error processing your information!');
// 						}
// 					});
// 				}
// 			});
			
			$.ajax({
			    url:'upgrade.php',
			    method:'POST',
			    data:{ajax_upgrade:'1', install_step:'3', install_tables: '1',now_include:now_include_var, license: '<?PHP echo isset($license) ? $license : '' ; ?>', license_method:'<?PHP echo isset($license_method) ? $license_method: '' ; ?>' },
			    success:(data)=>{
			            data = $.trim(data);
				data = data.replace(/\n/g, "");
				data = data.replace(/\r/g, "");
				data = JSON.parse(data);

				if (data.success) {

					//complete second progressbar
					progress.progressTimer('complete');

					//show main progressbar
					var progress1Value = 100 / (total_upgrade_available + 2);
					$('#upgradeProgressbarMain').css('width', progress1Value + '%').attr('aria-valuenow', progress1Value);

					if ( current_version == latest_version ) {
						//upgrade completed
						if ( db_check_completed == true ) {

                            include_db_index();
                            return;
                            
							

						} else {
							call_ajax();
						}

					} else {
						total_upgrade_available = total_upgrade_available - 1;

						//get next update version
						current_version = next_version_to_upgrade;
						current_version_key = next_version_key;

						next_version_key = next_version_key + 1;
						next_version_to_upgrade = available_versions[next_version_key];

						//call ajax again
						if ( current_version != latest_version || db_check_completed != true) {
							call_ajax();
						}
					}



				}

				if (data.error) {
					$('#db_update_modal_msg').html(data.error);
					//th.attr('disabled', false);
					progress.progressTimer('error', {
						errorText:'ERROR!',
						onFinish:function(){
							//alert('There was an error processing your information!');
						}
					});
				}
			    },
			    error:(error)=>{
			        
			        check_version_interval = setInterval(()=>{
    			        check_version();
			        },3000);
			        
			    }
			})
			
		}
		
		
		 function check_version(){
            $.ajax({
        			    url:'check_version.php',
        			    method:'POST',
        			    success:(response)=>{
        			        if(response > current_version){
        			            progress.progressTimer('complete');
            
            					//show main progressbar
            					var progress1Value = 100 / (total_upgrade_available + 2);
            					if(progress1Value>=100 && progress1Value < 200){
            					    progress1Value = progress1Value/2;
            					}
            					else if(progress1Value >= 200){
            					    progress1Value= 50;
            					}
            					$('#upgradeProgressbarMain').css('width', progress1Value + '%').attr('aria-valuenow', progress1Value);
            
            					if ( current_version == latest_version ) {
            						//upgrade completed
            						if ( db_check_completed == true ) {
            
                                        include_db_index();
                                        return;
                                        
            							
            
            						} else {
            							call_ajax();
            						}
            
            					} else {
            						total_upgrade_available = total_upgrade_available - 1;
            
            						//get next update version
            						current_version = next_version_to_upgrade;
            						current_version_key = next_version_key;
            
            						next_version_key = next_version_key + 1;
            						next_version_to_upgrade = available_versions[next_version_key];
            
            						//call ajax again
            						if ( current_version != latest_version || db_check_completed != true) {
            							call_ajax();
            						}
            					}
            					check_version_interval.clearInterval();

        			        }
        			    }
			        });
        }
       
		
		function include_db_index(){
		    
		    
				
		    
		    setTimeout(function () {
								$('#upgradeProgressbarMain').css('width', '95%').attr('aria-valuenow', 95);
								$('#current_upgrade_message').html('Indexing Database');
								update_indexes();
							}, 1500);

							return;
		}

		function update_indexes() {

			if ( db_check_completed !== true ) {
				return;
			}

			if ( db_indexes_updated === true ) {
			    update_ip();
				return;
			}

			//show last progressbar
			$('#current_upgrade_process_bar').html('<div class="loading-progress"></div>');

			var progress = $(".loading-progress").progressTimer({
				timeLimit: time_limit,
				warningThreshold: time_limit / 3
			});


			//call ajax
			$.post('upgrade.php',{db_indexes:'1',now_include:'db_index', ajax_upgrade:'1', install_step:'3', install_tables: '1', license: '<?PHP echo isset($license) ? $license : '' ; ?>', license_method:'<?PHP echo isset($license_method) ? $license_method: '' ; ?>' }, function(data){
				data = $.trim(data);
				data = data.replace(/\n/g, "");
				data = data.replace(/\r/g, "");
				data = JSON.parse(data);

				if (data.success) {
					db_indexes_updated = true;

					//complete second progressbar
					progress.progressTimer('complete');

					//upgrade completed
					if (db_check_completed == true) {
					    setTimeout(function () {
								$('#upgradeProgressbarMain').css('width', '95%').attr('aria-valuenow', 95);
								$('#current_upgrade_message').html('Updating IP Tables');
								update_ip();
							}, 1500);
							
						
						return false;
					}
				}

				if (data.error) {
					$('#db_update_modal_msg').html(data.error);
					//th.attr('disabled', false);
					progress.progressTimer('error', {
						errorText:'ERROR!',
						onFinish:function(){
							//alert('There was an error processing your information!');
						}
					});
				}
			});

		}

		function update_ip() {

			if ( db_check_completed !== true ) {
				return;
			}

			if ( db_indexes_updated !== true ) {
				return;
			}
			if ( db_ip_updated === true ) {
				return;
			}

			//show last progressbar
			$('#current_upgrade_process_bar').html('<div class="loading-progress"></div>');

			var progress = $(".loading-progress").progressTimer({
				timeLimit: time_limit,
				warningThreshold: time_limit / 3
			});


			//call ajax
			$.post('upgrade.php',{db_indexes:'1',now_include:'db_ip', ajax_upgrade:'1', install_step:'3', install_tables: '1', license: '<?PHP echo isset($license) ? $license : '' ; ?>', license_method:'<?PHP echo isset($license_method) ? $license_method: '' ; ?>' }, function(data){
				data = $.trim(data);
				data = data.replace(/\n/g, "");
				data = data.replace(/\r/g, "");
				data = JSON.parse(data);

				if (data.success) {
					db_ip_updated = true;

					//complete second progressbar
					progress.progressTimer('complete');

					//upgrade completed
					if (db_check_completed == true) {
						$('#upgradeProgressbarMain').css('width', '100%').attr('aria-valuenow', 100);
						$('#db_update_modal_msg').html('Database Upgrade Completed. Redirecting now....');
						setTimeout(function () {
							var $form = $('#db_upgrade_form');
							$form.get(0).submit();
						}, 3000);
						return false;
					}
				}

				if (data.error) {
					$('#db_update_modal_msg').html(data.error);
					//th.attr('disabled', false);
					progress.progressTimer('error', {
						errorText:'ERROR!',
						onFinish:function(){
							//alert('There was an error processing your information!');
						}
					});
				}
			});

		}



		$('#install_database').click(function(){
			//show modal with progressbar
			var th = $(this);
			th.attr('disabled', 'disabled');
			$('#myModal').modal();

			call_ajax();

			return false;
		});
	});
</script>


<?PHP } ?>

<?PHP if ((isset($_POST['install_step'])) && ($_POST['install_step'] == 4)) { ?>

<h4>Upgrade Step #4<span class="pull-right"><small>Admin login.</small></span></h4>
<hr style="margin-bottom:15px;" />

<?PHP include("includes/notifications.php"); ?>

<?PHP
$getad = $db->query("select record from idevaff_admin");
$getad = $getad->rowCount();
if ($getad) {
?>
<?php if (!isset($_POST['create'])) { ?><p>Your admin account is still in tact and exists as it did prior to upgrade. You can skip this step.</p><?PHP } ?>
<form class="form-horizontal" role="form" method="post" action="upgrade.php">
<button type="submit" class="btn btn-success btn-sm">Continue To Next Step</button>
<input type="hidden" name="install_step" value="5">
<input type="hidden" name="license" value="<?PHP echo $license; ?>">
<input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
</form>
<?PHP } else {
	include_once($path . "/includes/functions.php");
?>

<p style="margin-bottom:30px;">Let's create your administrative login and get you logged in to your new affiliate program!</p>
<form class="form-horizontal" role="form" method="post" action="upgrade.php">
<div class="form-group">
<label class="col-md-3 control-label">Username</label>
<div class="col-md-9"><input type="text" name="ad_username" value="<?PHP if (isset($_POST['ad_username'])) { echo html_output($_POST['ad_username']); } else { echo "admin"; } ?>" class="form-control" placeholder="admin" /><p class="help-block">This is your username for your administrative center.<br />- Must be 4 to 12 characters in length.</p>
</div>
</div>
<div class="form-group">
<label class="col-md-3 control-label">Password</label>
<div class="col-md-9"><input type="password" name="ad_password" value="<?PHP if (isset($_POST['ad_password'])) { echo html_output($_POST['ad_password']); } ?>" class="form-control" placeholder="" /><p class="help-block">Your password must be alpha-numeric and can also include underscores.<br />- Must be 4 to 12 characters in length.</p>
</div>
</div>
<div class="form-group">
<label class="col-md-3 control-label">Verify Password</label>
<div class="col-md-9"><input type="password" name="vr_password" value="<?PHP if (isset($_POST['vr_password'])) { echo html_output($_POST['vr_password']); } ?>" class="form-control" placeholder="" /><p class="help-block">Make sure this entry matches your password above.</p>
</div>
</div>
<div class="form-group">
<label class="col-md-3 control-label">Email Address</label>
<div class="col-md-9"><input type="text" name="email" value="<?PHP if (isset($_POST['email'])) { echo html_output($_POST['email']); } ?>" class="form-control" placeholder="your@email.com" /><p class="help-block">We need this should you ever need to request your login details in the future.</p>
</div>
</div>
<div class="form-group">
<div class="col-sm-offset-3 col-sm-9">
<button type="submit" class="btn btn-primary btn-sm">Create My Login</button>
</div>
</div>
<input type="hidden" name="install_step" value="4">
<input type="hidden" name="license" value="<?PHP echo $license; ?>">
<input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
<input type="hidden" name="create" value="1">
</form>

<?PHP } } ?>

<?PHP if ((isset($_POST['install_step'])) && ($_POST['install_step'] == 5)) { ?>

<h4>Upgrade Step #5<span class="pull-right"><small>Bookmark your affiliate program locations.</small></span></h4>
<hr style="margin-bottom:15px;" />
<h2 style="margin-bottom:30px;">Congratulations! <small>Your upgrade is complete.</small></h2>

<div class="well">Please take a moment to go through your post-upgrade steps below.</div>
<ol>
<li style="margin-bottom:10px;">Remove or rename the <strong>/install</strong> folder. Your admin center won't run with it in tact.</li>
<li style="margin-bottom:10px;">Delete all files in the <strong>/cache</strong> folder. Your affiliate panel won't appear correctly if this isn't done.</li>
<li style="margin-bottom:10px;">Make sure the <strong>/cache</strong> folder has full write permissions (777).</li>
<li style="margin-bottom:10px;">Clear your browser cache to ensure you see all the new features.</li>
</ol>
<br /><br />
<div>
<form method="post" action="../index.php" target="_blank" style="display:inline-block; margin-right:15px">
<input type="submit" name="admin" value="View Affiliate Control Panel" class="btn btn-lg btn-primary" />
</form> <form method="post" action="../admin/index.php" target="_blank" style="display:inline-block; margin-left:15px">
<input type="submit" name="admin" value="Login To Admin Center" class="btn btn-lg btn-danger" />
</form>
</div>

<?PHP } ?>

</div>



</div>
</div>





</div>
</div>

<div id="footer">
<div class="container">
<p class="text-muted credit pull-right">Copyright 1999-<?PHP echo date("Y"); ?> - iDevAffiliate Inc. - <a href="https://www.idevdirect.com/" target="_blank">iDevAffiliate</a></p>
</div>
</div>

</body>
</html>
