<?PHP

$tabnum = 0;  

$db->query("CREATE TABLE IF NOT EXISTS idevaff_admin (
  record tinyint UNSIGNED NOT NULL auto_increment,
  adminid varchar(512) character set utf8 NULL DEFAULT NULL,
  adminpass varchar(512) character set utf8 NULL DEFAULT NULL,
  super tinyint UNSIGNED NOT NULL default '0',
  email varchar(255) character set utf8 NULL DEFAULT NULL,
  code bigint UNSIGNED NOT NULL default '0',
  user_key varchar(255) character set utf8 NULL DEFAULT NULL,
  api_key varchar(64) character set utf8 NULL DEFAULT NULL,
  PRIMARY KEY (record)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_admin_lockout (
  id int UNSIGNED NOT NULL auto_increment,
  ip varchar(64) character set utf8 NULL DEFAULT NULL,
  attempts tinyint UNSIGNED NOT NULL DEFAULT '0',
  code bigint UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_ads (
  id int UNSIGNED NOT NULL auto_increment,
  grp int UNSIGNED NOT NULL default '0',
  title varchar(64) character set utf8 NULL DEFAULT NULL,
  text text NULL,
  hits int UNSIGNED NOT NULL default '0',
  conv int UNSIGNED NOT NULL default '0',
  sort int NOT NULL default '0',
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_ads_default (
  ad_target varchar(10) character set utf8 NULL DEFAULT NULL,
  BoxWidth varchar(10) character set utf8 NULL DEFAULT NULL,
  OutlineColor varchar(10) character set utf8 NULL DEFAULT NULL,
  TitleTextColor varchar(10) character set utf8 NULL DEFAULT NULL,
  TitleTextBackgroundColor varchar(10) character set utf8 NULL DEFAULT NULL,
  LinkColor varchar(10) character set utf8 NULL DEFAULT NULL,
  TextColor varchar(10) character set utf8 NULL DEFAULT NULL,
  TextBackgroundColor varchar(10) character set utf8 NULL DEFAULT NULL,
  title varchar(64) character set utf8 NULL DEFAULT NULL,
  content text NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_affiliates (
  id int UNSIGNED NOT NULL auto_increment,
  fb_user_id varchar(255) character set utf8 NULL DEFAULT NULL,
  username varchar(512) character set utf8 NULL DEFAULT NULL,
  password varchar(512) character set utf8 NULL DEFAULT NULL,
  approved tinyint UNSIGNED NOT NULL default '0',
  suspended tinyint UNSIGNED NOT NULL default '0',
  payable varchar(64) character set utf8 NULL DEFAULT NULL,
  tax_id_ssn blob NULL,
  company varchar(128) character set utf8 NULL DEFAULT NULL,
  f_name varchar(64) character set utf8 NULL DEFAULT NULL,
  l_name varchar(64) character set utf8 NULL DEFAULT NULL,
  email varchar(64) character set utf8 NULL DEFAULT NULL,
  address_1 varchar(64) character set utf8 NULL DEFAULT NULL,
  address_2 varchar(64) character set utf8 NULL DEFAULT NULL,
  city varchar(64) character set utf8 NULL DEFAULT NULL,
  state varchar(40) character set utf8 NULL DEFAULT NULL,
  zip varchar(20) character set utf8 NULL DEFAULT NULL,
  country varchar(64) character set utf8 NULL DEFAULT NULL,
  phone varchar(40) character set utf8 NULL DEFAULT NULL,
  fax varchar(40) character set utf8 NULL DEFAULT NULL,
  url varchar(128) character set utf8 NULL DEFAULT NULL,
  pp tinyint UNSIGNED NOT NULL default '0',
  paypal varchar(64) character set utf8 NULL DEFAULT NULL,
  hits_in int UNSIGNED NOT NULL default '0',
  unique_hits_in int UNSIGNED NOT NULL DEFAULT '0',
  conv int UNSIGNED NOT NULL default '0',
  type tinyint UNSIGNED NOT NULL default '0',
  level tinyint UNSIGNED NOT NULL default '0',
  a1 tinyint UNSIGNED NOT NULL default '1',
  a2 tinyint UNSIGNED NOT NULL default '1',
  a3 tinyint UNSIGNED NOT NULL default '1',
  alert tinyint UNSIGNED NOT NULL default '0',
  installed tinyint UNSIGNED NOT NULL default '0',
  signup_date bigint UNSIGNED NOT NULL default '0',
  email_override varchar(64) character set utf8 NULL DEFAULT NULL,
  tc_status tinyint UNSIGNED NOT NULL default '0',
  ip varchar(64) character set utf8 NULL DEFAULT NULL,
  picture varchar(255) character set utf8 NULL DEFAULT NULL,
  stripe_user_data mediumtext NULL,
  pay_method tinyint UNSIGNED NOT NULL default '0',
  user_key varchar(255) character set utf8 NULL DEFAULT NULL,
  vat_override tinyint UNSIGNED NOT NULL default '0',
  expire int UNSIGNED NOT NULL default '0',
  expire_type tinyint UNSIGNED NOT NULL default '0',
  expire_stamp bigint UNSIGNED NOT NULL default '0',
  indi_incoming varchar(512) character set utf8 NULL DEFAULT NULL,
  last_logged int UNSIGNED NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS `idevaff_announcements` (
                      `number` int unsigned NOT NULL AUTO_INCREMENT,
                      `grp` int unsigned NOT NULL DEFAULT '0',
                      `announcement_name` varchar(255) DEFAULT NULL,
                      `channel` varchar(60) DEFAULT NULL,
                      `message` text,
                      `picture` varchar(255) DEFAULT NULL,
                      `sort` int NOT NULL DEFAULT '0',
                      `local` tinyint unsigned NOT NULL DEFAULT '0',
                      PRIMARY KEY (`number`)
                    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_archive (
  record int UNSIGNED NOT NULL auto_increment,
  id int UNSIGNED NOT NULL default '0',
  payment decimal(20,2) NOT NULL default '0.00',
  tier int UNSIGNED NOT NULL default '0',
  top_tier_tag tinyint UNSIGNED NOT NULL default '0',
  bonus tinyint UNSIGNED NOT NULL default '0',
  stamp bigint UNSIGNED NOT NULL default '0',
  tier_id int UNSIGNED NOT NULL default '0',
  tracking varchar(64) character set utf8 NULL DEFAULT NULL,
  op1 varchar(64) character set utf8 NULL DEFAULT NULL,
  op2 varchar(64) character set utf8 NULL DEFAULT NULL,
  op3 varchar(64) character set utf8 NULL DEFAULT NULL,
  amount decimal(20,2) NOT NULL default '0.00',
  type tinyint UNSIGNED NOT NULL default '0',
  split varchar(128) character set utf8 NULL DEFAULT NULL,
  profile int UNSIGNED NOT NULL default '0',
  tid1 varchar(255) character set utf8 NULL DEFAULT NULL,
  tid2 varchar(255) character set utf8 NULL DEFAULT NULL,
  tid3 varchar(255) character set utf8 NULL DEFAULT NULL,
  tid4 varchar(255) character set utf8 NULL DEFAULT NULL,
  target_url varchar(500) character set utf8 NULL DEFAULT NULL,
  sub_id varchar(64) character set utf8 NULL DEFAULT NULL,
  payment_rec varchar(255) character set utf8 NULL DEFAULT NULL,
  referring_url varchar(500) character set utf8 NULL DEFAULT NULL,
  currency varchar(10) character set utf8 NULL DEFAULT NULL,
  converted_amount decimal(20,2) NOT NULL default '0.00',
  override tinyint UNSIGNED NOT NULL default '0',
  override_id int UNSIGNED NOT NULL default '0',
  code bigint UNSIGNED NOT NULL default '0',
  geo varchar(2) character set utf8 NULL DEFAULT NULL,
  ip varchar(64) character set utf8 NULL DEFAULT NULL,
  tracking_method varchar(255) character set utf8 NULL DEFAULT NULL,
  notes mediumtext NULL,
  KEY record (record)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_banned_email (
  id int UNSIGNED NOT NULL auto_increment,
  email_address varchar(255) character set utf8 NULL DEFAULT NULL,
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_banned_ip (
  id int UNSIGNED NOT NULL auto_increment,
  ip_address varchar(255) character set utf8 NULL DEFAULT NULL,
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_banners (
  number int UNSIGNED NOT NULL auto_increment,
  grp int UNSIGNED NOT NULL default '0',
  size1 int UNSIGNED NOT NULL default '0',
  size2 int UNSIGNED NOT NULL default '0',
  image varchar(255) character set utf8 NULL DEFAULT NULL,
  description text NULL,
  hits int UNSIGNED NOT NULL default '0',
  conv int UNSIGNED NOT NULL default '0',
  alt_tag varchar(255) character set utf8 NULL DEFAULT NULL,
  sort int NOT NULL default '0',
  local tinyint UNSIGNED NOT NULL default '0',
  PRIMARY KEY  (number)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_canspam (
  display tinyint UNSIGNED NOT NULL default '0',
  forced tinyint UNSIGNED NOT NULL default '0',
  canspam text NULL,
  KEY display (display)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_carts (
  id int UNSIGNED NOT NULL AUTO_INCREMENT,
  name varchar(128) character set utf8 NULL DEFAULT NULL,
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_carts_data (
table_id int UNSIGNED NOT NULL DEFAULT '1',
KEY display (table_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_commission_override (
  t_id int UNSIGNED NOT NULL auto_increment,
  id int UNSIGNED NOT NULL default '0',
  slave int UNSIGNED NOT NULL default '0',
  commission_amount decimal(10,2) NOT NULL default '0.00',
  commission_type tinyint UNSIGNED NOT NULL default '0',
  tag tinyint UNSIGNED NOT NULL default '0',
  PRIMARY KEY  (t_id),
  UNIQUE KEY id (id,slave)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_config (
  sitename varchar(128) character set utf8 NULL DEFAULT NULL,
  siteurl varchar(255) character set utf8 NULL DEFAULT NULL,
  base_url varchar(255) character set utf8 NULL DEFAULT NULL,
  default_destination varchar(255) character set utf8 NULL DEFAULT NULL,
  cookie_url varchar(128) character set utf8 NULL DEFAULT NULL,
  main_logo varchar(255) character set utf8 NULL DEFAULT NULL,
  account_approval tinyint UNSIGNED NOT NULL default '0',
  sale_approval_1 tinyint UNSIGNED NOT NULL default '0',
  sale_approval_2 tinyint UNSIGNED NOT NULL default '0',
  sale_approval_3 tinyint UNSIGNED NOT NULL default '0',
  welcome_email tinyint UNSIGNED NOT NULL default '0',
  balance decimal(10,2) NOT NULL default '0.00',
  startnumber int UNSIGNED NOT NULL default '0',
  initialbalance decimal(10,2) NOT NULL default '0.00',
  paytype tinyint UNSIGNED NOT NULL default '0',
  ap_1 tinyint UNSIGNED NOT NULL default '0',
  ap_2 tinyint UNSIGNED NOT NULL default '0',
  ap_3 tinyint UNSIGNED NOT NULL default '0',
  def_pay tinyint UNSIGNED NOT NULL default '0',
  mailadmin tinyint UNSIGNED NOT NULL default '0',
  currency varchar(10) character set utf8 NULL DEFAULT NULL,
  cur_sym varchar(10) character set utf8 NULL DEFAULT NULL,
  notify tinyint UNSIGNED NOT NULL default '0',
  paypal tinyint UNSIGNED NOT NULL default '0',
  stripe_api_secret blob NULL,
  stripe_client_id blob NULL,  
  browse tinyint UNSIGNED NOT NULL default '0',
  sale_notify tinyint UNSIGNED NOT NULL default '0',
  sale_notify_ppc tinyint UNSIGNED NOT NULL default '0',
  sale_notify_affiliate tinyint UNSIGNED NOT NULL default '0',
  sale_notify_affiliate_ppc tinyint UNSIGNED NOT NULL default '0',
  payday varchar(5) character set utf8 NULL DEFAULT NULL,
  delay_minutes int UNSIGNED NOT NULL default '0',
  max_size int UNSIGNED NOT NULL default '0',
  aff_lock tinyint UNSIGNED NOT NULL default '0',
  expire int UNSIGNED NOT NULL default '0',
  expire_type tinyint UNSIGNED NOT NULL default '0',
  expire_stamp bigint UNSIGNED NOT NULL default '0',
  sessions tinyint UNSIGNED NOT NULL default '0',
  offline tinyint UNSIGNED NOT NULL default '0',
  offline_loc varchar(128) character set utf8 NULL DEFAULT NULL,
  offline_send varchar(128) character set utf8 NULL DEFAULT NULL,
  offline_tag varchar(64) character set utf8 NULL DEFAULT NULL,
  rew_notify tinyint UNSIGNED NOT NULL default '0',
  rew_admin_notify tinyint UNSIGNED NOT NULL default '0',
  links tinyint UNSIGNED NOT NULL default '0',
  mod_later tinyint UNSIGNED NOT NULL default '0',
  faq tinyint UNSIGNED NOT NULL default '0',
  idev_affiliate varchar(10) character set utf8 NULL DEFAULT NULL,
  link_style tinyint UNSIGNED NOT NULL default '0',
  mark_track tinyint UNSIGNED NOT NULL default '0',
  version varchar(20) character set utf8 NULL DEFAULT NULL,
  license varchar(64) character set utf8 NULL DEFAULT NULL,
  license_method enum('phpaudit_exec_socket','phpaudit_exec_curl','file_get_contents') character set utf8 NOT NULL default 'phpaudit_exec_socket',
  license_local_key blob NOT NULL,
  show_idev tinyint UNSIGNED NOT NULL default '0',
  com_show tinyint UNSIGNED NOT NULL default '0',
  com_show_add tinyint UNSIGNED NOT NULL default '0',
  panel_width int UNSIGNED NOT NULL default '0',
  page_style char(1) character set utf8 NULL DEFAULT NULL,
  panel_align varchar(6) character set utf8 NULL DEFAULT NULL,
  tlinks tinyint UNSIGNED NOT NULL default '0',
  use_keywords tinyint UNSIGNED NOT NULL default '0',
  pend_show tinyint UNSIGNED NOT NULL default '0',
  filename varchar(128) character set utf8 NULL DEFAULT NULL,
  lead_approval tinyint UNSIGNED NOT NULL default '0',
  secret int UNSIGNED NOT NULL default '0',
  second_contact tinyint UNSIGNED NOT NULL default '0',
  pass_var varchar(32) character set utf8 NULL DEFAULT NULL,
  use_security tinyint UNSIGNED NOT NULL default '0',
  ip_setting varchar(64) character set utf8 NULL DEFAULT NULL,
  admin_notify_logo tinyint UNSIGNED NOT NULL default '0',
  affiliate_notify_logo tinyint UNSIGNED NOT NULL default '0',
  sub_enable tinyint UNSIGNED NOT NULL default '0',
  affiliate_notify_unapproved tinyint UNSIGNED NOT NULL default '0',
  bk_image varchar(255) character set utf8 NULL DEFAULT NULL,
  lightbox_link_text text NULL,
  account_notify_affiliate_approved tinyint UNSIGNED NOT NULL default '0',
  fraud_type tinyint UNSIGNED NOT NULL default '0',
  allow_alternate tinyint UNSIGNED NOT NULL default '0',
  duplicate_notify tinyint UNSIGNED NOT NULL default '0',
  faq_location tinyint UNSIGNED NOT NULL default '0',
  maint_mode tinyint UNSIGNED NOT NULL default '0',
  marketing_delivery tinyint UNSIGNED NOT NULL default '0',
  commission_blocking tinyint UNSIGNED NOT NULL default '0',
  cur_sym_location tinyint UNSIGNED NOT NULL default '0',
  decimal_symbols tinyint UNSIGNED NOT NULL default '0',
  char_set varchar(24) character set utf8 NULL DEFAULT NULL,
  emails_allowed int UNSIGNED NOT NULL default '0',
  recaptcha_site_key varchar(255) NULL default null,
  recaptcha_secret_key varchar(255) NULL default null,
  auto_add_ban tinyint UNSIGNED NOT NULL default '0',
  auto_add_suspension tinyint UNSIGNED NOT NULL default '0',
  user_min int UNSIGNED NOT NULL default '0',
  pass_min int UNSIGNED NOT NULL default '0',
  bonus_commission tinyint UNSIGNED NOT NULL default '0',
  tier_numbers tinyint UNSIGNED NOT NULL default '0',
  staff varchar(64) character set utf8 NULL DEFAULT NULL,
  redirect_method int UNSIGNED NOT NULL default '0',
  standard_link_structure tinyint UNSIGNED NOT NULL default '0',
  seo_link_structure tinyint UNSIGNED NOT NULL default '0',
  non_commissioned tinyint UNSIGNED NOT NULL default '0',
  seo_url varchar(255) character set utf8 NULL DEFAULT NULL,
  seo_link_extension tinyint UNSIGNED NOT NULL default '0',
  use_cookies tinyint UNSIGNED NOT NULL default '0',
  network tinyint UNSIGNED NOT NULL default '0',
  signup_api tinyint UNSIGNED NOT NULL default '0',
  coupon_priority tinyint UNSIGNED NOT NULL default '0',
  qsg tinyint UNSIGNED NOT NULL default '0',
  testimonials tinyint UNSIGNED NOT NULL default '0',
  testimonials_link tinyint UNSIGNED NOT NULL default '0',
  testimonials_security tinyint UNSIGNED NOT NULL default '0',
  admin_notify_testimonial tinyint UNSIGNED NOT NULL default '0',
  affiliate_approved_testimonial tinyint UNSIGNED NOT NULL default '0',
  link_type varchar(20) character set utf8 NULL DEFAULT NULL,
  main_chart int UNSIGNED NOT NULL default '0',
  main_chart_display tinyint UNSIGNED NOT NULL default '0',
  archive_comm tinyint UNSIGNED NOT NULL default '0',
  max_comm_amt decimal(20,2) NOT NULL default '0.00',
  max_comm_email tinyint UNSIGNED NOT NULL default '0',
  max_comm_use tinyint UNSIGNED NOT NULL default '0',
  private tinyint UNSIGNED NOT NULL default '0',
  email_tier_referral tinyint UNSIGNED NOT NULL default '0',
  theme varchar(255) character set utf8 NULL DEFAULT NULL,
  qr_codes tinyint UNSIGNED NOT NULL default '0',
  install_date bigint UNSIGNED NOT NULL default '0',
  logo_uploaded tinyint UNSIGNED NOT NULL default '0',
  qsg_box tinyint UNSIGNED NOT NULL default '0',
  message_check varchar(30) character set utf8 NULL DEFAULT NULL,
  pic_upload tinyint UNSIGNED NOT NULL default '0',
  vanity_codes tinyint UNSIGNED NOT NULL default '0',
  vanity_notify tinyint UNSIGNED NOT NULL default '0',
  aff_lib tinyint UNSIGNED NOT NULL default '0',
  toggle_bonus_display tinyint UNSIGNED NOT NULL default '0',
  suspended_location varchar(255) character set utf8 NULL DEFAULT NULL,
  login_count int UNSIGNED NOT NULL default '0',
  admin_theme tinyint UNSIGNED NOT NULL default '0',
  timezone varchar(100) character set utf8 NULL DEFAULT NULL,
  contact_form tinyint UNSIGNED NOT NULL default '0',
  contact_link tinyint UNSIGNED NOT NULL default '0',
  admin_notify_api_recurring tinyint UNSIGNED NOT NULL DEFAULT '0',
  admin_notify_api_delayed tinyint UNSIGNED NOT NULL DEFAULT '0',
  sale_generated_notify_affiliate tinyint UNSIGNED NOT NULL default '0',
  affiliate_notify_declined tinyint UNSIGNED NOT NULL default '0',
  seal tinyint UNSIGNED NOT NULL default '0',
  email_links_active tinyint UNSIGNED NOT NULL default '0',
  deb_show tinyint UNSIGNED NOT NULL default '0',
  protection_profile tinyint UNSIGNED NOT NULL default '0',
  protection_secret_key tinyint UNSIGNED NOT NULL default '0',
  tier_link_url varchar(255) character set utf8 NULL DEFAULT NULL,
  upgrade_notify tinyint UNSIGNED NOT NULL default '0',
  webhook_url varchar(512) character set utf8 NULL DEFAULT NULL,
  background_image varchar(255) character set utf8 NULL DEFAULT NULL,
  background_image_uploaded tinyint UNSIGNED NOT NULL default '0',
  chars_allowed varchar(24) character set utf8 NULL DEFAULT NULL,
  pass_geo tinyint UNSIGNED NOT NULL default '0',
  show_map tinyint UNSIGNED NOT NULL default '0',
  force_ssl tinyint UNSIGNED NOT NULL default '0',
  recruitment_bonus decimal(20,2) NOT NULL default '0',
  sliding tinyint UNSIGNED NOT NULL default '0',
  idev_date_format tinyint UNSIGNED NOT NULL default '0', 
  time_seconds tinyint UNSIGNED NOT NULL default '0',
  idev_time_format tinyint UNSIGNED NOT NULL default '0',
  gdpr_hide_ip tinyint UNSIGNED NOT NULL default '0',
  last_updated_video int unsigned NOT NULL DEFAULT 0,
  payment_pdf tinyint unsigned NOT NULL default 0,
  lead_notify_admin tinyint unsigned NOT NULL default 0,
  roi_enabled tinyint NOT NULL DEFAULT 0,
  roi_type tinyint NOT NULL DEFAULT 0,
  roi_percentage decimal(10,3) NOT NULL DEFAULT 0.000,
  cloud_level int NOT NULL default 0,
  ipv6 TINYINT UNSIGNED NOT NULL DEFAULT 0,
  UNIQUE KEY sitename (sitename)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_countries (
  id int UNSIGNED NOT NULL auto_increment,
  country_code text NULL,
  country_code_2_digits text NULL,
  country_name text NULL,
  def tinyint UNSIGNED NOT NULL default '0',
  status int UNSIGNED NOT NULL default '1',
  PRIMARY KEY id (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_coupons (
  id int UNSIGNED NOT NULL auto_increment,
  coupon_code varchar(128) character set utf8 NULL DEFAULT NULL,
  coupon_affiliate int UNSIGNED NOT NULL default '0',
  coupon_amount decimal(20,2) NOT NULL default '0.00',
  coupon_type tinyint UNSIGNED NOT NULL default '0',
  discount_amount text NULL,
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_coupons_pending (
  id int UNSIGNED NOT NULL auto_increment,
  affiliate int UNSIGNED NOT NULL default '0',
  coupon_code varchar(255) character set utf8 NULL DEFAULT NULL,
  stamp bigint UNSIGNED NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_cp_settings (
  cp_theme varchar(255) character set utf8 NULL DEFAULT NULL,
  background varchar(10) character set utf8 NULL DEFAULT NULL,
  header_background varchar(10) character set utf8 NULL DEFAULT NULL,
  heading_text varchar(10) character set utf8 NULL DEFAULT NULL,
  top_menu_background varchar(10) character set utf8 NULL DEFAULT NULL,
  heading_back varchar(10) character set utf8 NULL DEFAULT NULL,
  portlet_1 varchar(10) character set utf8 NULL DEFAULT NULL,
  portlet_2 varchar(10) character set utf8 NULL DEFAULT NULL,
  portlet_3 varchar(10) character set utf8 NULL DEFAULT NULL,
  portlet_4 varchar(10) character set utf8 NULL DEFAULT NULL,
  portlet_5 varchar(10) character set utf8 NULL DEFAULT NULL,
  portlet_6 varchar(10) character set utf8 NULL DEFAULT NULL,
  portlet_text_1 varchar(10) character set utf8 NULL DEFAULT NULL,
  portlet_text_2 varchar(10) character set utf8 NULL DEFAULT NULL,
  portlet_text_3 varchar(10) character set utf8 NULL DEFAULT NULL,
  portlet_text_4 varchar(10) character set utf8 NULL DEFAULT NULL,
  portlet_text_5 varchar(10) character set utf8 NULL DEFAULT NULL,
  portlet_text_6 varchar(10) character set utf8 NULL DEFAULT NULL,
  box_tt_back varchar(10) character set utf8 NULL DEFAULT NULL,
  box_tt_text varchar(10) character set utf8 NULL DEFAULT NULL,
  box_ce_back varchar(10) character set utf8 NULL DEFAULT NULL,
  box_ce_text varchar(10) character set utf8 NULL DEFAULT NULL,
  box_te_back varchar(10) character set utf8 NULL DEFAULT NULL,
  box_te_text varchar(10) character set utf8 NULL DEFAULT NULL,
  box_uv_back varchar(10) character set utf8 NULL DEFAULT NULL,
  box_uv_text varchar(10) character set utf8 NULL DEFAULT NULL,
  bar_comms_last_6 tinyint UNSIGNED NOT NULL default '0',
  pie_top_5_month tinyint UNSIGNED NOT NULL default '0',
  cp_page_width tinyint UNSIGNED NOT NULL default '0',
  cp_menu_location tinyint UNSIGNED NOT NULL default '0',
  cp_fixed_navbar tinyint UNSIGNED NOT NULL default '0',
  cp_fixed_left_menu tinyint UNSIGNED NOT NULL default '0',
  top_menu_text varchar(10) character set utf8 NULL DEFAULT NULL,
  cp_main_menu_color varchar(10) character set utf8 NULL DEFAULT NULL,
  cp_main_menu_text varchar(10) character set utf8 NULL DEFAULT NULL,
  logo_footer tinyint UNSIGNED NOT NULL default '0',
  details_show tinyint UNSIGNED NOT NULL default '0',
  details_show_type tinyint UNSIGNED NOT NULL default '0',
  details_show_signup tinyint UNSIGNED NOT NULL default '0',
  details_show_requirements tinyint UNSIGNED NOT NULL default '0',
  details_show_duration tinyint UNSIGNED NOT NULL default '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_currency (
  id int UNSIGNED NOT NULL auto_increment,
  currency_code varchar(10) character set utf8 NULL DEFAULT NULL,
  currency_symbol varchar(10) character set utf8 NULL DEFAULT NULL,
  currency_rate decimal(10,8) NOT NULL default '0.00',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_custom_links (
  id int UNSIGNED NOT NULL auto_increment,
  aff_id int UNSIGNED NOT NULL default '0',
  url varchar(500) character set utf8 NULL DEFAULT NULL,
  display tinyint UNSIGNED NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_custom_vars (
  custom_var_1 varchar(255) character set utf8 NULL DEFAULT NULL,
  custom_var_2 varchar(255) character set utf8 NULL DEFAULT NULL,
  custom_var_3 varchar(255) character set utf8 NULL DEFAULT NULL,
  custom_var_4 varchar(255) character set utf8 NULL DEFAULT NULL,
  custom_var_5 varchar(255) character set utf8 NULL DEFAULT NULL,
  google_utm_source_value varchar(255) character set utf8 NULL DEFAULT NULL,
  google_utm_medium_value varchar(255) character set utf8 NULL DEFAULT NULL,
  google_utm_campaign_value varchar(255) character set utf8 NULL DEFAULT NULL,
  geo varchar(255) character set utf8 NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_debit (
  id int UNSIGNED NOT NULL AUTO_INCREMENT,
  aff_id int UNSIGNED NOT NULL default '0',
  amount decimal(20,2) NOT NULL default '0.00',
  code bigint UNSIGNED NOT NULL default '0',
  reason tinyint UNSIGNED NOT NULL default '0',
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_debit_archive (
  id int UNSIGNED NOT NULL AUTO_INCREMENT,
  aff_id int UNSIGNED NOT NULL default '0',
  amount decimal(20,2) NOT NULL default '0.00',
  code bigint UNSIGNED NOT NULL default '0',
  reason tinyint UNSIGNED NOT NULL default '0',
  payment_record int UNSIGNED NOT NULL default '0',
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_delayed (
  enabled tinyint UNSIGNED NOT NULL default '0',
  days int UNSIGNED NOT NULL default '0',
  action tinyint UNSIGNED NOT NULL default '0',
  KEY enabled (enabled)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

// idevaff_deleted_accounts is at bottom

// idevaff_deleted_sales is at bottom

$db->query("CREATE TABLE IF NOT EXISTS idevaff_email_attachments (
  template_id int UNSIGNED NOT NULL default '0',
  filename varchar(255) character set utf8 NULL DEFAULT NULL,
  size int UNSIGNED NOT NULL default '0',
  enabled tinyint UNSIGNED NOT NULL default '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_email_language_packs (
  id int UNSIGNED NOT NULL auto_increment,
  name varchar(20) character set utf8 NULL DEFAULT NULL,
  status tinyint UNSIGNED NOT NULL default '0',
  def tinyint UNSIGNED NOT NULL default '0',
  table_name varchar(64) character set utf8 NULL DEFAULT NULL,
  user_created tinyint UNSIGNED NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_email_settings (
  address varchar(128) character set utf8 NULL DEFAULT NULL,
  alternate_email_address varchar(128) character set utf8 NULL DEFAULT NULL,
  from_name varchar(64) character set utf8 NULL DEFAULT NULL,
  signature text NULL,
  transport tinyint UNSIGNED NOT NULL default '0',
  smtp_port int UNSIGNED NOT NULL default '0',
  smtp_host varchar(64) character set utf8 NULL DEFAULT NULL,
  smtp_auth varchar(10) character set utf8 NULL DEFAULT NULL,
  smtp_user varchar(64) character set utf8 NULL DEFAULT NULL,
  smtp_pass blob NULL,
  smtp_char_set varchar(25) character set utf8 NULL DEFAULT NULL,
  smtp_security varchar(25) character set utf8 NULL DEFAULT NULL,
  delivery_type tinyint UNSIGNED NOT NULL default '0',
  cc_email_address varchar(128) character set utf8 NULL DEFAULT NULL,
  api_email_address varchar(128) character set utf8 NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_email_templates (
  id int UNSIGNED NOT NULL auto_increment,
  name varchar(128) character set utf8 NULL DEFAULT NULL,
  grp int UNSIGNED NOT NULL default '0',
  content longtext NULL,
  hits int UNSIGNED NOT NULL default '0',
  conv int UNSIGNED NOT NULL default '0',
  sort int NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_facebook (
  enabled tinyint UNSIGNED NOT NULL default '0',
  id varchar(64) character set utf8 NULL DEFAULT NULL,
  secret varchar(64) character set utf8 NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_faq (
  id int UNSIGNED NOT NULL auto_increment,
  question text NULL,
  answer text NULL,
  sort int NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_form_custom_data (
  id int UNSIGNED NOT NULL auto_increment,
  affid int UNSIGNED NOT NULL default '0',
  custom_id int UNSIGNED NOT NULL default '0',
  custom_value varchar(255) character set utf8 NULL DEFAULT NULL,
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_form_fields (
  id int UNSIGNED NOT NULL auto_increment,
  used tinyint UNSIGNED NOT NULL default '0',
  req tinyint UNSIGNED NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_form_fields_custom (
  id int UNSIGNED NOT NULL auto_increment,
  name varchar(64) character set utf8 NULL DEFAULT NULL,
  title varchar(128) character set utf8 NULL DEFAULT NULL,
  def_value varchar(128) character set utf8 NULL DEFAULT NULL,
  req tinyint UNSIGNED NOT NULL default '0',
  sort int NOT NULL default '0',
  display_payment tinyint UNSIGNED NOT NULL default '0',
  display_invoice tinyint UNSIGNED NOT NULL default '0',
  display_record tinyint UNSIGNED NOT NULL default '0',
  edit tinyint UNSIGNED NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_general_sales (
  id int UNSIGNED NOT NULL auto_increment,
  time_stamp bigint UNSIGNED NOT NULL default '0',
  order_number varchar(64) character set utf8 NULL DEFAULT NULL,
  sale_amount decimal(20,2) NOT NULL default '0.00',
  customer_ip varchar(64) character set utf8 NULL DEFAULT NULL,
  currency varchar(10) character set utf8 NULL DEFAULT NULL,
  converted_amount decimal(20,2) NOT NULL default '0.00',
  geo varchar(2) character set utf8 NULL DEFAULT NULL,
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_groups (
  id int UNSIGNED NOT NULL auto_increment,
  name varchar(128) character set utf8 NULL DEFAULT NULL,
  contains int UNSIGNED NOT NULL default '0',
  ads int UNSIGNED NOT NULL default '0',
  links int UNSIGNED NOT NULL default '0',
  hads int UNSIGNED NOT NULL default '0',
  location varchar(255) character set utf8 NULL DEFAULT NULL,
  etemps int UNSIGNED NOT NULL default '0',
  peels int UNSIGNED NOT NULL default '0',
  lightboxes int UNSIGNED NOT NULL default '0',
  qr_enabled tinyint UNSIGNED NOT NULL default '0',
  vids int UNSIGNED NOT NULL default '0',
  announcements int UNSIGNED NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_groups_exclude (
  id int UNSIGNED NOT NULL default '0',
  affiliate_id int UNSIGNED NOT NULL default '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_htmlads (
  id int UNSIGNED NOT NULL auto_increment,
  name varchar(128) character set utf8 NULL DEFAULT NULL,
  grp int UNSIGNED NOT NULL default '0',
  html_code text NULL,
  hits int UNSIGNED NOT NULL default '0',
  conv int UNSIGNED NOT NULL default '0',
  sort int NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_integration (
  type int UNSIGNED NOT NULL default '0',
  auto tinyint UNSIGNED NOT NULL default '0',
  manual tinyint UNSIGNED NOT NULL default '0',
  idev_vartotal varchar(64) character set utf8 NULL DEFAULT NULL,
  idev_order varchar(64) character set utf8 NULL DEFAULT NULL,
  idev_var1 varchar(64) character set utf8 NULL DEFAULT NULL,
  cart_var1 varchar(64) character set utf8 NULL DEFAULT NULL,
  use_var1 tinyint UNSIGNED NOT NULL default '0',
  tag_var1 varchar(64) character set utf8 NULL DEFAULT NULL,
  idev_var2 varchar(64) character set utf8 NULL DEFAULT NULL,
  cart_var2 varchar(64) character set utf8 NULL DEFAULT NULL,
  use_var2 tinyint UNSIGNED NOT NULL default '0',
  tag_var2 varchar(64) character set utf8 NULL DEFAULT NULL,
  idev_var3 varchar(64) character set utf8 NULL DEFAULT NULL,
  cart_var3 varchar(64) character set utf8 NULL DEFAULT NULL,
  use_var3 tinyint UNSIGNED NOT NULL default '0',
  tag_var3 varchar(64) character set utf8 NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_invoice (
  company varchar(255) character set utf8 NULL DEFAULT NULL,
  ad1 varchar(100) character set utf8 NULL DEFAULT NULL,
  ad2 varchar(50) character set utf8 NULL DEFAULT NULL,
  city varchar(100) character set utf8 NULL DEFAULT NULL,
  state varchar(50) character set utf8 NULL DEFAULT NULL,
  zip varchar(20) character set utf8 NULL DEFAULT NULL,
  country varchar(3) character set utf8 NULL DEFAULT NULL,
  note varchar(255) character set utf8 NULL DEFAULT NULL,
  aff_inv tinyint UNSIGNED NOT NULL default '0',
  include_invoice_number tinyint UNSIGNED NOT NULL default '0',
  invoice_prefix varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_ipblock (
  id int UNSIGNED NOT NULL auto_increment,
  blocked_ip varchar(64) character set utf8 NULL DEFAULT NULL,
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_iptracking (
  id int UNSIGNED NOT NULL auto_increment,
  acct_id int UNSIGNED NOT NULL default '0',
  ip varchar(64) character set utf8 NULL DEFAULT NULL,
  refer varchar(500) character set utf8 NULL DEFAULT NULL,
  stamp bigint UNSIGNED NOT NULL default '0',
  hit_time varchar(128) character set utf8 NULL DEFAULT NULL,
  hit_date varchar(128) character set utf8 NULL DEFAULT NULL,
  src1 int UNSIGNED NOT NULL default '0',
  src2 int UNSIGNED NOT NULL default '0',
  split varchar(128) character set utf8 NULL DEFAULT NULL,
  sub_id varchar(64) character set utf8 NULL DEFAULT NULL,
  tid1 varchar(64) character set utf8 NULL DEFAULT NULL,
  tid2 varchar(64) character set utf8 NULL DEFAULT NULL,
  tid3 varchar(64) character set utf8 NULL DEFAULT NULL,
  tid4 varchar(64) character set utf8 NULL DEFAULT NULL,
  target_url varchar(500) character set utf8 NULL DEFAULT NULL,
  geo varchar(2) character set utf8 NULL DEFAULT NULL,
  PRIMARY KEY  (id),
  KEY acct_id_ip (acct_id,ip),
  KEY ip (ip),
  KEY stamp (stamp),
  KEY acct_id (acct_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_language_custom (
  id int UNSIGNED NOT NULL auto_increment,
  name text NULL,
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_language_packs (
  id int UNSIGNED NOT NULL auto_increment,
  name varchar(255) character set utf8 NULL DEFAULT NULL,
  status tinyint UNSIGNED NOT NULL default '0',
  def tinyint UNSIGNED NOT NULL default '0',
  table_name varchar(255) character set utf8 NULL DEFAULT NULL,
  user_created tinyint UNSIGNED NOT NULL default '0',
  direction int UNSIGNED NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("insert into idevaff_language_packs (name, status, def, table_name, user_created, direction) VALUES 
	('arabic', 8, 0, 'arabic', 0, 1),
	('chinese', 8, 0, 'chinese', 0, 0),
	('czech', 8, 0, 'czech', 0, 0),
	('danish', 8, 0, 'danish', 0, 0),
	('dutch', 8, 0, 'dutch', 0, 0),
	('english', 1, 1, 'english', 0, 0),
	('farsi', 8, 0, 'farsi', 0, 1),
	('finnish', 8, 0, 'finnish', 0, 0),
	('french', 8, 0, 'french', 0, 0),
	('german', 8, 0, 'german', 0, 0),
	('greek', 8, 0, 'greek', 0, 0),
	('hebrew', 8, 0, 'hebrew', 0, 1),
	('hungarian', 8, 0, 'hungarian', 0, 0),
	('indonesian', 8, 0, 'indonesian', 0, 0),
	('italian', 8, 0, 'italian', 0, 0),
	('japanese', 8, 0, 'japanese', 0, 0),
	('korean', 8, 0, 'korean', 0, 0),
	('mandarin chinese', 8, 0, 'mandarin_chinese', 0, 0),
	('norwegian', 8, 0, 'norwegian', 0, 0),
	('polish', 8, 0, 'polish', 0, 0),
	('portuguese', 8, 0, 'portuguese', 0, 0),
	('romanian', 8, 0, 'romanian', 0, 0),
	('russian', 8, 0, 'russian', 0, 0),
	('spanish', 8, 0, 'spanish', 0, 0),
	('swedish', 8, 0, 'swedish', 0, 0),
	('thai', 8, 0, 'thai', 0, 0),
	('turkish', 8, 0, 'turkish', 0, 0),
	('ukrainian', 8, 0, 'ukrainian', 0, 0),
	('vietnamese', 8, 0, 'vietnamese', 0, 0)
	");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_lightboxes (
  number int UNSIGNED NOT NULL auto_increment,
  grp int UNSIGNED NOT NULL default '0',
  name varchar(64) character set utf8 NULL DEFAULT NULL,
  image75 varchar(64) character set utf8 NULL DEFAULT NULL,
  image500 varchar(64) character set utf8 NULL DEFAULT NULL,
  description text NULL,
  hits int UNSIGNED NOT NULL default '0',
  conv int UNSIGNED NOT NULL default '0',
  sort int NOT NULL default '0',
  PRIMARY KEY  (number)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_links (
  id int UNSIGNED NOT NULL auto_increment,
  grp int UNSIGNED NOT NULL default '0',
  linktext text NULL,
  hits int UNSIGNED NOT NULL default '0',
  conv int UNSIGNED NOT NULL default '0',
  sort int NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_logos (
  record int UNSIGNED NOT NULL auto_increment,
  id int UNSIGNED NOT NULL default '0',
  approved tinyint UNSIGNED NOT NULL default '0',
  filename varchar(255) character set utf8 NULL DEFAULT NULL,
  PRIMARY KEY  (record)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_logo_settings (
  logo_enabled tinyint UNSIGNED NOT NULL default '0',
  logo_size int UNSIGNED NOT NULL default '0',
  logo_width int UNSIGNED NOT NULL default '0',
  logo_height int UNSIGNED NOT NULL default '0',
  logo_type tinyint UNSIGNED NOT NULL default '0',
  logo_default varchar(255) character set utf8 NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_logs_admin (
  id int UNSIGNED NOT NULL auto_increment,
  username varchar(128) character set utf8 NULL DEFAULT NULL,
  ip_address varchar(64) character set utf8 NULL DEFAULT NULL,
  code bigint UNSIGNED NOT NULL default '0',
  message varchar(255) character set utf8 NULL DEFAULT NULL,
  type int UNSIGNED NOT NULL default '0',
  affiliate int UNSIGNED NOT NULL default '0',
  amount decimal(10,2) NOT NULL default '0.00',
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_newsletter_addons (
  id int UNSIGNED NOT NULL auto_increment,
  meta_key varchar(255) character set utf8 NULL DEFAULT NULL,
  meta_value longtext character set utf8 NULL DEFAULT NULL,
  PRIMARY KEY (id),
  UNIQUE KEY meta_key (meta_key)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_notes (
  id int UNSIGNED NOT NULL auto_increment,
  note_to int UNSIGNED NOT NULL default '0',
  note_sub text NULL,
  note_con text NULL,
  note_display tinyint UNSIGNED NOT NULL default '0',
  note_attach tinyint UNSIGNED NOT NULL default '0',
  note_date varchar(24) character set utf8 NULL DEFAULT NULL,
  note_image varchar(256) character set utf8 NULL DEFAULT NULL,
  note_image_location tinyint UNSIGNED NOT NULL default '0',
  stamp bigint UNSIGNED NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_paylevels (
  id int UNSIGNED NOT NULL auto_increment,
  type tinyint UNSIGNED NOT NULL default '0',
  level tinyint UNSIGNED NOT NULL default '0',
  amt decimal(10,3) NOT NULL default '0.000',
  amt_alt decimal(10,3) NOT NULL default '0.000',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_payments (
  record int UNSIGNED NOT NULL auto_increment,
  id varchar(64) character set utf8 NULL DEFAULT NULL,
  amount decimal(10,2) NOT NULL default '0.00',
  stamp bigint UNSIGNED NOT NULL default '0',
  export tinyint UNSIGNED NOT NULL default '0',
  code bigint UNSIGNED NOT NULL default '0',
  PRIMARY KEY  (record)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_payment_methods (
  id int UNSIGNED NOT NULL AUTO_INCREMENT,
  name varchar(255) character set utf8 NULL DEFAULT NULL,
  enabled tinyint UNSIGNED NOT NULL default '0',
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_pdf (
  id int UNSIGNED NOT NULL auto_increment,
  filename text NULL,
  pdf_type tinyint UNSIGNED NOT NULL default '0',
  size int UNSIGNED NOT NULL default '0',
  pdf_desc text NULL,
  sort int NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_peels (
  number int UNSIGNED NOT NULL auto_increment,
  grp int UNSIGNED NOT NULL default '0',
  name varchar(64) character set utf8 NULL DEFAULT NULL,
  image75 varchar(64) character set utf8 NULL DEFAULT NULL,
  image500 varchar(64) character set utf8 NULL DEFAULT NULL,
  description text NULL,
  hits int UNSIGNED NOT NULL default '0',
  conv int UNSIGNED NOT NULL default '0',
  sort int NOT NULL default '0',
  PRIMARY KEY  (number)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_pp_transactions (
  id int UNSIGNED NOT NULL auto_increment,
  aff_id int UNSIGNED NOT NULL default '0',
  order_num varchar(50) character set utf8 NULL DEFAULT NULL,
  rec tinyint UNSIGNED NOT NULL default '0',
  amt decimal(10,2) NOT NULL default '0.00',
  op1 varchar(64) character set utf8 NULL DEFAULT NULL,
  op2 varchar(64) character set utf8 NULL DEFAULT NULL,
  op3 varchar(64) character set utf8 NULL DEFAULT NULL,
  code bigint UNSIGNED NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_private (
  id int UNSIGNED NOT NULL auto_increment,
  type tinyint UNSIGNED NOT NULL default '0',
  code varchar(64) character set utf8 NULL DEFAULT NULL,
  expires bigint UNSIGNED NOT NULL default '0',
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_products (
  id int UNSIGNED NOT NULL auto_increment,
  enabled tinyint UNSIGNED NOT NULL default '0',
  product_id varchar(255) character set utf8 NULL DEFAULT NULL,
  product_amount decimal(10,2) NOT NULL default '0.00',
  product_commission decimal(10,2) NOT NULL default '0.00',
  product_type tinyint UNSIGNED NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_promo (
  id int UNSIGNED NOT NULL auto_increment,
  start_date bigint UNSIGNED NOT NULL default '0',
  end_date bigint UNSIGNED NOT NULL default '0',
  amount decimal(10,2) NOT NULL default '0.00',
  enabled tinyint UNSIGNED NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_qsg (
  step_1 tinyint UNSIGNED NOT NULL default '0',
  step_2 tinyint UNSIGNED NOT NULL default '0',
  step_3 tinyint UNSIGNED NOT NULL default '0',
  step_4 tinyint UNSIGNED NOT NULL default '0',
  step_5 tinyint UNSIGNED NOT NULL default '0',
  step_6 tinyint UNSIGNED NOT NULL default '0',
  step_7 tinyint UNSIGNED NOT NULL default '0',
  step_8 tinyint UNSIGNED NOT NULL default '0',
  step_9 tinyint UNSIGNED NOT NULL default '0',
  step_10 tinyint UNSIGNED NOT NULL default '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_rewards (
  rewards tinyint UNSIGNED NOT NULL default '0',
  rew_1 int UNSIGNED NOT NULL default '0',
  rew_2 tinyint UNSIGNED NOT NULL default '0',
  rew_app tinyint UNSIGNED NOT NULL default '0',
  rew_ceiling_pps_perc tinyint UNSIGNED NOT NULL default '0',
  rew_ceiling_pps_flat tinyint UNSIGNED NOT NULL default '0',
  rew_ceiling_ppc tinyint UNSIGNED NOT NULL default '0'  
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_sales (
  record int UNSIGNED NOT NULL auto_increment,
  id int UNSIGNED NOT NULL default '0',
  payment decimal(20,2) NOT NULL default '0.00',
  top_tier_tag tinyint UNSIGNED NOT NULL default '0',
  bonus tinyint UNSIGNED NOT NULL default '0',
  approved tinyint UNSIGNED NOT NULL default '0',
  ip varchar(64) character set utf8 NULL DEFAULT NULL,
  code bigint UNSIGNED NOT NULL default '0',
  tracking varchar(64) character set utf8 NULL DEFAULT NULL,
  tier_id int UNSIGNED NOT NULL default '0',
  rec_id int UNSIGNED NOT NULL default '0',
  op1 varchar(64) character set utf8 NULL DEFAULT NULL,
  op2 varchar(64) character set utf8 NULL DEFAULT NULL,
  op3 varchar(64) character set utf8 NULL DEFAULT NULL,
  amount decimal(20,2) NOT NULL default '0.00',
  type tinyint UNSIGNED NOT NULL default '0',
  split varchar(128) character set utf8 NULL DEFAULT NULL,
  profile int UNSIGNED NOT NULL default '0',
  delay int UNSIGNED NOT NULL default '0',
  referring_url varchar(500) character set utf8 NULL DEFAULT NULL,
  adm_alert tinyint UNSIGNED NOT NULL default '0',
  aff_alert tinyint UNSIGNED NOT NULL default '0',
  sub_id varchar(64) character set utf8 NULL DEFAULT NULL,
  tid1 varchar(255) character set utf8 NULL DEFAULT NULL,
  tid2 varchar(255) character set utf8 NULL DEFAULT NULL,
  tid3 varchar(255) character set utf8 NULL DEFAULT NULL,
  tid4 varchar(255) character set utf8 NULL DEFAULT NULL,
  target_url varchar(500) character set utf8 NULL DEFAULT NULL,
  currency varchar(10) character set utf8 NULL DEFAULT NULL,
  converted_amount decimal(20,2) NOT NULL default '0.00',
  override tinyint UNSIGNED NOT NULL default '0',
  override_id int UNSIGNED NOT NULL default '0',
  geo varchar(2) character set utf8 NULL DEFAULT NULL,
  tracking_method varchar(255) character set utf8 NULL DEFAULT NULL,
  conversion_time bigint UNSIGNED NOT NULL default '0',
  notes mediumtext NULL,
  alt_amt tinyint UNSIGNED NOT NULL default '0',
  sliding_scale int UNSIGNED NOT NULL default '0',
  sliding_alternate int UNSIGNED NOT NULL default '0',
  per_product int UNSIGNED NOT NULL default '0',
  PRIMARY KEY  (record),
  KEY bonus_approved (bonus,approved)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_sessions (
  id char(128) character set utf8 NULL DEFAULT NULL,
  set_time char(10) character set utf8 NULL DEFAULT NULL,
  data text NULL,
  session_key char(128) character set utf8 NULL DEFAULT NULL,
  user_id varchar(255) character set utf8 NULL DEFAULT NULL,
  UNIQUE KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_social (
  id int UNSIGNED NOT NULL auto_increment,
  name varchar(255) character set utf8 NULL DEFAULT NULL,
  enabled tinyint UNSIGNED NOT NULL default '0',
  link varchar(2000) character set utf8 NULL DEFAULT NULL,
  image varchar(255) character set utf8 NULL DEFAULT NULL,
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_suspensions (
  id int UNSIGNED NOT NULL auto_increment,
  affid int UNSIGNED NOT NULL default '0',
  notice mediumtext NULL,
  alt_delivery tinyint UNSIGNED NOT NULL default '0',
  susp_allow_comm int UNSIGNED NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_tc_log (
  update_record int UNSIGNED NOT NULL default '0',
  aff_id int UNSIGNED NOT NULL default '0',
  stamp bigint UNSIGNED NOT NULL default '0',
  KEY update_record (update_record)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_tc_updates (
  record int UNSIGNED NOT NULL auto_increment,
  stamp bigint UNSIGNED NOT NULL default '0',
  terms mediumtext NULL,
  PRIMARY KEY (record)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_terms (
  display tinyint UNSIGNED NOT NULL default '0',
  forced tinyint UNSIGNED NOT NULL default '0',
  re_forced tinyint UNSIGNED NOT NULL default '0',
  terms text NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_testimonials (
  id int UNSIGNED NOT NULL auto_increment,
  aff_id int UNSIGNED NOT NULL default '0',
  affiliate_name varchar(128) character set utf8 NULL DEFAULT NULL,
  website_url varchar(255) character set utf8 NULL DEFAULT NULL,
  testimonial text NULL,
  approved tinyint UNSIGNED NOT NULL,
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_tiers (
  id int UNSIGNED NOT NULL auto_increment,
  parent int UNSIGNED NOT NULL default '0',
  child int UNSIGNED NOT NULL default '0',
  PRIMARY KEY  (id),
  UNIQUE KEY parent (parent,child)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_tier_settings (
  level_1_amount decimal(10,2) NOT NULL default '0.00',
  level_1_type tinyint UNSIGNED NOT NULL default '0',
  level_2_amount decimal(10,2) NOT NULL default '0.00',
  level_2_type tinyint UNSIGNED NOT NULL default '0',
  level_3_amount decimal(10,2) NOT NULL default '0.00',
  level_3_type tinyint UNSIGNED NOT NULL default '0',
  level_4_amount decimal(10,2) NOT NULL default '0.00',
  level_4_type tinyint UNSIGNED NOT NULL default '0',
  level_5_amount decimal(10,2) NOT NULL default '0.00',
  level_5_type tinyint UNSIGNED NOT NULL default '0',
  level_6_amount decimal(10,2) NOT NULL default '0.00',
  level_6_type tinyint UNSIGNED NOT NULL default '0',
  level_7_amount decimal(10,2) NOT NULL default '0.00',
  level_7_type tinyint UNSIGNED NOT NULL default '0',
  level_8_amount decimal(10,2) NOT NULL default '0.00',
  level_8_type tinyint UNSIGNED NOT NULL default '0',
  level_9_amount decimal(10,2) NOT NULL default '0.00',
  level_9_type tinyint UNSIGNED NOT NULL default '0',
  level_10_amount decimal(10,2) NOT NULL default '0.00',
  level_10_type tinyint UNSIGNED NOT NULL default '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_tlog (
  id int UNSIGNED NOT NULL auto_increment,
  ta int UNSIGNED NOT NULL default '0',
  ti varchar(64) character set utf8 NULL DEFAULT NULL,
  PRIMARY KEY  (id),
  KEY ta_ti (ta,ti)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_tokens (
  panel_language varchar(64) NOT NULL,
  affiliate_login varchar(64) NOT NULL,
  affiliate_creds varchar(64) NOT NULL,
  affiliate_private varchar(64) NOT NULL,
  KEY panel_language (panel_language),
  KEY affiliate_login (affiliate_login),
  KEY affiliate_creds (affiliate_creds),
  KEY affiliate_private (affiliate_private)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_allowed_tracking_domains (
    id bigint UNSIGNED NOT NULL,
    domain varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_vat (
  id int UNSIGNED NOT NULL auto_increment,
  country varchar(3) character set utf8 NULL DEFAULT NULL,
  rate decimal(10,2) NOT NULL default '0.00',
  admin_invoice tinyint UNSIGNED NOT NULL default '0',
  affiliate_invoice tinyint UNSIGNED NOT NULL default '0',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_videos (
  record int UNSIGNED NOT NULL AUTO_INCREMENT,
  grp int UNSIGNED NOT NULL default '0',
  video_type varchar(10) character set utf8 NULL DEFAULT NULL,
  video varchar(255) character set utf8 NULL DEFAULT NULL,
  logo varchar(255) character set utf8 NULL DEFAULT NULL,
  logo_location varchar(20) character set utf8 NULL DEFAULT NULL,
  splash varchar(255) character set utf8 NULL DEFAULT NULL,
  effect varchar(20) character set utf8 NULL DEFAULT NULL,
  video_finish varchar(20) character set utf8 NULL DEFAULT NULL,
  preroll_show varchar(5) character set utf8 NULL DEFAULT NULL,
  preroll_skip varchar(5) character set utf8 NULL DEFAULT NULL,
  preroll_seconds int NOT NULL default '0',
  preroll_mp4 varchar(255) character set utf8 NULL DEFAULT NULL,
  preroll_thumb varchar(255) character set utf8 NULL DEFAULT NULL,
  responsive varchar(5) character set utf8 NULL DEFAULT NULL,
  fixed_width varchar(10) character set utf8 NULL DEFAULT NULL,
  fixed_height varchar(10) character set utf8 NULL DEFAULT NULL,
  auto_play varchar(5) character set utf8 NULL DEFAULT NULL,
  video_title mediumtext NULL,
  video_desc mediumtext NULL,
  sort int NOT NULL default '0',
  PRIMARY KEY (record)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_video_cats (
  id int unsigned NOT NULL DEFAULT '0',
  name varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_video_library (
  id int UNSIGNED NOT NULL auto_increment,
  video_name varchar(64) character set utf8 NULL DEFAULT NULL,
  video_size varchar(64) character set utf8 NULL DEFAULT NULL,
  video_cat int UNSIGNED NOT NULL default '0',
  video_location varchar(255) character set utf8 NULL DEFAULT NULL,
  video_enabled tinyint UNSIGNED NOT NULL default '1',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_video_options (
  id int UNSIGNED NOT NULL auto_increment,
  name varchar(255) character set utf8 NULL DEFAULT NULL,
  description text NULL,
  price_initial decimal(10,2) NOT NULL default '0.00',
  days_initial int UNSIGNED NOT NULL default '0',
  duration_initial varchar(1) character set utf8 NULL DEFAULT NULL,
  price_recurring decimal(10,2) NOT NULL default '0.00',
  days_recurring int UNSIGNED NOT NULL default '0',
  duration_recurring varchar(1) character set utf8 NULL DEFAULT NULL,
  days int UNSIGNED NOT NULL default '0',
  discount_percent decimal(10,2) NOT NULL default '0.00',
  discount_flat decimal(10,2) NOT NULL default '0.00',
  PRIMARY KEY  (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_video_settings (
  paypal varchar(255) character set utf8 NULL DEFAULT NULL,
  stamp blob NOT NULL,
  enabled tinyint UNSIGNED NOT NULL default '0',
  sidebar tinyint UNSIGNED NOT NULL default '0',
  retro varchar(10) character set utf8 NULL DEFAULT NULL,
  video_logo_url varchar(255) character set utf8 NULL DEFAULT NULL,
  library_version decimal(10,2) NOT NULL default '0.00',
  cloud_location varchar(64) character set utf8 NULL DEFAULT NULL,
  UNIQUE KEY paypal (paypal)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_video_tutorials (
  id int UNSIGNED NOT NULL auto_increment,
  video_location varchar(255) character set utf8 NULL DEFAULT NULL,
  video_title varchar(255) character set utf8 NULL DEFAULT NULL,
  video_length varchar(10) character set utf8 NULL DEFAULT NULL,
  sort int NOT NULL default '0',
  PRIMARY KEY  (id),
  UNIQUE KEY id (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

// ----------------------------------
// TABLE ADDS FOR 9.1
// ----------------------------------
$db->query("CREATE TABLE IF NOT EXISTS idevaff_cloud (
  client_id int UNSIGNED NOT NULL default '0',
  stripe_customer_id text NULL,
  package tinyint UNSIGNED NOT NULL default '0.00',
  subscription_status varchar(255) character set utf8 NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_webhook_log (
  id int UNSIGNED NOT NULL AUTO_INCREMENT,
  response_code varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  request_url varchar(512) CHARACTER SET utf8 DEFAULT NULL,
  event_name varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  code bigint UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_geo_target (
  id int UNSIGNED NOT NULL AUTO_INCREMENT,
  country char(2) CHARACTER SET utf8 DEFAULT NULL,
  location varchar(500) CHARACTER SET utf8 DEFAULT NULL,
  country_name varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_countries_geo (
  country_code text COLLATE utf8_general_ci,
  country_name text COLLATE utf8_general_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_country_coords (
  country_code char(2) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  latitude decimal(14,10) NOT NULL DEFAULT '0.0000000000',
  longitude decimal(14,10) NOT NULL DEFAULT '0.0000000000',
  UNIQUE KEY country_code (country_code)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

// ----------------------------------
// TABLE ADDS FOR 9.2
// ----------------------------------

$db->query("CREATE TABLE IF NOT EXISTS idevaff_ga (
  footer text NULL,
  signup text NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_paylevels_sliding (
  id int UNSIGNED NOT NULL AUTO_INCREMENT,
  type int UNSIGNED NOT NULL DEFAULT '0',
  paylevel int UNSIGNED NOT NULL DEFAULT '0',
  slidinglevel int UNSIGNED NOT NULL DEFAULT '0',
  min_amount decimal(10,3) NOT NULL DEFAULT '0.000',
  max_amount decimal(10,3) NOT NULL DEFAULT '0.000',
  amt decimal(10,3) NOT NULL DEFAULT '0.000',
  amt_alt decimal(10,3) NOT NULL DEFAULT '0.000',
  UNIQUE KEY id (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_privacy (
  privacy_enabled int UNSIGNED NOT NULL DEFAULT '0',
  privacy_signup int UNSIGNED NOT NULL DEFAULT '0',
  privacy_required int UNSIGNED NOT NULL DEFAULT '0',
  policy text NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_aff_lockout (
  id int UNSIGNED NOT NULL auto_increment,
  ip varchar(64) character set utf8 NULL DEFAULT NULL,
  attempts tinyint UNSIGNED NOT NULL DEFAULT '0',
  code bigint UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_sessions_aff (
  id char(128) character set utf8 NULL DEFAULT NULL,
  set_time char(10) character set utf8 NULL DEFAULT NULL,
  data text NULL,
  session_key char(128) character set utf8 NULL DEFAULT NULL,
  user_id int UNSIGNED DEFAULT NULL,
  UNIQUE KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

// ----------------------------------
// TABLE ADDS FOR 9.3
// ----------------------------------
$db->query("CREATE TABLE IF NOT EXISTS idevaff_geo_stats (
  id int UNSIGNED NOT NULL AUTO_INCREMENT,
  country_code varchar(15) character set utf8 NULL DEFAULT NULL,
  visitor_count bigint UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (id),
  INDEX country_code (country_code)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_monthly_traffic_activity (
  ID int UNSIGNED NOT NULL AUTO_INCREMENT,
  account_ID int UNSIGNED NOT NULL DEFAULT '0',
  ip_address varchar(45) character set utf8 NULL DEFAULT NULL,
  created_at timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (ID),
  KEY ip_address (ip_address)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;");
$tabnum = $tabnum + 1;

// THESE ARE OUT OF ORDER BECAUSE THEY ARE A COPY
// ----------------------------------------------
$db->query("CREATE TABLE IF NOT EXISTS idevaff_deleted_accounts LIKE idevaff_affiliates");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_deleted_sales LIKE idevaff_sales");
$tabnum = $tabnum + 1;

// create language phrases table
$db->query("CREATE TABLE IF NOT EXISTS `idevaff_email_lang_phrases` (
  `id` int NOT NULL AUTO_INCREMENT,
  `lang_id` int NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` longtext NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;");
$tabnum = $tabnum + 1;

// Create Facebook Tokens table.
$db->query("CREATE TABLE IF NOT EXISTS `idevaff_facebook_tokens` (
  `id` int NOT NULL AUTO_INCREMENT,
  `aff_id` int NOT NULL DEFAULT '0',
  `access_token` text,
  `page_token` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

// Create Facebook Tokens table.
$db->query("CREATE TABLE IF NOT EXISTS `idevaff_linkedin_tokens` (
  `id` int NOT NULL AUTO_INCREMENT,
  `aff_id` int NOT NULL DEFAULT '0',
  `access_token` text CHARACTER SET utf8,
  `person_id` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;");
$tabnum = $tabnum + 1;

// Create Social media Settings table.
$db->query("CREATE TABLE IF NOT EXISTS `idevaff_social_media_settings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `channel` varchar(30) CHARACTER SET utf8 DEFAULT NULL,
  `client_id` varchar(64) CHARACTER SET utf8 DEFAULT NULL,
  `client_secret` varchar(64) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_general_leads (
  id int UNSIGNED NOT NULL auto_increment,
  profile int UNSIGNED DEFAULT '0',
  acct_id int UNSIGNED NOT NULL DEFAULT '0',
  ip_address varchar(255) DEFAULT NULL,
  time_stamp bigint UNSIGNED NOT NULL DEFAULT '0',
  geo varchar(2) DEFAULT NULL,
  lead_id varchar(250) DEFAULT NULL,
  lead_value varchar(250) DEFAULT NULL,
  customer_name varchar(250) DEFAULT NULL,
  customer_email varchar(250) DEFAULT NULL,
  opt1 varchar(250) DEFAULT NULL,
  opt2 varchar(250) DEFAULT NULL,
  opt3 varchar(250) DEFAULT NULL,
  opt4 varchar(250) DEFAULT NULL,
  tracking_method varchar(255) DEFAULT NULL,
  conversion_time bigint DEFAULT '0',
  target_url varchar(500) DEFAULT NULL,
  referring_url varchar(500) DEFAULT NULL,
  notes text,
  PRIMARY KEY (id),
  KEY (acct_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_general_leads_integrations (
  id int UNSIGNED NOT NULL auto_increment,
  name varchar(255) DEFAULT NULL,
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_general_leads_settings (
  lead_sec_key tinyint NOT NULL DEFAULT '0',
  lead_ip_blocks tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (lead_sec_key)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("INSERT INTO idevaff_general_leads_settings (lead_sec_key, lead_ip_blocks) VALUES(0, 1)");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_products_excluded (
  id int UNSIGNED NOT NULL auto_increment,
  product_id varchar(255) character set utf8 NULL DEFAULT NULL,
  PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_product_feed (
  id int UNSIGNED NOT NULL DEFAULT '0',
  sku varchar(100) character set utf8 NULL DEFAULT NULL,
  name varchar(400) character set utf8 NULL DEFAULT NULL,
  url varchar(400) character set utf8 NULL DEFAULT NULL,
  image varchar(400) character set utf8 NULL DEFAULT NULL,
  price varchar(50) character set utf8 NULL DEFAULT NULL,
  description text NULL,
  UNIQUE KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("CREATE TABLE IF NOT EXISTS idevaff_product_feed_settings (
  feed_sort tinyint NOT NULL DEFAULT 1,
  feed_gui tinyint NOT NULL DEFAULT 1,
  feed_csv tinyint NOT NULL DEFAULT 1,
  feed_raw tinyint NOT NULL DEFAULT 1,
  KEY sort (feed_sort)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
$tabnum = $tabnum + 1;

$db->query("INSERT INTO idevaff_product_feed_settings (feed_sort, feed_gui, feed_csv, feed_raw) VALUES(1, 1, 1, 1)");

// ---------------------------------------------------------
// UPDATE LANGUAGE PACKS - ADD
// ---------------------------------------------------------

try {
$db->query("CREATE TABLE IF NOT EXISTS `idevaff_lang_phrases` (
  `id` int NOT NULL AUTO_INCREMENT,
  `lang_id` INT NOT NULL,
  `key` VARCHAR (255) NOT NULL,
  `value` longtext NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
    $tabnum = $tabnum + 1;
	
	$new_install_package = "english";
	include($path . '/includes/languages/english.php');

	/*
    $new_install_package = false;
    if ($handle = opendir($path . "/includes/languages/")) {
        while (false !== ($entry = readdir($handle))) {
            $info = pathinfo($entry);
            if ($entry != "." && $entry != ".." && $info['extension'] == "php") {
                $new_install_package = true;
                include($path . '/includes/languages/' . $entry);
            }
        }
        closedir($handle);
    }
	*/
	
} catch (Exception $e) {
    $ret_ajax['errors'][] = $e->getMessage();
}

?>