<?PHP

$current_memory = ini_get('memory_limit');
$current_memory = preg_replace('/\D/', '', $current_memory);

if ($current_memory < '512') {
    ini_set('memory_limit', '512M');
    $current_memory = ini_get('memory_limit');
    $current_memory = preg_replace('/\D/', '', $current_memory);
}

include_once("../API/debug.php");
include_once("../includes/package.php");

// -------------------------------------------------------
// CHECK TO MAKE SURE PATH SETTING IS CORRECT
// -------------------------------------------------------
include_once("../API/path.php");
$installcheck = true;

// -------------------------------------------------------
// CHECK TO SEE IF THIS SHOULD BE AN UPGRADE INSTEAD
// -------------------------------------------------------
if (!isset($_POST['license'])) { //echo "no license posted";
    if (file_exists($path . '/API/database.php')) {
        include_once("../API/path.php");
        include_once($path . "/API/database.php");
        $query = $db->query("SHOW TABLES LIKE 'idevaff_config'");
        if ($query->rowCount() == 1) {
            header("Location: upgrade.php");
            exit;
        }
    }
}

$version = "9.4";
$ca_version = "1.0.6.05";

function getPlatform()
{
    if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
        $platform = "windows";
    } else {
        $platform = "unix";
    }
    return ($platform);
}

function isWritable($file)
{
    $rtnVal = false;
    $platform = getPlatform();
    if ($platform == 'windows') {
        $dir_separator = "\\";
    }
    if ($platform == 'unix') {
        $dir_separator = '/';
    }
    if (@is_dir($file)) {
        if ($platform == 'windows') {
            $file = preg_replace('/\\\\$/', '', $file) . $dir_separator . md5(uniqid('', true));
        } else {
            $file = preg_replace('/\/\/$/', '', $file) . $dir_separator . md5(uniqid('', true));
        }
        $unlink = true;
    } else {
        $unlink = !file_exists($file);
    }
    if ($fp = @fopen($file, 'ab')) {
        @fclose($fp);
        if ($unlink) {
            @unlink($file);
        }
        $rtnVal = true;
    } else {
        $rtnVal = false;
    }
    return ($rtnVal);
}

$license = false;
function chk(& $var)
{
    if (!isset($var)) {
        return NULL;
    } else {
        return $var;
    }
}

if (isset($_POST['license'])) {
    $license = $_POST['license'];
}
if (isset($_POST['license_method'])) {
    $license_method = $_POST['license_method'];
}

// ------------------------------------------------
// LICENSING START
// ------------------------------------------------

function make_token()
{
    return md5('1b1ddcb4ed069d9565cc6a5a9ecf553e' . time());
}

function phpaudit_exec_curl($array)
{
    $array = @explode("?", $array);

    $link = curl_init();
    curl_setopt($link, CURLOPT_URL, $array[0]);
    curl_setopt($link, CURLOPT_POSTFIELDS, $array[1]);
    curl_setopt($link, CURLOPT_VERBOSE, 0);
    curl_setopt($link, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($link, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($link, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($link, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($link, CURLOPT_MAXREDIRS, 6);
    curl_setopt($link, CURLOPT_CONNECTTIMEOUT, 30);
    curl_setopt($link, CURLOPT_TIMEOUT, 15); // 60
    $results = curl_exec($link);
    if (curl_errno($link) > 0) {
        curl_close($link);
        return false;
    }
    curl_close($link);

    if (@strpos($results, "verify") === false) {
        return false;
    }

    return $results;
}

function phpaudit_exec_socket($http_host, $http_dir, $http_file, $querystring)
{
    $fp = @fsockopen($http_host, 80, $errno, $errstr, 10); // was 5
    if (!$fp) {
        return false;
    } else {
        $header = "POST " . ($http_dir . $http_file) . " HTTP/1.0\r\n";
        $header .= "Host: " . $http_host . "\r\n";
        $header .= "Content-type: application/x-www-form-urlencoded\r\n";
        $header .= "User-Agent: PHPAudit v2 (http://www.phpaudit.com)\r\n";
        $header .= "Content-length: " . @strlen($querystring) . "\r\n";
        $header .= "Connection: close\r\n\r\n";
        $header .= $querystring;

        $data = false;
        if (@function_exists('stream_set_timeout')) {
            stream_set_timeout($fp, 20);
        }
        @fputs($fp, $header);

        if (@function_exists('socket_get_status')) {
            $status = @socket_get_status($fp);
        } else {
            $status = true;
        }

        while (!@feof($fp) && $status) {
            $data .= @fgets($fp, 1024);

            if (@function_exists('socket_get_status')) {
                $status = @socket_get_status($fp);
            } else {
                if (@feof($fp) == true) {
                    $status = false;
                } else {
                    $status = true;
                }
            }
        }

        @fclose($fp);

        // echo "<textarea rows='100' cols='100'>".$data."</textarea>"; die;

        if (!strpos($data, '200')) {
            return false;
        }

        if (!$data) {
            return false;
        }

        $data = @explode("\r\n\r\n", $data, 2);

        if (!$data[1]) {
            return false;
        }
        if (@strpos($data[1], "verify") === false) {
            return false;
        }

        return $data[1];
    }
}

function path_translated()
{
    if (isset($_SERVER['PATH_TRANSLATED'])) {
        return @substr($_SERVER['PATH_TRANSLATED'], 0, @strrpos($_SERVER['PATH_TRANSLATED'], "/"));
    }

    if (isset($_SERVER['SCRIPT_FILENAME'])) {
        $local_path = substr($_SERVER['SCRIPT_FILENAME'], 0, @strrpos($_SERVER['SCRIPT_FILENAME'], "/"));
        if (!$local_path) {
            $local_path = @substr($_SERVER['SCRIPT_FILENAME'], 0, @strrpos($_SERVER['SCRIPT_FILENAME'], "\\"));
        }

        return $local_path;
    }

    return @substr($_SERVER['ORIG_PATH_TRANSLATED'], 0, @strrpos($_SERVER['ORIG_PATH_TRANSLATED'], "\\"));
}

function server_addr()
{
    if (isset($_SERVER['SERVER_ADDR'])) {
        return ($_SERVER['SERVER_ADDR']) ? $_SERVER['SERVER_ADDR'] : $_SERVER['LOCAL_ADDR'];
    } else {
    }
}


if (isset($_POST['license_submit'])) {
    $server = 'https://www.idevstore.com/'; // main server
    $methods = array('phpaudit_exec_socket', 'phpaudit_exec_curl', 'file_get_contents');

    $enable_dns_spoof = 'yes';

    $query_string = "license=" . $_POST['license'];
    $query_string .= "&product_id=" . $prid;
    $query_string .= "&access_directory=" . str_replace('install', 'admin', path_translated());
    $query_string .= "&access_ip=" . server_addr();
    $query_string .= "&access_host=" . $_SERVER['HTTP_HOST'];
    $query_string .= '&access_token=';
    $query_string .= $token = make_token();


    $data = false;
    foreach ($methods as $license_method) {
        $sinfo = @parse_url($server);


        if ($license_method == 'phpaudit_exec_socket' && !$data) {
            $data = @phpaudit_exec_socket($sinfo['host'], $sinfo['path'], '/validate_internal.php', $query_string);
        }


        if ($license_method == 'phpaudit_exec_curl' && !$data) {
            $data = @phpaudit_exec_curl("{$server}/validate_internal.php?{$query_string}");
        }


        if ($license_method == 'file_get_contents' && !$data) {
            $data = @file_get_contents("{$server}validate_internal.php?{$query_string}");
        }

        if ($data) {
            break;
        }
    }

    $parser = @xml_parser_create('');
    @xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
    @xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
    @xml_parse_into_struct($parser, $data, $values, $tags);
    @xml_parser_free($parser);

    $returned = $values[0]['attributes'];
    if (empty($returned)) {
        $returned['status'] = "invalid";
    }

    if ($returned['status'] != "active" && $returned['status'] != "reissued") {
        unset($_POST);
        $fail_message = false;
        if ($returned['status'] == "suspended") {
            $fail_message = '<strong>Error!</strong> This license has been suspended.';
        } else if ($returned['status'] == "pending") {
            $fail_message = '<strong>Error!</strong> This license is pending approval.';
        } else if ($returned['status'] == "expired") {
            $fail_message = '<strong>Error!</strong> This license is expired.';
        } else if ($returned['status'] == 'active'
            && strcmp(md5('1b1ddcb4ed069d9565cc6a5a9ecf553e' . $token), $returned['access_token']) != 0
            && $enable_dns_spoof == 'yes'
            && !$skip_dns_spoof) {
            $fail_message = '<strong>Error!</strong> This license has an invalid checksum.';
        } else {
            $fail_message = '<strong>Error!</strong> This license appears to be invalid.';
        }
    }

    unset($query_string, $per_server, $per_install, $per_site, $server, $data, $parser, $values, $tags, $sinfo, $token);
}

// ------------------------------------------------
// LICENSING END
// ------------------------------------------------

if (!isset($_POST['step'])) {
    $tr_class_1 = "warning";
    $label_1 = "Working";
    $label_color_1 = "danger";
    $tr_class_2 = null;
    $label_2 = "To Do";
    $label_color_2 = "default";
    $tr_class_3 = null;
    $label_3 = "To Do";
    $label_color_3 = "default";
    $tr_class_4 = null;
    $label_4 = "To Do";
    $label_color_4 = "default";
    $tr_class_5 = null;
    $label_5 = "To Do";
    $label_color_5 = "default";
    $tr_class_6 = null;
    $label_6 = "To Do";
    $label_color_6 = "default";
    $tr_class_7 = null;
    $label_7 = "To Do";
    $label_color_7 = "default";
    $tr_class_8 = null;
    $label_8 = "To Do";
    $label_color_8 = "default";

    $percentage_complete = 0;
    $progress_color = "primary";

} elseif ((isset($_POST['step'])) && ($_POST['step'] == '2')) {
    $tr_class_1 = null;
    $label_1 = "Done";
    $label_color_1 = "success";
    $tr_class_2 = "warning";
    $label_2 = "Working";
    $label_color_2 = "danger";
    $tr_class_3 = null;
    $label_3 = "To Do";
    $label_color_3 = "default";
    $tr_class_4 = null;
    $label_4 = "To Do";
    $label_color_4 = "default";
    $tr_class_5 = null;
    $label_5 = "To Do";
    $label_color_5 = "default";
    $tr_class_6 = null;
    $label_6 = "To Do";
    $label_color_6 = "default";
    $tr_class_7 = null;
    $label_7 = "To Do";
    $label_color_7 = "default";
    $tr_class_8 = null;
    $label_8 = "To Do";
    $label_color_8 = "default";
    $percentage_complete = 15;
    $progress_color = "primary";

} elseif ((isset($_POST['step'])) && ($_POST['step'] == '3')) {
    $tr_class_1 = null;
    $label_1 = "Done";
    $label_color_1 = "success";
    $tr_class_2 = null;
    $label_2 = "Done";
    $label_color_2 = "success";
    $tr_class_3 = "warning";
    $label_3 = "Working";
    $label_color_3 = "danger";
    $tr_class_4 = null;
    $label_4 = "To Do";
    $label_color_4 = "default";
    $tr_class_5 = null;
    $label_5 = "To Do";
    $label_color_5 = "default";
    $tr_class_6 = null;
    $label_6 = "To Do";
    $label_color_6 = "default";
    $tr_class_7 = null;
    $label_7 = "To Do";
    $label_color_7 = "default";
    $tr_class_8 = null;
    $label_8 = "To Do";
    $label_color_8 = "default";
    $percentage_complete = 30;
    $progress_color = "primary";

} elseif ((isset($_POST['step'])) && ($_POST['step'] == '4')) {
    $tr_class_1 = null;
    $label_1 = "Done";
    $label_color_1 = "success";
    $tr_class_2 = null;
    $label_2 = "Done";
    $label_color_2 = "success";
    $tr_class_3 = null;
    $label_3 = "Done";
    $label_color_3 = "success";
    $tr_class_4 = "warning";
    $label_4 = "Working";
    $label_color_4 = "danger";
    $tr_class_5 = null;
    $label_5 = "To Do";
    $label_color_5 = "default";
    $tr_class_6 = null;
    $label_6 = "To Do";
    $label_color_6 = "default";
    $tr_class_7 = null;
    $label_7 = "To Do";
    $label_color_7 = "default";
    $tr_class_8 = null;
    $label_8 = "To Do";
    $label_color_8 = "default";
    $percentage_complete = 40;
    $progress_color = "primary";

} elseif ((isset($_POST['step'])) && ($_POST['step'] == '5')) {
    $tr_class_1 = null;
    $label_1 = "Done";
    $label_color_1 = "success";
    $tr_class_2 = null;
    $label_2 = "Done";
    $label_color_2 = "success";
    $tr_class_3 = null;
    $label_3 = "Done";
    $label_color_3 = "success";
    $tr_class_4 = null;
    $label_4 = "Done";
    $label_color_4 = "success";
    $tr_class_5 = "warning";
    $label_5 = "Working";
    $label_color_5 = "danger";
    $tr_class_6 = null;
    $label_6 = "To Do";
    $label_color_6 = "default";
    $tr_class_7 = null;
    $label_7 = "To Do";
    $label_color_7 = "default";
    $tr_class_8 = null;
    $label_8 = "To Do";
    $label_color_8 = "default";
    $percentage_complete = 50;
    $progress_color = "primary";

} elseif ((isset($_POST['step'])) && ($_POST['step'] == '6')) {
    $tr_class_1 = null;
    $label_1 = "Done";
    $label_color_1 = "success";
    $tr_class_2 = null;
    $label_2 = "Done";
    $label_color_2 = "success";
    $tr_class_3 = null;
    $label_3 = "Done";
    $label_color_3 = "success";
    $tr_class_4 = null;
    $label_4 = "Done";
    $label_color_4 = "success";
    $tr_class_5 = null;
    $label_5 = "Done";
    $label_color_5 = "success";
    $tr_class_6 = "warning";
    $label_6 = "Working";
    $label_color_6 = "danger";
    $tr_class_7 = null;
    $label_7 = "To Do";
    $label_color_7 = "default";
    $tr_class_8 = null;
    $label_8 = "To Do";
    $label_color_8 = "default";
    $percentage_complete = 60;
    $progress_color = "primary";

} elseif ((isset($_POST['step'])) && ($_POST['step'] == '7')) {
    $tr_class_1 = null;
    $label_1 = "Done";
    $label_color_1 = "success";
    $tr_class_2 = null;
    $label_2 = "Done";
    $label_color_2 = "success";
    $tr_class_3 = null;
    $label_3 = "Done";
    $label_color_3 = "success";
    $tr_class_4 = null;
    $label_4 = "Done";
    $label_color_4 = "success";
    $tr_class_5 = null;
    $label_5 = "Done";
    $label_color_5 = "success";
    $tr_class_6 = null;
    $label_6 = "Done";
    $label_color_6 = "success";
    $tr_class_7 = "warning";
    $label_7 = "Working";
    $label_color_7 = "danger";
    $tr_class_8 = null;
    $label_8 = "To Do";
    $label_color_8 = "default";
    $percentage_complete = 80;
    $progress_color = "primary";

} elseif ((isset($_POST['step'])) && ($_POST['step'] == '8')) {
    $tr_class_1 = null;
    $label_1 = "Done";
    $label_color_1 = "success";
    $tr_class_2 = null;
    $label_2 = "Done";
    $label_color_2 = "success";
    $tr_class_3 = null;
    $label_3 = "Done";
    $label_color_3 = "success";
    $tr_class_4 = null;
    $label_4 = "Done";
    $label_color_4 = "success";
    $tr_class_5 = null;
    $label_5 = "Done";
    $label_color_5 = "success";
    $tr_class_6 = null;
    $label_6 = "Done";
    $label_color_6 = "success";
    $tr_class_7 = null;
    $label_7 = "Done";
    $label_color_7 = "success";
    $tr_class_8 = "warning";
    $label_8 = "Working";
    $label_color_8 = "danger";
    $percentage_complete = 100;
    $progress_color = "primary";
}

if (isset($_POST['db_name'])) {
    $fail_message = null;
    $db_name = $_POST['db_name'];
    $db_user = $_POST['db_user'];
    $db_pass = $_POST['db_pass'];
    $db_host = $_POST['db_host'];
    try {
        $db = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8", $db_user, $db_pass);
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $db->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        $fail_message = "<strong>Error!</strong> No connection to the database could be made. Please check your settings.";
    }

    if ($fail_message == "") {

        $res1 = null;
        $res2 = null;
        $res3 = null;
        $res1 = $db->query("CREATE TABLE IF NOT EXISTS idevaff_test (record tinyint(10) NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");
        $res2 = $db->query("INSERT into idevaff_test (record) VALUES ('1')");
        $res3 = $db->query('DROP TABLE IF EXISTS idevaff_test');
        if (($res1 === false) || ($res2 === false) || ($res3 === false)) {
            $fail_message = "<strong>Error!</strong> Please issue full privileges to your MySQL user, for your MySQL database.";
        } else {
            $db->query('DROP TABLE IF EXISTS idevaff_test');
        }
    }

    if (!isset($fail_message)) {
        $q = $db->query("SHOW TABLES LIKE 'idevaff_config'");
        if ($q->rowCount() == 1) {
            $fail_message = "<strong>Error!</strong> The database you're connecting to already has iDevAffiliate data in it. Please replace your /API/database.php file and exit the installation routine or select a different/empty database.";
        }
    }

    if (!isset($fail_message)) {

// CREATE DATABASE.PHP FILE
        $my_file = "../API/database.php";
        if (file_exists($my_file)) {
            unlink($my_file);
        }
        $handle = @fopen($my_file, 'a');
        $data = '<?PHP
#############################################################
## iDevAffiliate Version ' . $version . '
## Copyright - iDevAffiliate Inc.
## Website: https://www.idevdirect.com/
## Support: https://www.idevsupport.com/
#############################################################

		$dbhost = "' . $db_host . '";
		$dbuser = "' . $db_user . '";
		$dbpass = "' . $db_pass . '";
		$dbname = "' . $db_name . '";

		include_once ($path . "/API/database_connection.php");
	
?>';
        @fwrite($handle, $data);
        if (!file_exists($my_file)) {
            $fail_message = "<strong>Error!</strong> The database file (API/database.php) could not be created.<br />Note: This doesn't mean we're in trouble here. It just means we need to do an alternate setup.<br /><br />Please contact the iDevAffiliate technical support team for help.</span>";
        }
    }

    if (!isset($fail_message)) {
        $success_message = "<strong>Success!</strong> Your database connection was successful! We created your database connectivity file.";
    }
}

if (isset($_POST['install_tables'])) {
    if (isset($_POST['success'])) {
        $success_message = $_POST['success'];
    }

    if (isset($_POST['error'])) {
        $fail_message = $_POST['error'];
    }
}


if (isset($_POST['install_geo_4'])) {
    if (isset($_POST['success'])) {
        $success_message = $_POST['success'];
    }
}

if (isset($_POST['install_geo_6'])) {
    if (isset($_POST['success'])) {
        $success_message = $_POST['success'];
    }
}

if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {

    if (isset($_POST['install_tables_ajax'])) {
        include 'install_tables.php';
        exit;
    }

    if (isset($_POST['install_geo4_ajax'])) {
        include 'install_geo4.php';
        exit;
    }

    if (isset($_POST['install_geo6_ajax'])) {
        include 'install_geo6.php';
        exit;
    }

    exit;
}


if (isset($_POST['create'])) {

    include_once("../API/path.php");
    include_once($path . "/API/database.php");

    $fail_message = null;
    $fail_notify_for_account_creation = true;

    if (strlen(trim($_POST['ad_username'])) < 4) {
        $fail_message .= "- Username must be 4-12 characters in length.<br />";
    }

    if (strlen(trim($_POST['ad_username'])) > 12) {
        $fail_message .= "- Username must be 4-12 characters in length.<br />";
    }

    if (strlen(trim($_POST['ad_password'])) < 4) {
        $fail_message .= "- Password must be 4-12 characters in length.<br />";
    }

    if (strlen(trim($_POST['ad_password'])) > 12) {
        $fail_message .= "- Password must be 4-12 characters in length.<br />";
    }

    if ((preg_match("/[^a-z0-9_]/i", $_POST['ad_username']))) {
        $fail_message .= "- Username may only contain letters, numbers and underscores.<br />";
    }

    if ((preg_match("/[^a-z0-9_]/i", $_POST['ad_password']))) {
        $fail_message .= "- Password may only contain letters, numbers and underscores.<br />";
    }

    if (!$_POST['ad_username']) {
        $fail_message .= "- Missing username.<br />";
    }

    if (!$_POST['ad_password']) {
        $fail_message .= "- Missing password.<br />";
    }

    if (($_POST['ad_password']) != ($_POST['vr_password'])) {
        $fail_message .= "- Passwords do not match.<br />";
    }

//function email_valid($credential) {
//$rtn_value = false;
//if (get_magic_quotes_gpc()) {
//$credential = stripslashes($credential); }
//if ((preg_match("/^([a-zA-Z0-9_]|\\-|\\.)+@(([a-zA-Z0-9_]|\\-)+\\.)+[a-z]{2,5}\$/i", $credential))) {
//$rtn_value=true; } return $rtn_value; }
//if (!email_valid($email)) { $fail_message .= "- Invalid email address.<br />"; }

    $email = $_POST['email'];
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $fail_message .= "- Invalid email address.<br />";
    }

    if (!isset($fail_message)) {
        $writeadmin = $_POST['ad_username'];
        $writepasso = $_POST['ad_password'];
        $writepassw = $_POST['ad_password'];
        $writeemail = $_POST['email'];
        $writepassw = sha1('idev_secret' . $writepassw);

        $st = $db->prepare("insert into idevaff_admin (adminid, adminpass, super, email) values (?, ?, '1', ?)");
        $st->execute(array($writeadmin, $writepassw, $writeemail));

        $st = $db->prepare("update idevaff_email_settings set address = ?, alternate_email_address = ?");
        $st->execute(array($writeemail, $writeemail));

        $success_message = "<strong>Success!</strong> Your account has been created!";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>iDevAffiliate <?PHP echo $write_edition; ?> Installation Program</title>
    <link href="templates/bootstrap/css/bootstrap.css" rel="stylesheet">
    <link href="templates/bootstrap/css/custom.css" rel="stylesheet">
    <script>
        window.paceOptions =
            {

                target: '.loader-1'
            }
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pace/1.0.2/pace.min.js"
            data-pace-options='{ "startOnPageLoad": false }'></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/pace/1.0.2/themes/black/pace-theme-loading-bar.min.css"
          rel="stylesheet">
    <style>
        .pace {
            position: relative;
            width: 100%;
        }

        /*body > .pace {*/
        /*display: none !important;*/
        /*}*/
    </style>
</head>
<body>


<div class="navbar navbar-inverse navbar-fixed-top" role="navigation">
    <div class="container">
        <div class="navbar-header" style="margin-top:6px;"><img src="../admin/images/idevaffiliate_logo.png"></div>
        <div class="navbar-collapse collapse">
<span class="pull-right" style="margin-top:8px;"><font
            style="font-size:24px; color:#cbcbcb;"><?PHP echo $write_edition; ?> Installation</font>
        </div>
    </div>
</div>


<div id="wrap">
    <div class="container">

        <h4>Installation Progress: <?PHP echo $percentage_complete; ?>% Complete</h4>
        <div class="progress progress-striped active">
            <div class="progress-bar progress-bar-<?PHP echo $progress_color; ?>" role="progressbar"
                 aria-valuenow="<?PHP echo $percentage_complete; ?>" aria-valuemin="0" aria-valuemax="100"
                 style="width: <?PHP echo $percentage_complete; ?>%">
                <span class="sr-only"><?PHP echo $percentage_complete; ?>% Complete</span>
            </div>
        </div>


        <div class="row">
            <div class="col-md-12">

                <div class="col-md-4">
                    <table class="table table-striped">
                        <tbody>
                        <tr class="<?PHP echo $tr_class_1; ?>">
                            <td>Step 1: Licensing
                                <div class="pull-right">
                                    <div class="label label-<?PHP echo $label_color_1; ?>"><?PHP echo $label_1; ?></div>
                                </div>
                            </td>
                        </tr>
                        <tr class="<?PHP echo $tr_class_2; ?>">
                            <td>Step 2: Permissions
                                <div class="pull-right">
                                    <div class="label label-<?PHP echo $label_color_2; ?>"><?PHP echo $label_2; ?></div>
                                </div>
                            </td>
                        </tr>
                        <tr class="<?PHP echo $tr_class_3; ?>">
                            <td>Step 3: Create Database
                                <div class="pull-right">
                                    <div class="label label-<?PHP echo $label_color_3; ?>"><?PHP echo $label_3; ?></div>
                                </div>
                            </td>
                        </tr>
                        <tr class="<?PHP echo $tr_class_4; ?>">
                            <td>Step 4: Install Database
                                <div class="pull-right">
                                    <div class="label label-<?PHP echo $label_color_4; ?>"><?PHP echo $label_4; ?></div>
                                </div>
                            </td>
                        </tr>
                        <tr class="<?PHP echo $tr_class_5; ?>">
                            <td>Step 5: Install IPv4 Geo Data
                                <div class="pull-right">
                                    <div class="label label-<?PHP echo $label_color_5; ?>"><?PHP echo $label_5; ?></div>
                                </div>
                            </td>
                        </tr>
                        <tr class="<?PHP echo $tr_class_6; ?>">
                            <td>Step 6: Install IPv6 Geo Data
                                <div class="pull-right">
                                    <div class="label label-<?PHP echo $label_color_6; ?>"><?PHP echo $label_6; ?></div>
                                </div>
                            </td>
                        </tr>
                        <tr class="<?PHP echo $tr_class_7; ?>">
                            <td>Step 7: Admin Login
                                <div class="pull-right">
                                    <div class="label label-<?PHP echo $label_color_7; ?>"><?PHP echo $label_7; ?></div>
                                </div>
                            </td>
                        </tr>
                        <tr class="<?PHP echo $tr_class_8; ?>">
                            <td>Step 8: Review
                                <div class="pull-right">
                                    <div class="label label-<?PHP echo $label_color_8; ?>"><?PHP echo $label_8; ?></div>
                                </div>
                            </td>
                        </tr>
                        </tbody>
                    </table>

                    <div><a href="https://www.idevdirect.com/video_tutorials.php?tab=2&video_id=200" target="_blank"
                            class="btn btn-block btn-warning">Watch Install Video</a></div>

                </div>

                <div class="col-md-8">

                    <?PHP if ((!isset($_POST['step'])) || ($_POST['step'] == 1)) { ?>

                        <h4>Installation Step #1<span class="pull-right"><small>Enter your iDevAffiliate license key.</small></span>
                        </h4>
                        <hr style="margin-bottom:15px;">

                        <?PHP
                        if ((isset($_POST['license_submit'])) && (!isset($fail_message))) {
                            $success_message = "<strong>Success!</strong> License key accepted.";
                        }
                        include("includes/notifications.php");
                        ?>

                        <?PHP if (isset($_POST['license'])) { ?>
                            <form class="form-horizontal" role="form" method="post" action="install.php">
                                <button type="submit" class="btn btn-success btn-sm">Continue To Next Step</button>
                                <input type="hidden" name="step" value="2">
                                <input type="hidden" name="newinstall" value="1">
                                <input type="hidden" name="license" value="<?PHP echo $license; ?>">
                                <input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
                            </form>
                        <?PHP } else { ?>
                            <p style="margin-bottom:30px;">Your license key can be found by logging into the <a
                                        href="https://www.idevstore.com/customers/index.php?task=dashboard"
                                        target="_blank">Client Area</a> on our website.</p>
                            <form class="form-horizontal" role="form" method="post" action="install.php">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">License Key</label>
                                    <div class="col-md-9"><input type="text" name="license"
                                                                 value="<?PHP echo ($license) ? $license : ''; ?>"
                                                                 class="form-control"
                                                                 placeholder="<?PHP echo $short_edition; ?>-XXXXXXXXXXXXXXXX"/>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="col-sm-offset-3 col-sm-9">
                                        <button type="submit" class="btn btn-primary btn-sm">Submit License Key</button>
                                    </div>
                                </div>
                                <input type="hidden" name="license_submit" value="1">
                            </form>
                        <?PHP }
                    } ?>

                    <?PHP if ((isset($_POST['step'])) && ($_POST['step'] == 2)) { ?>

                        <?PHP
                        function directory_status_label($dir_name)
                        {
                            $write_successful = false;
                            $result = false;
                            if (file_exists($dir_name)) {
                                $write_successful = isWritable($dir_name);
                                if (!$write_successful) {
                                    $dir_name = str_replace("..", "", $dir_name);
                                    $dir_name = substr_replace($dir_name, "", -1);
                                    echo "<font color='#CC0000'>" . $dir_name . "</font>";
                                } else {
                                    $dir_name = str_replace("..", "", $dir_name);
                                    $dir_name = substr_replace($dir_name, "", -1);
                                    echo $dir_name;
                                }
                            }
                        }

                        function directory_status($dir_name)
                        {
                            $write_successful = false;
                            $result = false;
                            if (file_exists($dir_name)) {
                                $write_successful = isWritable($dir_name);
                                if (!$write_successful) {
                                    echo "<div class='label label-danger'>Not Writeable</div>";
                                } else {
                                    echo "<div class='label label-success'>Writeable</div>";
                                }
                            }
                        }

                        ?>

                        <h4>Installation Step #2<span class="pull-right"><small>Set folder permissions.</small></span>
                        </h4>
                        <hr style="margin-bottom:15px;"/>
                        <p style="margin-bottom:30px;">The following folders need <u>write</u> permissions. If you need
                            help with this task, please contact your web hosting provider for information on how you can
                            changer folder permissions. We'll tighten these permissions back up in the last step.</p>

                        <?PHP if ( (!isWritable("../API/")) || (!isWritable("../cache/")) || (!isWritable("../admin/carts/")) || (!isWritable("../connect/")) ) { ?>
                            <div class="alert alert-danger">
                                <h4>Important Notice!</h4>
                                <?PHP if (!isWritable("../API/")) { ?>
                                    - We can't continue past this point until the
                                    <strong>/API</strong> folder has full write permissions.<br/>
                                <?PHP } ?>
                                <?PHP if (!isWritable("../cache/")) { ?>
                                    - We can't continue past this point until the
                                    <strong>/cache</strong> folder has full write permissions.<br/>
                                <?PHP } ?>
                                <?PHP if (!isWritable("../admin/carts/")) { ?>
                                    - We can't continue past this point until the
                                    <strong>/admin/carts</strong> folder has full write permissions.
                                <?PHP } ?>
                                <?PHP if (!isWritable("../connect/")) { ?>
                                    - We can't continue past this point until the
                                    <strong>/connect</strong> folder has full write permissions.
                                <?PHP } ?>
                            </div>
                        <?PHP } ?>

                        <div>
<span class="pull-right">
<form class="form-horizontal" role="form" method="post" action="install.php" style="display:inline-block;">
<button type="submit" class="btn btn-primary btn-sm">Refresh This Page</button>
<input type="hidden" name="step" value="2">
<input type="hidden" name="newinstall" value="1">
<input type="hidden" name="license" value="<?PHP echo $license; ?>">
<input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
</form> <?PHP if ((isWritable("../API/")) && (isWritable("../cache/"))) { ?>
        <form class="form-horizontal" role="form" method="post" action="install.php" style="display:inline-block;">
        <button type="submit" class="btn btn-success btn-sm">Continue To Next Step</button>
<input type="hidden" name="step" value="3">
<input type="hidden" name="newinstall" value="1">
<input type="hidden" name="license" value="<?PHP echo $license; ?>">
<input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
        </form><?PHP } ?>
</span>
                        </div>


                        <br/><br/>


                        <table class="table table-striped table-bordered">
                            <thead>
                            <tr>
                                <th>Folder Name</th>
                                <th>Status</th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td><?PHP echo directory_status_label("../API/"); ?></td>
                                <td><?PHP directory_status("../API/"); ?><span class="pull-right"><div
                                                class="label label-primary">Required</div></span></td>
                            </tr>
                            <tr>
                                <td><?PHP echo directory_status_label("../cache/"); ?></td>
                                <td><?PHP directory_status("../cache/"); ?><span class="pull-right"><div
                                                class="label label-primary">Required</div></span></td>
                            </tr>
                            <tr>
                                <td><?PHP echo directory_status_label("../connect/"); ?></td>
                                <td><?PHP directory_status("../connect/"); ?><span class="pull-right"><div
                                                class="label label-primary">Required</div></span></td>
                            </tr>
                            <tr>
                                <td><?PHP echo directory_status_label("../admin/carts/"); ?></td>
                                <td><?PHP directory_status("../admin/carts/"); ?><span class="pull-right"><div
                                                class="label label-primary">Required</div></span></td>
                            </tr>
                            <tr>
                                <td><?PHP echo directory_status_label("../assets/logos/"); ?></td>
                                <td><?PHP directory_status("../assets/logos/"); ?></td>
                            </tr>
                            <tr>
                                <td><?PHP echo directory_status_label("../assets/pictures/"); ?></td>
                                <td><?PHP directory_status("../assets/pictures/"); ?></td>
                            </tr>
                            <tr>
                                <td><?PHP echo directory_status_label("../media/banners/"); ?></td>
                                <td><?PHP directory_status("../media/banners/"); ?></td>
                            </tr>
                            <tr>
                                <td><?PHP echo directory_status_label("../media/email_attachments/"); ?></td>
                                <td><?PHP directory_status("../media/email_attachments/"); ?></td>
                            </tr>
                            <tr>
                                <td><?PHP echo directory_status_label("../media/lightboxes/"); ?></td>
                                <td><?PHP directory_status("../media/lightboxes/"); ?></td>
                            </tr>
                            <tr>
                                <td><?PHP echo directory_status_label("../media/pagepeels/"); ?></td>
                                <td><?PHP directory_status("../media/pagepeels/"); ?></td>
                            </tr>
                            <tr>
                                <td><?PHP echo directory_status_label("../media/pdf/"); ?></td>
                                <td><?PHP directory_status("../media/pdf/"); ?></td>
                            </tr>
                            <tr>
                                <td><?PHP echo directory_status_label("../media/qr_codes/"); ?></td>
                                <td><?PHP directory_status("../media/qr_codes/"); ?></td>
                            </tr>
                            </tbody>
                        </table>


                    <?PHP } ?>

                    <?PHP if ((isset($_POST['step'])) && ($_POST['step'] == 3)) { ?>

                        <h4>Installation Step #3<span class="pull-right"><small>Create MySQL database.</small></span>
                        </h4>
                        <hr style="margin-bottom:15px;"/>

                        <?PHP include("includes/notifications.php"); ?>

                        <?PHP if (isset($success_message)) { ?>
                            <form class="form-horizontal" role="form" method="post" action="install.php">
                                <button type="submit" class="btn btn-success btn-sm">Continue To Next Step</button>
                                <input type="hidden" name="step" value="4">
                                <input type="hidden" name="newinstall" value="1">
                                <input type="hidden" name="license" value="<?PHP echo $license; ?>">
                                <input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
                            </form>
                        <?PHP } else { ?>


                            <?PHP
                            $host_value = "localhost";
                            if (isset($_POST['db_host'])) {
                                $host_value = strip_tags(stripslashes($_POST['db_host']));
                                $host_value = htmlspecialchars($host_value, ENT_QUOTES, 'UTF-8');
                            }

                            $db_value = null;
                            if (isset($_POST['db_name'])) {
                                $db_value = strip_tags(stripslashes($_POST['db_name']));
                                $db_value = htmlspecialchars($db_value, ENT_QUOTES, 'UTF-8');
                            }

                            $user_value = null;
                            if (isset($_POST['db_user'])) {
                                $user_value = strip_tags(stripslashes($_POST['db_user']));
                                $user_value = htmlspecialchars($user_value, ENT_QUOTES, 'UTF-8');
                            }

                            $pass_value = null;
                            if (isset($_POST['db_pass'])) {
                                $pass_value = strip_tags(stripslashes($_POST['db_pass']));
                                $pass_value = htmlspecialchars($pass_value, ENT_QUOTES, 'UTF-8');
                            }
                            ?>

                            <p style="margin-bottom:30px;">Please take a moment now to create a MySQL database on your
                                web hosting account. This is usually done in your web hosting control panel. If needed,
                                please contact your web hosting provider for with this task.</p>
                            <form class="form-horizontal" role="form" method="post" action="install.php">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Database Host</label>
                                    <div class="col-md-9"><input type="text" name="db_host"
                                                                 value="<?PHP echo $host_value; ?>" class="form-control"
                                                                 placeholder="localhost"/>
                                        <p class="help-block">This is your MySQL database host. 99% of the time it
                                            remains "localhost".</p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Database Name</label>
                                    <div class="col-md-9"><input type="text" name="db_name"
                                                                 value="<?PHP echo $db_value; ?>" class="form-control"
                                                                 placeholder="database_name"/>
                                        <p class="help-block">This is your MySQL database name.</p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Database Username</label>
                                    <div class="col-md-9"><input type="text" name="db_user"
                                                                 value="<?PHP echo $user_value; ?>" class="form-control"
                                                                 placeholder="database_username"/>
                                        <p class="help-block">This is your MySQL database username.</p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Database Password</label>
                                    <div class="col-md-9"><input type="text" name="db_pass"
                                                                 value="<?PHP echo $pass_value; ?>" class="form-control"
                                                                 placeholder="database_password"/>
                                        <p class="help-block">This is your MySQL database password.</p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="col-sm-offset-3 col-sm-9">
                                        <button type="submit" class="btn btn-primary btn-sm">Submit Database
                                            Connection
                                        </button>
                                    </div>
                                </div>
                                <input type="hidden" name="step" value="3">
                                <input type="hidden" name="newinstall" value="1">
                                <input type="hidden" name="license" value="<?PHP echo $license; ?>">
                                <input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
                            </form>

                        <?PHP }
                    } ?>

                    <?PHP if ((isset($_POST['step'])) && ($_POST['step'] == 4)) { ?>
                        <h4>Installation Step #4<span class="pull-right"><small>Install database tables and content.</small></span></h4>
                        <hr style="margin-bottom:15px;"/>
						
						<?PHP
						if (file_exists($path . '/API/database.php')) {
						include_once("../API/path.php");
						include_once($path . "/API/database.php");
						
						$sql_mode = $db->query("SELECT @@sql_mode");
						$sql_mode = $sql_mode->fetch();
						if(strpos($sql_mode['@@sql_mode'], 'STRICT_TRANS_TABLES') !== false) {
						?>
						<p><span style="color:#CC0000;"><strong>Installation Error!</strong></span> Install cannot continue. Please disable <strong>MySQL STRICT MODE</strong> on your hosting account. If needed, please contact your hosting provider and/or server admin for help with this task.</p>
						<form class="form-horizontal" role="form" method="post" action="install.php" style="display:inline-block;">
						<button type="submit" class="btn btn-danger btn-sm mt-2">Try Again Now</button>
						<input type="hidden" name="step" value="4">
						<input type="hidden" name="newinstall" value="1">
						<input type="hidden" name="license" value="<?PHP echo $license; ?>">
						<input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
						</form>
						<?PHP
						exit();
						} }
						?>

                        <?PHP include("includes/notifications.php"); ?>

                        <?PHP if (!isset($success_message)) { ?>
												
                            <p style="margin-bottom:30px;">Next we will install the database tables and insert your
                                default settings. This should be pretty quick.</p>
                            <form class="form-horizontal install-tables-form" role="form" method="post"
                                  action="install.php" style="display: none;">
                                <button type="submit" class="btn btn-primary btn-sm">Install Database</button>
                                <input type="hidden" name="step" value="4">
                                <input type="hidden" name="newinstall" value="1">
                                <input type="hidden" name="license" value="<?PHP echo $license; ?>">
                                <input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
                                <input type="hidden" name="install_tables" value="1">
                            </form>
                            <a href="#" class="install-tables-btn btn btn-primary btn-sm">Install Database</a>
                            <div class="loader-1"></div>
                        <?PHP } else { ?>
                            <form class="form-horizontal" role="form" method="post" action="install.php">
                                <button type="submit" class="btn btn-success btn-sm">Continue To Next Step</button>
                                <input type="hidden" name="step" value="5">
                                <input type="hidden" name="newinstall" value="1">
                                <input type="hidden" name="license" value="<?PHP echo $license; ?>">
                                <input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
                            </form>
                        <?PHP }
                    } ?>

                    <?PHP if ((isset($_POST['step'])) && ($_POST['step'] == 5)) { ?>
                        <h4>Installation Step #5<span class="pull-right"><small>Install IPv4 Geo data.</small></span>
                        </h4>
                        <hr style="margin-bottom:15px;"/>

                        <?PHP include("includes/notifications.php"); ?>

                        <?PHP if (!isset($success_message)) { ?>
                            <p style="margin-bottom:30px;">Next we will install IPv4 Geo data. This will take a few
                                minutes.</p>
                            <form class="form-horizontal install_geo_4_form" role="form" method="post"
                                  action="install.php" style="display: none;">
                                <button type="submit" class="btn btn-primary btn-sm">Install IPv4 Geo Data</button>
                                <input type="hidden" name="step" value="5">
                                <input type="hidden" name="newinstall" value="1">
                                <input type="hidden" name="license" value="<?PHP echo $license; ?>">
                                <input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
                                <input type="hidden" name="install_geo_4" value="1">
                            </form>
                            <a type="submit" class="btn btn-primary btn-sm install_geo_4_btn">Install IPv4 Geo Data</a>
                            <div class="loader-1"></div>
                        <?PHP } else { ?>
                            <form class="form-horizontal" role="form" method="post" action="install.php">
                                <button type="submit" class="btn btn-success btn-sm">Continue To Next Step</button>
                                <input type="hidden" name="step" value="6">
                                <input type="hidden" name="newinstall" value="1">
                                <input type="hidden" name="license" value="<?PHP echo $license; ?>">
                                <input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
                            </form>
                        <?PHP }
                    } ?>

                    <?PHP if ((isset($_POST['step'])) && ($_POST['step'] == 6)) { ?>
                        <h4>Installation Step #6<span class="pull-right"><small>Install IPv6 Geo data.</small></span>
                        </h4>
                        <hr style="margin-bottom:15px;"/>

                        <?PHP include("includes/notifications.php"); ?>

                        <?PHP if (!isset($success_message)) { ?>
                            <p style="margin-bottom:30px;">Now we'll install IPv6 Geo data. This will take even longer
                                than IPv4 did.</p>
                            <form class="form-horizontal install_geo_6_form" role="form" method="post"
                                  action="install.php" style="display: none;">
                                <button type="submit" class="btn btn-primary btn-sm">Install IPv6 Geo Data</button>
                                <input type="hidden" name="step" value="6">
                                <input type="hidden" name="newinstall" value="1">
                                <input type="hidden" name="license" value="<?PHP echo $license; ?>">
                                <input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
                                <input type="hidden" name="install_geo_6" value="1">
                            </form>
                            <a type="submit" class="btn btn-primary btn-sm install_geo_6_btn">Install IPv6 Geo Data</a>
                            <div class="loader-1"></div>
                        <?PHP } else { ?>
                            <form class="form-horizontal" role="form" method="post" action="install.php">
                                <button type="submit" class="btn btn-success btn-sm">Continue To Next Step</button>
                                <input type="hidden" name="step" value="7">
                                <input type="hidden" name="newinstall" value="1">
                                <input type="hidden" name="license" value="<?PHP echo $license; ?>">
                                <input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
                            </form>
                        <?PHP }
                    } ?>

                    <?PHP if ((isset($_POST['step'])) && ($_POST['step'] == 7)) { ?>

                        <h4>Installation Step #7<span class="pull-right"><small>Create administrative login.</small></span>
                        </h4>
                        <hr style="margin-bottom:15px;"/>

                        <?PHP include("includes/notifications.php"); ?>


                        <?PHP if (!isset($success_message)) { ?>

                            <p style="margin-bottom:30px;">Let's create your administrative login and get you logged in
                                to your new affiliate program!</p>
                            <form class="form-horizontal" role="form" method="post" action="install.php">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Username</label>
                                    <div class="col-md-9"><input type="text" name="ad_username"
                                                                 value="<?PHP if (isset($_POST['ad_username'])) {
                                                                     echo $_POST['ad_username'];
                                                                 } else {
                                                                     echo "admin";
                                                                 } ?>" class="form-control" placeholder="admin"/>
                                        <p class="help-block">This is your username for your administrative center.<br/>-
                                            Must be 4 to 12 characters in length.</p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Password</label>
                                    <div class="col-md-9"><input type="password" name="ad_password"
                                                                 value="<?PHP if (isset($_POST['ad_password'])) {
                                                                     echo $_POST['ad_password'];
                                                                 } ?>" class="form-control" placeholder=""/>
                                        <p class="help-block">Your password must be alpha-numeric and can also include
                                            underscores.<br/>- Must be 4 to 12 characters in length.</p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Verify Password</label>
                                    <div class="col-md-9"><input type="password" name="vr_password"
                                                                 value="<?PHP if (isset($_POST['vr_password'])) {
                                                                     echo $_POST['vr_password'];
                                                                 } ?>" class="form-control" placeholder=""/>
                                        <p class="help-block">Make sure this entry matches your password above.</p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Email Address</label>
                                    <div class="col-md-9"><input type="text" name="email"
                                                                 value="<?PHP if (isset($_POST['email'])) {
                                                                     echo $_POST['email'];
                                                                 } ?>" class="form-control"
                                                                 placeholder="your@email.com"/>
                                        <p class="help-block">We need this should you ever need to request your login
                                            details in the future.</p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="col-sm-offset-3 col-sm-9">
                                        <button type="submit" class="btn btn-primary btn-sm">Create My Login</button>
                                    </div>
                                </div>
                                <input type="hidden" name="step" value="7">
                                <input type="hidden" name="newinstall" value="1">
                                <input type="hidden" name="license" value="<?PHP echo $license; ?>">
                                <input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
                                <input type="hidden" name="create" value="1">
                            </form>
                        <?PHP } else { ?>
                            <form class="form-horizontal" role="form" method="post" action="install.php">
                                <button type="submit" class="btn btn-success btn-sm">Continue To Next Step</button>
                                <input type="hidden" name="step" value="8">
                                <input type="hidden" name="newinstall" value="1">
                                <input type="hidden" name="license" value="<?PHP echo $license; ?>">
                                <input type="hidden" name="license_method" value="<?PHP echo $license_method; ?>">
                                <input type="hidden" name="new_admin" value="<?PHP echo $writeadmin; ?>">
                                <input type="hidden" name="new_password" value="<?PHP echo $writepasso; ?>">
                            </form>
                        <?PHP }
                    } ?>

                    <?PHP
                    if ((isset($_POST['step'])) && ($_POST['step'] == 8)) {

                        if (!function_exists('html_output')) {
                            function html_output($value)
                            {
                                $value = stripslashes($value);
                                $value = htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
                                return $value;
                            }
                        }
                        ?>

                        <h4>Installation Step #8<span class="pull-right"><small>Bookmark your affiliate program locations.</small></span>
                        </h4>
                        <hr style="margin-bottom:15px;"/>
                        <h2 style="margin-bottom:30px;">Congratulations!
                            <small>Your installation is complete.</small>
                        </h2>

                        <div class="well">Please take a moment to go through your post-installation steps below.</div>
                        <ol>
                            <li style="margin-bottom:10px;"><span class="label label-danger">Required</span> Remove or
                                rename the <strong>/install</strong> folder. Your admin center won't run with it in
                                tact.
                            </li>
                            <li style="margin-bottom:10px;"><span class="label label-default">Optional</span> Remove
                                write permissions on your <strong>/API</strong> folder. If needed, please contact your
                                web hosting provider for help.
                            </li>
                            <li style="margin-bottom:10px;"><span class="label label-warning">Important</span> Write
                                down your administrative center username and password.<br/><br/>Admin Username: <font
                                        color="#CC0000"><?PHP echo html_output($_POST['new_admin']); ?></font><br/>Admin
                                Password: <font
                                        color="#CC0000"><?PHP echo html_output($_POST['new_password']); ?></font></li>
                        </ol>
                        <br/>
                        <div class="alert alert-danger">
                            <h4>Your next step is to login to your iDevAffiliate admin center.</h4>Once logged in, walk
                            through the Onboarding process to get started with your settings and configuration.
                        </div>

                        <div>
                            <form method="post" action="../index.php" target="_blank"
                                  style="display:inline-block; margin-right:15px">
                                <input type="submit" name="admin" value="View Affiliate Control Panel"
                                       class="btn btn-lg btn-primary"/>
                            </form>
                            <form method="post" action="../admin/index.php" target="_blank"
                                  style="display:inline-block; margin-left:15px">
                                <input type="submit" name="admin" value="Login To Admin Center"
                                       class="btn btn-lg btn-danger"/>
                            </form>
                        </div>

                    <?PHP } ?>

                </div>


            </div>
        </div>


    </div>
</div>

<div id="footer">
    <div class="container">
        <p class="text-muted credit pull-right">Copyright 1999-<?PHP echo date("Y"); ?> - iDevAffiliate Inc. - <a
                    href="https://www.idevdirect.com/" target="_blank">iDevAffiliate</a></p>
    </div>
</div>

<script src="templates/bootstrap/js/jquery-2.0.3.min.js"></script>
<script src="templates/bootstrap/js/bootstrap.min.js"></script>
<script>
    (function ($) {

        var $install_table_data = $('.install-tables-form').serialize();
        $install_table_data += '&install_tables_ajax=1';

        var $install_geo4_data = $('.install_geo_4_form').serialize();
        $install_geo4_data += '&install_geo4_ajax=1';

        var $install_geo6_data = $('.install_geo_6_form').serialize();
        $install_geo6_data += '&install_geo6_ajax=1';

        perform_ajax('.install-tables-form', '.install-tables-btn', 'install.php', $install_table_data);
        perform_ajax('.install_geo_4_form', '.install_geo_4_btn', 'install.php', $install_geo4_data);
        perform_ajax('.install_geo_6_form', '.install_geo_6_btn', 'install.php', $install_geo6_data);


        function perform_ajax($form, $btn, $action, $data) {
            $(document).on('click', $btn, function (e) {
                e.preventDefault();
                var form = $($form);
                $(this).text('Installing..').attr('disabled', 'disabled');
                //Pace.start();
                $.ajax({
                    url: $action,
                    data: $data,
                    method: 'POST',
                    success: function (response) {
                        form.append('<input type="hidden" name="success" value="' + response + '">');
                        //Pace.stop();
                        form.submit();
                    },

                    error: function (response) {
                        form.append('<input type="hidden" name="error" value="' + response + '">');
                        //Pace.stop();
                        form.submit();
                    }
                });

                //return false;
            });
        }
    })(jQuery);
</script>
</body>
</html>
