$(document).ready(function(){
    // BANNERS
    if(jQuery('#dyntable_banners').length > 0) {
        var oTable = jQuery('#dyntable_banners').dataTable({
            "bProcessing"       : true,
            "bServerSide"       : true,
            "iDisplayLength"    : 1,
            "bLengthChange"		: false,
            "sAjaxSource"       : "dynamic/dyn_banners.php",
            "aoColumnDefs"      : [{ "bSortable": false, "aTargets": [ 0] }],
            "bFilter"           : false,
            "bStateSave"		: true,
            "iCookieDuration"	: 1,
            "fnDrawCallback"	: function(oSettings) {
                jQuery(".dataTables_header").parent('div').hide();
                jQuery("#dyntable_banners thead").hide();
                jQuery("#dyntable_banners tbody tr td").addClass('modifyDatatable');
                jQuery(".dataTable").addClass('noTopMargin');
            },
            "fnServerParams": function ( aoData ) {
                // Read values
                var search_group = jQuery('select[name="search_group"]').val();
                var keyword_search = jQuery('input[name="keyword_search"]').val();

                // Append to data
                aoData.push( { "name": "search_group", "value": search_group } );
                aoData.push( { "name": "keyword_search", "value": keyword_search } );
            }
        });

        jQuery('.search_banners').click(function() {
            oTable.fnDraw();
        });
    }

	
	// ANNOUNCEMENTS
    function announcements_datatable(id, channel) {
        if(jQuery(id).length > 0) {
            var oTable = jQuery(id).dataTable({
                "bProcessing"       : true,
                "bServerSide"       : true,
                "iDisplayLength"    : 1,
                "bLengthChange"		: false,
                "sAjaxSource"       : "dynamic/dyn_announcements.php?channel=" + channel,
                "aoColumnDefs"      : [{ "bSortable": false, "aTargets": [ 0] }],
                "bFilter"           : false,
                "bStateSave"		: true,
                "iCookieDuration"	: 1,
                "fnDrawCallback"	: function(oSettings) {
                    jQuery(".dataTables_header").parent('div').hide();
                    jQuery(id+" thead").hide();
                    jQuery(id+" tbody tr td").addClass('modifyDatatable');
                    jQuery(".dataTable").addClass('noTopMargin');
                }
            });
        }
    }

    announcements_datatable("#dyntable_announcements_facebook", "facebook");
    announcements_datatable("#dyntable_announcements_twitter", "twitter");
    announcements_datatable("#dyntable_announcements_pinterest", "pinterest");
    announcements_datatable("#dyntable_announcements_linkedin", "linkedin");

	
	// CUSTOM FORM FIELDS
    if(jQuery('#dyntable_custom_form_fields').length > 0) {
        jQuery('#dyntable_custom_form_fields').dataTable({
            "bProcessing"       : true,
            "bServerSide"       : true,
			"iDisplayLength"    : 1,
			"bLengthChange"     : false, // disable rows per page
			"sAjaxSource"       : "dynamic/dyn_custom_form_fields.php",
			"aoColumnDefs"      : [{ "bSortable": false, "aTargets": [ 0] }],
			"bFilter"           : false,
			"bStateSave"		: true,
			"iCookieDuration"	: 1,
            "fnDrawCallback"    : function(oSettings) {
				jQuery("#dyntable_custom_form_fields thead").hide();
				jQuery("#dyntable_custom_form_fields tbody tr td").addClass('modifyDatatable');
				jQuery(".dataTable").addClass('noTopMargin');
            }
        });
    }
	
	// FAQ
    if(jQuery('#dyntable_faq').length > 0) {
        var oTable = jQuery('#dyntable_faq').dataTable({
            "bProcessing"       : true,
            "bServerSide"       : true,
            "iDisplayLength"    : 1,
			"bLengthChange"		: false,
            "sAjaxSource"       : "dynamic/dyn_faq.php",
            "aoColumnDefs"      : [{ "bSortable": false, "aTargets": [ 0] }],
            "bFilter"           : false,
			"bStateSave"		: true,
			"iCookieDuration"	: 1,
			"fnDrawCallback"	: function(oSettings) {

				jQuery("#dyntable_faq thead").hide();
				jQuery("#dyntable_faq tbody tr td").addClass('modifyDatatable');
				jQuery(".dataTable").addClass('noTopMargin');
			}        
        });		
    }
	
	// MARKETING GROUPS
    if(jQuery('#dyntable_groups').length > 0) {
        var oTable = jQuery('#dyntable_groups').dataTable({
            "bProcessing"       : true,
            "bServerSide"       : true,
            "iDisplayLength"    : 1,
			"bLengthChange"		: false,
            "sAjaxSource"       : "dynamic/dyn_groups.php",
            "aoColumnDefs"      : [{ "bSortable": false, "aTargets": [ 0] }],
            "bFilter"           : false,
			"bStateSave"		: true,
			"iCookieDuration"	: 1,
			"fnDrawCallback"	: function(oSettings) {

				jQuery("#dyntable_groups thead").hide();
				jQuery("#dyntable_groups tbody tr td").addClass('modifyDatatable');
				jQuery(".dataTable").addClass('noTopMargin');
			},
            "fnServerParams": function ( aoData ) {
                // Read values
                var keyword_search = jQuery('input[name="keyword_search"]').val();

                // Append to data
                aoData.push( { "name": "keyword_search", "value": keyword_search } );
            }
        });

        jQuery('.search_group').click(function() {
            oTable.fnDraw();
        });
    }
	
	// HTML TEMPLATES
    if(jQuery('#dyntable_htmlads').length > 0) {
        var oTable = jQuery('#dyntable_htmlads').dataTable({
            "bProcessing"       : true,
            "bServerSide"       : true,
            "iDisplayLength"    : 1,
			"bLengthChange"		: false,
            "sAjaxSource"       : "dynamic/dyn_htmlads.php",
            "aoColumnDefs"      : [{ "bSortable": false, "aTargets": [ 0] }],
            "bFilter"           : false,
			"bStateSave"		: true,
			"iCookieDuration"	: 1,
			"fnDrawCallback"	: function(oSettings) {
				jQuery(".dataTables_header").parent('div').hide();
				jQuery("#dyntable_htmlads thead").hide();
				jQuery("#dyntable_htmlads tbody tr td").addClass('modifyDatatable');
				jQuery(".dataTable").addClass('noTopMargin');
				$(".fancy-page").fancybox();
			}        
        });		
    }
	
	// LIGHTBOXES
    if(jQuery('#dyntable_lightboxes').length > 0) {
        var oTable = jQuery('#dyntable_lightboxes').dataTable({
            "bProcessing"       : true,
            "bServerSide"       : true,
            "iDisplayLength"    : 1,
			"bLengthChange"		: false,
            "sAjaxSource"       : "dynamic/dyn_lightboxes.php",
            "aoColumnDefs"      : [{ "bSortable": false, "aTargets": [ 0] }],
            "bFilter"           : false,
			"bStateSave"		: true,
			"iCookieDuration"	: 1,
			"fnDrawCallback"	: function(oSettings) {
				jQuery(".dataTables_header").parent('div').hide();
				jQuery("#dyntable_lightboxes thead").hide();
				jQuery("#dyntable_lightboxes tbody tr td").addClass('modifyDatatable');
				jQuery(".dataTable").addClass('noTopMargin');
				
				
			}        
        });		
    }
	
	// NOTES
    if(jQuery('#dyntable_notes').length > 0) {
        var oTable = jQuery('#dyntable_notes').dataTable({
            "bProcessing"       : true,
            "bServerSide"       : true,
            "iDisplayLength"    : 1,
			"bLengthChange"		: false,
            "sAjaxSource"       : "dynamic/dyn_notes.php",
            "aoColumnDefs"      : [{ "bSortable": false, "aTargets": [ 0] }],
            "bFilter"           : false,
			"bStateSave"		: true,
			"iCookieDuration"	: 1,
			"fnDrawCallback"	: function(oSettings) {
				jQuery(".dataTables_header").parent('div').hide();
				jQuery("#dyntable_notes thead").hide();
				jQuery("#dyntable_notes tbody tr td").addClass('modifyDatatable');
				jQuery(".dataTable").addClass('noTopMargin');
				
			}        
        });		
    }
	
	// PAGE PEELS
    if(jQuery('#dyntable_peels').length > 0) {
        var oTable = jQuery('#dyntable_peels').dataTable({
            "bProcessing"       : true,
            "bServerSide"       : true,
            "iDisplayLength"    : 1,
			"bLengthChange"		: false,
            "sAjaxSource"       : "dynamic/dyn_peels.php",
            "aoColumnDefs"      : [{ "bSortable": false, "aTargets": [ 0] }],
            "bFilter"           : false,
			"bStateSave"		: true,
			"iCookieDuration"	: 1,
			"fnDrawCallback"	: function(oSettings) {
				jQuery(".dataTables_header").parent('div').hide();
				jQuery("#dyntable_peels thead").hide();
				jQuery("#dyntable_peels tbody tr td").addClass('modifyDatatable');
				jQuery(".dataTable").addClass('noTopMargin');
			}			
        });		
    }
	
	 // TESTIMONIALS APPROVED
    if(jQuery('#dyntable_testi_approved').length > 0) {
        var oTable = jQuery('#dyntable_testi_approved').dataTable({
            "bProcessing"       : true,
            "bServerSide"       : true,
            "iDisplayLength"    : 1,
			"bLengthChange"		: false,
            "sAjaxSource"       : "dynamic/dyn_testi_approved.php",
            "aoColumnDefs"      : [{ "bSortable": false, "aTargets": [ 0] }],
            "bFilter"           : false,
			"bStateSave"		: true,
			"iCookieDuration"	: 1,
			"fnDrawCallback"	: function(oSettings) {
		 		
				jQuery("#dyntable_testi_approved thead").hide();
				jQuery("#dyntable_testi_approved tbody tr td").addClass('modifyDatatable');
				jQuery(".dataTable").addClass('noTopMargin');
			}        
        });		
    }
	
    // TESTIMONIALS PENDING
    if(jQuery('#dyntable_testi_pending').length > 0) {
        var oTable = jQuery('#dyntable_testi_pending').dataTable({
            "bProcessing"       : true,
            "bServerSide"       : true,
            "iDisplayLength"    : 1,
			"bLengthChange"		: false,
            "sAjaxSource"       : "dynamic/dyn_testi_pending.php",
            "aoColumnDefs"      : [{ "bSortable": false, "aTargets": [ 0] }],
            "bFilter"           : false,
			"bStateSave"		: true,
			"iCookieDuration"	: 1,
			"fnDrawCallback"	: function(oSettings) {

				jQuery("#dyntable_testi_pending thead").hide();
				jQuery("#dyntable_testi_pending tbody tr td").addClass('modifyDatatable');
				jQuery(".dataTable").addClass('noTopMargin');
				
			}        
        });		
    }
	
	// TEXT ADS
    if(jQuery('#dyntable_textads').length > 0) {
        var oTable = jQuery('#dyntable_textads').dataTable({
            "bProcessing"       : true,
            "bServerSide"       : true,
            "iDisplayLength"    : 1,
			"bLengthChange"		: false,
            "sAjaxSource"       : "dynamic/dyn_textads.php",
            "aoColumnDefs"      : [{ "bSortable": false, "aTargets": [ 0] }],
            "bFilter"           : false,
			"bStateSave"		: true,
			"iCookieDuration"	: 1,
			"fnDrawCallback"	: function(oSettings) {
				jQuery(".dataTables_header").parent('div').hide();
				jQuery("#dyntable_textads thead").hide();
				jQuery("#dyntable_textads tbody tr td").addClass('modifyDatatable');
				jQuery(".dataTable").addClass('noTopMargin');
			}        
        });		
    }
	
    // EMAIL TEMPLATES
    if(jQuery('#dyntable_email_templates').length > 0) {
        var oTable = jQuery('#dyntable_email_templates').dataTable({
            "bProcessing"       : true,
            "bServerSide"       : true,
            "iDisplayLength"    : 1,
			"bLengthChange"		: false,
            "sAjaxSource"       : "dynamic/dyn_email_templates.php",
            "aoColumnDefs"      : [{ "bSortable": false, "aTargets": [ 0] }],
            "bFilter"           : false,
			"bStateSave"		: true,
			"iCookieDuration"	: 1,
			"fnDrawCallback"	: function(oSettings) {
				jQuery(".dataTables_header").parent('div').hide();
				jQuery("#dyntable_email_templates thead").hide();
				jQuery("#dyntable_email_templates tbody tr td").addClass('modifyDatatable');
				jQuery(".dataTable").addClass('noTopMargin');
			}        
        });		
    }
	if(jQuery('#dyntable_videoes').length > 0) {
        var oTable = jQuery('#dyntable_videoes').dataTable({
            "bProcessing"       : true,
            "bServerSide"       : true,
            "iDisplayLength"    : 1,
			"bLengthChange"		: false,
            "sAjaxSource"       : "dynamic/dyn_videoes.php",
            "aoColumnDefs"      : [{ "bSortable": false, "aTargets": [ 0] }],
            "bFilter"           : false,
			"bStateSave"		: true,
			"iCookieDuration"	: 1,
			"fnDrawCallback"	: function(oSettings) {
				jQuery(".dataTables_header").parent('div').hide();
				jQuery("#dyntable_videoes thead").hide();
				jQuery("#dyntable_videoes tbody tr td").addClass('modifyDatatable');
				jQuery(".dataTable").addClass('noTopMargin');
			}        
        });		
    }
});
