$(document).ready(function(){
    $.plot("#chart_dashboard", dash, $.extend(true, {}, Plugins.getFlotDefaults(), {
        xaxis: {
            tickLength: 0,
            mode: "time",
            tickSize: [1, "day"],
            timeformat: "%b %d"
        },
        series: {
            lines: {
                fill: true,
                lineWidth: 1.5
            },
            points: {
                show: true,
                radius: 2.5,
                lineWidth: 1.1
            },
            grow: { active: true, growings:[ { stepMode: "maximum" } ] }
        },
        grid: {
            hoverable: true,
            clickable: true
        },
        tooltip: true,
        tooltipOpts: {
            content: '%s: %y'
        }
    }));
});