<?PHP
include_once("../API/config.php");
include_once("includes/session.check.php");

$leftSubActiveMenu = 'reports';
require("templates/header.php");

$get_username = $db->prepare("select id, username, f_name, l_name, tax_id_ssn from idevaff_affiliates where id = ?");
$get_username->execute(array($_REQUEST['id']));
$userdetails = $get_username->fetch();
$userid = $userdetails['id'] ?? "";
$username = $userdetails['username'] ?? "";
$fname = $userdetails['f_name'] ?? "";
$lname = $userdetails['l_name'] ?? "";
$name = $fname . " " . $lname;
if (($fname == '') && ($lname == '')) { $name = "N/A"; }

$tax_id_ssn = $db->prepare("SELECT AES_DECRYPT(tax_id_ssn, '" . AUTH_KEY . "') AS decrypted FROM idevaff_affiliates where id = ?");
$tax_id_ssn->execute(array($_REQUEST['id']));
$tax_id_ssn = $tax_id_ssn->fetch();
$utax = $tax_id_ssn['decrypted'] ?? "";

if ($utax == '') { $utax = "N/A"; }
?>

<div class="crumbs">
<ul id="breadcrumbs" class="breadcrumb">
<li><i class="icon-home"></i> <a href="dashboard.php">Dashboard</a></li>
<li> Commissions</li>
<li class="current"> <a href="payment_history.php?id=<?PHP echo html_output($_REQUEST['id']); ?>">Payment History</a></li>
</ul>
<?PHP include("templates/crumb_right.php"); ?>
</div>

<div class="page-header">
<div class="page-title"><h3>Payment History</h3><span>Affiliate ID: <?PHP echo $userid; ?> - <?PHP echo $username; ?></span></div>
<?PHP include("templates/stats.php"); ?>
</div>

<div class="widget box">
<div class="widget-header"><h4><i class="icon-money"></i> Payment History - Affiliate: <font color="#CC0000"><?PHP echo $userid; ?></font> - <font color="#CC0000"><?PHP echo $username; ?></font></h4>
<span class="pull-right"><a href="reports.php?report=3"><button class="btn btn-sm btn-default" style="display:inline-block;">Choose Another Report</button></a> 
<a href="reports.php?report=3&sub_report=4"><button class="btn btn-sm btn-warning" style="display:inline-block;">Choose Another Affiliate</button></a></span></div>
<div class="widget-content">
<form class="form-horizontal row-border" method="post" action="payment_history.php">
<input name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>" type="hidden" />
<div class="form-group row">
<label class="col-md-3 control-label">Payment Date</label>
<div class="col-md-4"><select class="form-control" name="date_selected">
<?PHP
//$get_payment_dates = $db->query("select DISTINCT(code) as dcode, record from idevaff_payments where id = '" . $userid . "'");
$get_payment_dates = $db->prepare("select DISTINCT(code) as dcode, record from idevaff_payments where id = ?");
$get_payment_dates->execute(array($userid));
if ($get_payment_dates->rowCount()) {
while ($qry = $get_payment_dates->fetch()) {
$pdate = date($dateformat, $qry['dcode']);
$pid = $qry['record'];
echo "<option value=\"" . $pid . "\"";
if ((isset($_REQUEST['date_selected'])) && ($_REQUEST['date_selected'] == $pid)) { echo " selected"; }
echo ">" . $pdate . "</option>";
} }
?>
</select>
</div>
</div>
<div class="form-actions">
<input type="submit" value="Show Payments" class="btn btn-primary">
</div>
<input type="hidden" name="id" value="<?PHP echo html_output($_REQUEST['id']); ?>">
</form>
</div>
</div>

<?PHP
if (isset($_REQUEST['date_selected'])) {
$get_total_payment_amount = $db->prepare("select code, SUM(amount) as total_paid from idevaff_payments where record = ? GROUP BY code");
$get_total_payment_amount->execute(array($_REQUEST['date_selected']));
$selected_details = $get_total_payment_amount->fetch();
$total_amount = $selected_details['total_paid'] ?? 0;
$selected_details['code'] = $selected_details['code'] ?? "";
$pdatedisplay = date($dateformat, $selected_details['code']);

$get_orig_total_payment_amount = $db->prepare("select SUM(payment) as total_paid2 from idevaff_archive where payment_rec = ?");
$get_orig_total_payment_amount->execute(array($_REQUEST['date_selected']));
$selected_orig_details = $get_orig_total_payment_amount->fetch();
$total_orig_amount = $selected_orig_details['total_paid2'] ?? 0;

$get_debit_amount = $db->prepare("select SUM(amount) as total_paid3 from idevaff_debit_archive where payment_record = ?");
$get_debit_amount->execute(array($_REQUEST['date_selected']));
$selected_debit_amount = $get_debit_amount->fetch();
$total_debit_amount = $selected_debit_amount['total_paid3'];

?>

<div class="widget box">
<div class="widget-header"><h4><i class="icon-money"></i> Payment Details</h4>
<span class="pull-right">
<a href="invoice_paid.php?invoice_id=<?PHP echo html_output($_REQUEST['date_selected']); ?>" target="_blank"><button class="btn btn-danger btn-sm">Print Invoice</button></a>
<a href="invoice_pdf_paid.php?invoice_id=<?PHP echo html_output($_REQUEST['date_selected']); ?>" target="_blank"><button class="btn btn-danger btn-sm">PDF Invoice</button></a>
</span></div>
<div class="widget-content">
<table class="table valign table-striped table-bordered table-highlight-head">
<tbody>
<tr>
<td width="25%">Affiliate ID</td><td width="25%"><?PHP echo $userid; ?></td>
<td width="25%">Payment Date</td><td width="25%"><?PHP echo $pdatedisplay; ?></td>
</tr>
<tr>
<td width="25%">Affiliate Username</td><td width="25%"><a href="account_details.php?id=<?PHP echo html_output($_REQUEST['id']); ?>"><?PHP echo $username; ?></a></td>
<td width="25%">Payment Amount</td><td width="25%"><font color="green"><?PHP
$total_orig_amount = number_format($total_orig_amount,$decimal_symbols);
if($cur_sym_location == 1) { $total_orig_amount = $cur_sym . $total_orig_amount; }
if($cur_sym_location == 2) { $total_orig_amount = $total_orig_amount . " " . $cur_sym; }
$total_orig_amount = $total_orig_amount . " " . $currency;
?><?PHP echo $total_orig_amount; ?></font></td>
</tr>
<tr>
<td width="25%">Affiliate Name</td><td width="25%"><?PHP echo $name; ?></td>
<td width="25%">Minus Debit Amount</td><td width="25%"><?PHP
$total_debit_amount = number_format($total_debit_amount,$decimal_symbols);
if($cur_sym_location == 1) { $total_debit_amount = $cur_sym . $total_debit_amount; }
if($cur_sym_location == 2) { $total_debit_amount = $total_debit_amount . " " . $cur_sym; }
$total_debit_amount = $total_debit_amount . " " . $currency;
?><?PHP echo $total_debit_amount; ?></td>
</tr>

<tr>
<td width="25%">Tax ID/SSN/VAT</td><td width="25%"><?PHP echo $utax; ?></td>
<td width="25%">Total Payment Amount</td><td width="25%"><font color="#CC0000"><strong><?PHP
$total_amount = number_format($total_amount,$decimal_symbols);
if($cur_sym_location == 1) { $total_amount = $cur_sym . $total_amount; }
if($cur_sym_location == 2) { $total_amount = $total_amount . " " . $cur_sym; }
$total_amount = $total_amount . " " . $currency;
?><?PHP echo $total_amount; ?></strong></font></td>
</tr>

</tbody>
</table>
</div>
</div>

<?PHP
$check_for_data = $db->prepare("SELECT COUNT(id) FROM idevaff_debit_archive where payment_record = ?");
$check_for_data->execute(array($_REQUEST['date_selected']));
?>


<div class="tabbable tabbable-custom">
<ul class="nav nav-tabs">
<li><a <?php makeActiveTab(1);?> href="#tab_1_1" data-toggle="tab">Commissions In This Payment</a></li>
<?PHP if ($check_for_data->fetchColumn()) { ?><li <?php makeActiveTab(2);?>><a href="#tab_1_2" data-toggle="tab">Debits In This Payment</a></li><?PHP } ?>
</ul>

<div class="tab-content">

<div class="tab-pane<?php makeActiveTab(1, 'no');?>" id="tab_1_1">
<table class="table valign table-striped table-bordered table-highlight-head">
<thead>
<tr>
<th>Commission Date</th>
<th>Order Number</th>
<th>Commission Amount</th>
<th>Commissions Type</th>
<th>View Commission Record</th>
</tr>
</thead>
<tbody>

<?PHP
$details = $db->prepare("select * from idevaff_archive where payment_rec = ? and id = ?");
$details->execute(array($_REQUEST['date_selected'],$_REQUEST['id']));
if ($details->rowCount()) {
while ($qry = $details->fetch()) {
$comm_date = date($dateformat, $qry['code']);
$tracking_on = $qry['tracking'];
$rec_stamp = $qry['record'];
$payment = $qry['payment'];

if ($tracking_on == '') { $tracking_on = "N/A"; }

$listpay = number_format($payment,$decimal_symbols);
if($cur_sym_location == 1) { $listpay = $cur_sym . $listpay; }
if($cur_sym_location == 2) { $listpay = $listpay . " " . $cur_sym; }
$listpay = $listpay . " " . $currency;

if ($qry['bonus'] == 1) { $listtype = "Signup Bonus"; }
elseif ($qry['top_tier_tag'] == 1) { $listtype = "Tier"; }
elseif ($qry['override'] == 1) { $listtype = "Override"; }
elseif ($qry['top_tier_tag'] == 0) { $listtype = "Standard"; }
?>
<tr>
<td><?PHP echo $comm_date; ?></td>
<td><?PHP echo $tracking_on; ?></td>
<td><?PHP echo $listpay; ?></td>
<td><?PHP echo $listtype; ?></td>
<td><a href="commission_details.php?archive=<?PHP echo $rec_stamp; ?>"><button class="btn btn-primary btn-sm">View Commission Record</button></a></td>
</tr>
<?PHP } } ?>
</tbody>
</table>

</div>


<div class="tab-pane<?php makeActiveTab(2, 'no');?>" id="tab_1_2">
<table class="table valign table-striped table-bordered table-highlight-head">
<thead>
<th>Debit Date</th>
<th>Debit Reason</th>
<th>Debit Amount</th>
</thead>
<tbody>
<?PHP
$acctdeb = $db->prepare("select * from idevaff_debit_archive where payment_record = ? ORDER BY id");
$acctdeb->execute(array($_REQUEST['date_selected']));
while ($qry1 = $acctdeb->fetch()) {
$debitdate=date($dateformat, $qry1['code']);
$debitamt=$qry1['amount'];
$debitamtd = (number_format($debitamt,$decimal_symbols));
$debitreason = ${"debit_reason_" . $qry1['reason']};

?>
<tr>
<td><?PHP echo $debitdate; ?></td>
<td><?PHP echo $debitreason; ?></td>
<td><?PHP if ($cur_sym_location == 1) { echo $cur_sym; } echo $debitamtd; if($cur_sym_location == 2) { echo " " . $cur_sym . " "; } echo " " . $currency; ?></td>
</tr>
<?PHP } ?>
<tr>
<td style="color:#CC0000; text-align:right;" colspan="2">Total Debits</td>
<td style="color:#CC0000; font-weight:bold;"><?PHP echo $total_debit_amount; ?></td>
</tr>
</tbody>
</table>
</div>


</div>
</div>



<?PHP } include("templates/footer.php"); ?>
