<?PHP
include_once("../API/config.php");
include_once("includes/session.check.php");
require_once '../API/stripe/config.php';
$temp_fields = 'debit_reason_0,debit_reason_1,debit_reason_2,debit_reason_3,debit_reason_4,debit_reason_5';
extract(get_lang($temp_fields));
if (($staff_pay_affiliates == 'off') && (!isset($_SESSION[$install_directory_name.'_idev_AdminAccount']))) { header("Location: staff_notice.php"); exit(); }


// -----------------------------------------------------------
// Process Stripe Payment Here
// -----------------------------------------------------------

if(isset($_POST['process_stripe_payment'])) {
    //get total value

    $earnings = $db->prepare("select SUM(payment) AS total from idevaff_sales where id = ? and approved = '1'");
    $earnings->execute(array($_REQUEST['id']));
    $row1 =  $earnings->fetch();
    $pexact = $row1['total'];
    $pexactd = $pexact;

    $debittotal = $db->prepare("select SUM(amount) AS totaldebs from idevaff_debit where aff_id = ?");
    $debittotal->execute(array($_REQUEST['id']));
    $debit_total =  $debittotal->fetch();
    $pexacttotaldebs = $debit_total['totaldebs'];
    $pexacttotaldebsd = $pexacttotaldebs;

    $amount_to_pay_grand_total = $pexact - $pexacttotaldebs;
    //$amount_to_pay_grand_total = number_format($amount_to_pay_grand_total,$decimal_symbols);  

    if($amount_to_pay_grand_total > 0) {

        $amount = $amount_to_pay_grand_total * 100.0;
        //get customer id
        $StripeData=$db->prepare("select pay_method, stripe_user_data from idevaff_affiliates where id = ?");
        $StripeData->execute(array($_REQUEST['id']));
        $stripe_data = $StripeData->fetch();

        $stripe_data['stripe_user_data'] = $stripe_data['stripe_user_data'] ?? "";
        $stripe_data['pay_method'] = $stripe_data['pay_method'] ?? "";

        $stripe_user_data = unserialize(base64_decode($stripe_data['stripe_user_data']));
        $pay_method = $stripe_data['pay_method'];

        if($pay_method == 2 && $stripe_user_data['stripe_user_id'] != '') {
            $stripe_cus_id = $stripe_user_data['stripe_user_id'];
            //make payment
            try {
                \Stripe\Stripe::setApiKey(STRIPE_API_SECRET);
                $transfer_obj = \Stripe\Transfer::create(array(
                    'amount' => $amount,
                    'currency' => $currency,
                    //'currency' => "USD",
                    'destination' => $stripe_cus_id
                ));

                $transfer_obj = $transfer_obj->__toArray(true);
                //echo "<pre>"; print_r($transfer_obj); echo "</pre>";

                //retrive transfer object to get updated payment status:
                $get_transfer = \Stripe\Transfer::retrieve($transfer_obj['id']);
                $transfer_obj = $get_transfer->__toArray(true);

                $sent_amount = $transfer_obj['amount']/100;
                $payment_details = <<<EOD
                                    <strong>Transaction ID:</strong> {$transfer_obj['id']}<br />    
                                    <strong>Payment Status:</strong> {$transfer_obj['status']}<br />
									
EOD;

                $stripe_payment_success = "stripe_good";
                if(!isset($success_message))
                    $success_message = "";
                $success_message .= '<span style="font-size:18px; font-weight:bold;">Stripe Payment Successful</span><br />';
                $success_message .= '<strong>Payment Details: </strong>' . $payment_details;
                $fail_message = '<strong>IMPORTANT:</strong> Complete the payment process by clicking the <strong>Archive This Payment</strong> button in step #2, below.';

            }
            catch (Exception $e) {
                if(!isset($fail_message))
                    $fail_message = "";
                $fail_message = '<p>' .$e->getMessage() . '</p>';

            }
        }
    } else {
        if(!isset($fail_message))
            $fail_message = "";
        $fail_message = '<p>Negative Account Balance - Payment Not Available</p>';
    }
}

// -----------------------------------------------------------
// End Stripe Payment Method
// -----------------------------------------------------------


// -----------------------------------------------------------
// ARCHIVE COMMISIONS
// -----------------------------------------------------------
if (isset($_REQUEST['archive'])) {
    $st=$db->prepare("insert into idevaff_payments (id, code, amount) values (?, ?, ?)");
    $st->execute(array($_REQUEST['id'],$_REQUEST['sendcode'],$_REQUEST['amount']));

    AffiliatePayment($_SESSION[$install_directory_name.'_idev_LoggedAdmin'] . "|" . $ip_addr . "|" . "Success: Individual - Standard Method" . "|" . $_REQUEST['id'] . "|" . $_REQUEST['amount']);

// --------------------------------------------
// DEFINE POST BACK AND WEBHOOK VALUES
// --------------------------------------------

    $event = "payment_completed";
    $data_affiliate_id = $_REQUEST['id'];
    $data_amount = number_format($_REQUEST['amount'], $decimal_symbols);
    $data_currency = $currency;

// --------------------------------------------
// START WEBHOOK CALL
// --------------------------------------------

    include($path."/API/webhooks/webhook.php");

    $lastrec=$db->query("select max(record) as latest from idevaff_payments");
    $lastres=$lastrec->fetch();
    $lastres=$lastres['latest'];

    $q1 = $db->prepare("SELECT * FROM idevaff_sales WHERE id = ? and approved = '1'");
    $q1->execute(array($_REQUEST['id']));
    $number = $q1->rowCount();
    $count = 0;
    while ($count < $number) {
        $data=$q1->fetch();
        $geo = $data['geo'] == "" ? NULL : $data['geo'];
// -----------------------------------------------------------
// BUILD QUERY
// -----------------------------------------------------------

        $st = $db->prepare("INSERT INTO idevaff_archive (id,payment,top_tier_tag,bonus,ip,code,tracking,tier_id,op1,op2,op3,amount,type,split,profile,referring_url,sub_id,payment_rec,tid1,tid2,tid3,tid4,target_url,currency,converted_amount,override,override_id,geo,tracking_method,notes,email)
VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $st->execute( array( $data['id'],$data['payment'],$data['top_tier_tag'],$data['bonus'],$data['ip'],$data['code'],$data['tracking'],$data['tier_id'],$data['op1'],$data['op2'],$data['op3'],$data['amount'],$data['type'],$data['split'],$data['profile'], $data['referring_url'], $data['sub_id'], $lastres, $data['tid1'], $data['tid2'], $data['tid3'], $data['tid4'],$data['target_url'], $data['currency'], $data['converted_amount'], $data['override_id'], $data['override_id'], $geo, $data['tracking_method'], $data['notes'], $data['email']));
        $count = $count + 1; }

// MOVE DEBITS TO ARCHIVE
    $check_for_debits = $db->prepare("SELECT COUNT(id) FROM idevaff_debit where aff_id = ?");
    $check_for_debits->execute(array($_REQUEST['id']));
    if ($check_for_debits->fetchColumn()) {
        $debit_data = $db->prepare("SELECT * FROM idevaff_debit where aff_id = ?");
        $debit_data->execute(array($_REQUEST['id']));
        while ($debit_data_results = $debit_data->fetch()) {
            $st = $db->prepare("INSERT INTO idevaff_debit_archive (aff_id, amount, code, reason, payment_record) VALUES (?, ?, ?, ?, ?)");
            $st->execute(array($debit_data_results['aff_id'], $debit_data_results['amount'], $debit_data_results['code'], $debit_data_results['reason'], $lastres));

// --------------------------------------------
// DEFINE POST BACK AND WEBHOOK VALUES
// --------------------------------------------

            $debit_value = "debit_reason_".$debit_data_results['reason'];

            $event = "debit_settled";
            $data_affiliate_id = $debit_data_results['aff_id'];
            $data_amount = number_format($debit_data_results['amount'], $decimal_symbols);
            $data_reason = ${"debit_reason_".$debit_data_results['reason']};//$qry_name['corvette'];
            $data_timestamp = $debit_data_results['code'];

// --------------------------------------------
// START WEBHOOK CALL
// --------------------------------------------

            include($path."/API/webhooks/webhook.php");

        }
        $st=$db->prepare("delete from idevaff_debit where aff_id = ?");
        $st->execute(array($_REQUEST['id']));
    }


    if ($notify == 1) { $id = $_REQUEST['id']; include ($path . "/templates/email/affiliate.payment.php"); }

    $st=$db->prepare("delete from idevaff_sales where id = ? and approved = '1'");
    $st->execute(array($_REQUEST['id']));


    header("Location: pay_list.php?payment_complete=true");
}
// -----------------------------------------------------------
// END ARCHIVE
// -----------------------------------------------------------


$alldata=$db->prepare("select * from idevaff_affiliates where id = ?");
$alldata->execute(array($_REQUEST['id']));
$indv_data=$alldata->fetch();
$uname=$indv_data['username'] ?? "";
$upass=$indv_data['password'] ?? "";
$payto=$indv_data['payable'] ?? "";
$company=$indv_data['company'] ?? "";
$ufname=$indv_data['f_name'] ?? "";
$ulname=$indv_data['l_name'] ?? "";
$uemail=$indv_data['email'] ?? "";
$ad1=$indv_data['address_1'] ?? "";
$ad2=$indv_data['address_2'] ?? "";
$c=$indv_data['city'] ?? "";
$s=$indv_data['state'] ?? "";
$z=$indv_data['zip'] ?? "";
$coun=$indv_data['country'] ?? "";
$phone=$indv_data['phone'] ?? "";
$fax=$indv_data['fax'] ?? "";
$url=$indv_data['url'] ?? "";
$pp=$indv_data['pp'] ?? "";
$paypal=$indv_data['paypal'] ?? "";
$stripe_user_data=$indv_data['stripe_user_data'] ?? "";
$hits=$indv_data['hits_in'] ?? "";

$get_country_name = $db->prepare("select country_name from idevaff_countries where country_code = ?");
$get_country_name->execute(array($coun));
$get_country_data = $get_country_name->fetch();
$coun = $get_country_data['country_name'] ?? "";

$get_tax = $db->prepare("SELECT AES_DECRYPT(tax_id_ssn, '" . AUTH_KEY . "') AS decrypted FROM idevaff_affiliates where id = ?");
$get_tax->execute(array($_REQUEST['id']));
$get_tax = $get_tax->fetch();
$utax = $get_tax['decrypted'] ?? "";

$sales = $db->prepare("select record from idevaff_sales where approved = '1' and top_tier_tag = '0' and id = ?");
$sales->execute(array($_REQUEST['id']));
$sales = $sales->rowCount();

$tsales = $db->prepare("select record from idevaff_sales where approved = '1' and top_tier_tag = '1' and id = ?");
$tsales->execute(array($_REQUEST['id']));
$tsales = $tsales->rowCount();

$osales = $db->prepare("select record from idevaff_sales where approved = '1' and override = '1' and id = ?");
$osales->execute(array($_REQUEST['id']));
$osales = $osales->rowCount();

$earnings2 = $db->prepare("select SUM(payment) AS total from idevaff_sales where id = ? and approved = '1'");
$earnings2->execute(array($_REQUEST['id']));
$row2 =  $earnings2->fetch();
$pexact = $row2['total'];
$pexactd = $pexact;

$debittotal = $db->prepare("select SUM(amount) AS totaldebs from idevaff_debit where aff_id = ?");
$debittotal->execute(array($_REQUEST['id']));
$debit_total =  $debittotal->fetch();
$pexacttotaldebs = $debit_total['totaldebs'];
$pexacttotaldebsd = $pexacttotaldebs;

$amount_to_pay_grand_total = $pexact - $pexacttotaldebs;
//$amount_to_pay_grand_total = $amount_to_pay_grand_total;

if (!$payto) { $payto = "$ufname $ulname"; }
$leftSubActiveMenu = 'commissions';
include("templates/header.php");
?>

    <div class="crumbs">
        <ul id="breadcrumbs" class="breadcrumb">
            <li><i class="icon-home"></i> <a href="dashboard.php">Dashboard</a></li>
            <li> Pay Affiliates</li>
            <li class="current"> <a href="pay_affiliates.php?id=<?PHP echo html_output($_REQUEST['id']); ?>">Affiliate Payment</a></li>
        </ul>
        <?PHP include("templates/crumb_right.php"); ?>
    </div>

    <div class="page-header">
        <div class="page-title"><h3>Affiliate Payment</h3><span>Individual Payment: Standard Method</span></div>
        <?PHP include("templates/stats.php"); ?>
    </div>

<?PHP include("includes/notifications.php"); ?>

<?PHP
$check_for_data = $db->prepare("SELECT COUNT(id) FROM idevaff_debit where aff_id = ?");
$check_for_data->execute(array($_REQUEST['id']));
?>


    <div class="tabbable tabbable-custom">
        <ul class="nav nav-tabs">
            <li><a <?php makeActiveTab(1);?> href="#tab_1_1" data-toggle="tab">Payment</a></li>
            <li><a <?php makeActiveTab(2);?> href="#tab_1_2" data-toggle="tab">Commissions In This Payment</a></li>
            <?PHP if ($check_for_data->fetchColumn()) { ?><li <?php makeActiveTab(25);?>><a href="#tab_1_25" data-toggle="tab">Debits In This Payment</a></li><?PHP } ?>
            <li><a <?php makeActiveTab(3);?> href="#tab_1_3" data-toggle="tab">Custom Fields</a></li>
        </ul>

        <div class="tab-content">

            <div class="tab-pane<?php makeActiveTab(1, 'no');?>" id="tab_1_1">

                <div class="col-md-12">
                    <div class="widget box" style="margin-top:20px;">
                        <div class="widget-header"<?PHP if ($amount_to_pay_grand_total <= 0) { ?> style="background:#CC0000; color:#FFFFFF; font-weight:bold;"<?PHP } ?>>
<span class="pull-left">
<?PHP if ($amount_to_pay_grand_total > 0) { ?>
    <a href="invoice.php?id=<?PHP echo html_output($_REQUEST['id']); ?>" target="_blank"><button class="btn btn-danger btn-sm">Print Invoice</button></a>
    <a href="invoice_pdf.php?id=<?PHP echo html_output($_REQUEST['id']); ?>" target="_blank"><button class="btn btn-danger btn-sm">PDF Invoice</button></a>
<?PHP } else { ?>
    Negative Account Balance - Payment Not Available
<?PHP } ?>
</span>
                            <?PHP if ($amount_to_pay_grand_total > 0) { ?>
                                <span class="pull-right">
<a href="setup.php?action=1&tab=3" class="btn btn-sm btn-default">Adjust Invoice Settings</a>
</span>
                            <?PHP } ?>
                        </div>
                        <div class="widget-content">
                            <table class="table valign table-striped table-bordered table-highlight-head">
                                <tbody>
                                <tr>
                                    <td>Affiliate ID</td>
                                    <td><?PHP echo html_output($_REQUEST['id']); ?></td>
                                    <td>Company</td>
                                    <td><?PHP if ($company) { echo $company; } else { echo "N/A"; } ?></td>
                                </tr>
                                <tr>
                                    <td>Username</td>
                                    <td><a href="account_details.php?id=<?PHP echo html_output($_REQUEST['id']); ?>"><?PHP echo $uname; ?></a></td>
                                    <td>Commissions</td>
                                    <td><?PHP echo (number_format($sales, 0)); ?></td>
                                </tr>
                                <tr>
                                    <td>Full Name</td>
                                    <td><?PHP echo $ufname; ?> <?PHP echo $ulname; ?></td>
                                    <td>Tier Commissions</td>
                                    <td><?PHP echo (number_format($tsales, 0)); ?></td>
                                </tr>
                                <tr>
                                    <td>Phone Number</td>
                                    <td><?PHP echo $phone; ?></td>
                                    <td>Override Commissions</td>
                                    <td><?PHP echo (number_format($osales, 0)); ?></td>
                                </tr>
                                <tr>
                                    <td>Fax Number</td>
                                    <td><?PHP echo $fax; ?></td>
                                    <td>Payment Amount</td>
                                    <td><font color="green"><b><?PHP if($cur_sym_location == 1) { echo $cur_sym; } echo number_format($pexactd,$decimal_symbols); if ($cur_sym_location == 2) { echo " " . $cur_sym . " "; } echo " " . $currency; ?></b></font></td>
                                </tr>
                                <tr>
                                    <td>Tax ID, SSN or VAT</td>
                                    <td><?PHP echo $utax?></td>
                                    <td>Total Debits</td>
                                    <td><?PHP if ($pexacttotaldebs > 0) { ?><font color="#CC0000"><?PHP } ?><?PHP if ($cur_sym_location == 1) { echo $cur_sym; } echo number_format($pexacttotaldebsd,$decimal_symbols); if($cur_sym_location == 2) { echo " " . $cur_sym . " "; } echo " " . $currency; ?><?PHP if ($pexacttotaldebs > 0) { ?></font><?PHP } ?></td>
                                </tr>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <?PHP
                $alldata_pay=$db->prepare("select pay_method from idevaff_affiliates where id = ?");
                $alldata_pay->execute(array($_REQUEST['id']));
                $indv_data_pay=$alldata_pay->fetch();
                $getpayid=$indv_data_pay['pay_method'] ?? "";

                $getpayname=$db->prepare("select name from idevaff_payment_methods where id = ?");
                $getpayname->execute(array($getpayid));
                $getpayname_result=$getpayname->fetch();
                $getpayname_result=$getpayname_result['name'] ?? "";
                ?>

                <div class="col-md-12">
                    <div class="widget box">
                        <div class="widget-header"><h4><i class="icon-money"></i> <font color="#CC0000">Step 1:</font> Complete The Payment - <font color="#000000"><?PHP echo $getpayname_result; ?></font> [<a href="account_details.php?id=<?PHP echo html_output($_REQUEST['id']); ?>&tab=3">edit</a>]</h4></div>
                        <div class="widget-content">

                            <?PHP
                            if ($getpayid != '0') {
                                if ($getpayid == '1') {
                                    if ($paypal != '') {
                                        ?>

                                        <?PHP if ($pexacttotaldebs > 0) { ?>
                                            <!--<div class="alert alert-danger"><h4>Important Notice!</h4>This account has a debit on it. <?PHP if ($cur_sym_location == 1) { echo $cur_sym; } echo number_format($pexacttotaldebsd,$decimal_symbols); if($cur_sym_location == 2) { echo " " . $cur_sym . " "; } echo " " . $currency; ?> will be deducted from this payment.</div>-->
                                        <?PHP } ?>

                                        <?PHP if ($amount_to_pay_grand_total > 0) { ?>
                                            <div class="alert alert-info">After sending payment to your affiliate, click the <strong>Archive This Payment</strong> button in step #2, below.</div>
                                        <?PHP } ?>
                                        <form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_blank">
                                            <input name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>" type="hidden" />
                                            <input type="hidden" name="currency_code" value="<?PHP echo $currency; ?>">
                                            <input type="hidden" name="no_note" value="1">
                                            <input type="hidden" name="amount" value="<?PHP echo number_format($amount_to_pay_grand_total, $decimal_symbols, '.', ''); ?>">
                                            <input type="hidden" name="item_number" value="Affiliate_Payment_<?PHP echo $cdate; ?>">
                                            <input type="hidden" name="item_name" value="<?PHP echo $sitename; ?> Affiliate Payment">
                                            <input type="hidden" name="business" value="<?PHP echo $paypal; ?>">
                                            <input type="hidden" name="cmd" value="_xclick">
                                            <table class="table table-bordered">
                                                <tbody>
                                                <tr>
                                                    <td width="25%">Payment Amount</td>
                                                    <td width="75%"><font color="green"><?PHP if($cur_sym_location == 1) { echo $cur_sym; } echo number_format($pexactd,$decimal_symbols); if($cur_sym_location == 2) { echo " " . $cur_sym . " "; }echo " $currency"; ?></font></td>
                                                </tr>
                                                <?PHP if ($pexacttotaldebs > 0) { ?>
                                                    <tr>
                                                        <td width="25%">Minus Debit Amount</td>
                                                        <td width="75%"><?PHP if ($cur_sym_location == 1) { echo $cur_sym; } echo number_format($pexacttotaldebsd,$decimal_symbols); if($cur_sym_location == 2) { echo " " . $cur_sym . " "; } echo " " . $currency; ?></td>
                                                    </tr>
                                                    <tr>
                                                        <td><font color="#CC0000"><b>Total Amount To Pay</b></font></td>
                                                        <td><font color="#CC0000"><b><?PHP if ($cur_sym_location == 1) { echo $cur_sym; } echo number_format($amount_to_pay_grand_total,$decimal_symbols); if($cur_sym_location == 2) { echo " " . $cur_sym . " "; } echo " " . $currency; ?></b></font></td>
                                                    </tr>
                                                <?PHP } ?>
                                                <tr>
                                                    <td width="25%">Affiliate's <?PHP echo $getpayname_result; ?> Account</td>
                                                    <td width="75%"><?PHP echo $paypal; ?></td>
                                                </tr>
                                                <tr>
                                                    <td rowspan="2" colspan="2">
                                                        <?PHP if ($amount_to_pay_grand_total > 0) { ?>
                                                            <button class="btn btn-primary btn-lg">Make <?PHP echo $getpayname_result; ?> Payment</button>
                                                        <?PHP } else { ?>
                                                            <button class="btn btn-danger btn-lg" disabled>Negative Account Balance - Payment Not Available</button>
                                                        <?PHP } ?>
                                                    </td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </form>
                                    <?PHP } else { $nopaymentmethod = true; ?>
                                        <div class="alert alert-danger"><span style="font-size:26px;">ERROR - PAYMENT CANNOT BE COMPLETED!</span><br />This affiliate is set to receive a <?PHP echo $getpayname_result; ?> payment but does not have a <?PHP echo $getpayname_result; ?> account added to their affiliate account. Please add a <?PHP echo $getpayname_result; ?> account for this affiliate before making payment.<br /><br /><a class="btn btn-danger" href="account_details.php?id=<?PHP echo html_output($_REQUEST['id']); ?>&tab=3">Add <?PHP echo $getpayname_result; ?> Account Now</a></div>

                                        <?PHP
                                    } } elseif ($getpayid == '2') {
                                    $stripe_user_data = unserialize(base64_decode($indv_data['stripe_user_data']));
                                    if(is_array($stripe_user_data) && !empty($stripe_user_data) && $stripe_user_data['access_token'] != '') {
                                        if(isset($stripe_payment_success) && $stripe_payment_success == 'stripe_good') {
                                            ?>
                                            <strong>Stripe payment successful.</strong> Click the <strong>Archive This Payment</strong> button in step #2, below.

                                        <?php } else {
//if($amount_to_pay_grand_total > 0) {
                                            ?>

                                            <div class="alert alert-info">After sending payment to your affiliate, click the <strong>Archive This Payment</strong> button in step #2, below.</div>
                                            <div class="well">
                                                <?php
                                                \Stripe\Stripe::setApiKey(STRIPE_API_SECRET);

                                                try {

                                                    $stripe_balance = \Stripe\Balance::retrieve();

                                                } catch (\Stripe\Exception\ApiErrorException $e) {

                                                }

                                                if($stripe_balance!=null){
                                                    $stripe_balance = $stripe_balance->__toArray(true);
                                                }

                                                // $stripe_balance = $stripe_balance->__toArray(true);
                                                //        $stripe_balance = $stripe_balance->toArray();
                                                //        echo '<pre>'; var_dump($stripe_balance); echo '</pre>';
                                                if($stripe_balance['livemode'])
                                                    $stripe_balance['livemode'] = 'Enabled';
                                                else
                                                    $stripe_balance['livemode'] = 'Disabled';
                                                //echo "<pre>"; print_r($stripe_balance); echo "</pre>";

                                                $stripe_balance_available_amount = 0;
                                                $stripe_balance_available_currency = '';
                                                if( isset($stripe_balance['available'][1]) ) {
                                                    $stripe_balance_available_amount = $stripe_balance['available'][1]['amount'] / 100;
                                                    $stripe_balance_available_currency  = $stripe_balance['available'][1]['currency'];
                                                }
                                                else if( isset($stripe_balance['available'][0]) ) {
                                                    $stripe_balance_available_amount = $stripe_balance['available'][0]['amount'] / 100;
                                                    $stripe_balance_available_currency  = $stripe_balance['available'][0]['currency'];
                                                }

                                                $stripe_balance_pending_amount = 0;
                                                $stripe_balance_pending_currency = '';
                                                if( isset($stripe_balance['pending'][0]) ) {
                                                    $stripe_balance_pending_amount = $stripe_balance['pending'][0]['amount'] / 100;
                                                    $stripe_balance_pending_currency = $stripe_balance['pending'][0]['currency'];
                                                }
                                                ?>
                                                <span style="font-weight:bold; font-size:18px;">Stripe Account Details</span><br />
                                                <strong>Live Mode: </strong>    <?php echo $stripe_balance['livemode']; ?> <br>
                                                <!--<strong>Pending Balance: </strong> <?php echo $stripe_balance_pending_amount . ' ' . strtoupper($stripe_balance_pending_currency); ?> <br>-->
                                                <strong>Available Balance: </strong>  <?php echo $stripe_balance_available_amount; if ($stripe_balance_available_amount > 0) { echo " " . strtoupper($stripe_balance_available_currency); } ?>
                                            </div>


                                            <form action="pay_affiliates.php" method="post">
                                                <input name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>" type="hidden" />
                                                <input type="hidden" name="process_stripe_payment" value="1" />
                                                <input type="hidden" name="id" value="<?PHP echo html_output($_REQUEST['id']); ?>">


                                                <table class="table table-bordered">
                                                    <tbody>
                                                    <tr>
                                                        <td width="25%">Payment Amount</td>
                                                        <td width="75%"><font color="green"><?PHP if($cur_sym_location == 1) { echo $cur_sym; } echo number_format($pexactd,$decimal_symbols); if($cur_sym_location == 2) { echo " " . $cur_sym . " "; }echo " $currency"; ?></font></td>
                                                    </tr>
                                                    <?PHP if ($pexacttotaldebs > 0) { ?>
                                                        <tr>
                                                            <td width="25%">Minus Debit Amount</td>
                                                            <td width="75%"><?PHP if ($cur_sym_location == 1) { echo $cur_sym; } echo number_format($pexacttotaldebsd,$decimal_symbols); if($cur_sym_location == 2) { echo " " . $cur_sym . " "; } echo " " . $currency; ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td><font color="#CC0000"><b>Total Amount To Pay</b></font></td>
                                                            <td><font color="#CC0000"><b><?PHP if ($cur_sym_location == 1) { echo $cur_sym; } echo number_format($amount_to_pay_grand_total,$decimal_symbols); if($cur_sym_location == 2) { echo " " . $cur_sym . " "; } echo " " . $currency; ?></b></font></td>
                                                        </tr>
                                                    <?PHP } ?>
                                                    <tr>
                                                        <td width="25%">Affiliate's <?PHP echo $getpayname_result; ?> Account</td>
                                                        <td width="75%"><?PHP echo $stripe_user_data['stripe_user_id']; ?></td>
                                                    </tr>
                                                    <tr>
                                                        <td rowspan="2" colspan="2">
                                                            <?PHP if ($amount_to_pay_grand_total > 0) { ?>
                                                                <button class="btn btn-primary btn-lg">Make <?PHP echo $getpayname_result; ?> Payment</button>
                                                            <?PHP } else { ?>
                                                                <button class="btn btn-danger btn-lg" disabled>Negative Account Balance - Payment Not Available</button>
                                                            <?PHP } ?>
                                                        </td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                            </form>
                                            <?php
//} elseif($amount_to_pay_grand_total <= 0) {
                                            ?>
                                            <!--<h2>Negative Account Balance - Payment Not Available</h2>-->
                                            <?PHP //} ?>

                                        <?php }?>
                                    <?PHP } else { $nopaymentmethod = true; ?>
                                        <div class="alert alert-danger"><span style="font-size:26px;">ERROR - PAYMENT CANNOT BE COMPLETED!</span><br />This affiliate is set to receive a <?PHP echo $getpayname_result; ?> payment but does not have a valid <?PHP echo $getpayname_result; ?> account added to their affiliate account. Please add a <?PHP echo $getpayname_result; ?> account for this affiliate before making payment.<br /><br /><a class="btn btn-danger" href="account_details.php?id=<?PHP echo html_output($_REQUEST['id']); ?>&tab=3">Add <?PHP echo $getpayname_result; ?> Account Now</a></div>

                                    <?PHP } } elseif ($getpayid == '4') { ?>

                                    <?PHP if ($amount_to_pay_grand_total > 0) { ?>
                                        <div class="alert alert-info">After sending payment to your affiliate, click the <strong>Archive This Payment</strong> button in step #2, below.</div>
                                    <?PHP } ?>

                                    <table class="table table-bordered">
                                        <tbody>
                                        <tr>
                                            <td width="25%">Payment Amount</td>
                                            <td width="75%"><font color="green"><?PHP if($cur_sym_location == 1) { echo $cur_sym; } echo number_format($pexactd,$decimal_symbols); if($cur_sym_location == 2) { echo " " . $cur_sym . " "; }echo " $currency"; ?></font></td>
                                        </tr>
                                        <?PHP if ($pexacttotaldebs > 0) { ?>
                                            <tr>
                                                <td width="25%">Minus Debit Amount</td>
                                                <td width="75%"><?PHP if ($cur_sym_location == 1) { echo $cur_sym; } echo number_format($pexacttotaldebsd,$decimal_symbols); if($cur_sym_location == 2) { echo " " . $cur_sym . " "; } echo " " . $currency; ?></td>
                                            </tr>
                                            <tr>
                                                <td><font color="#CC0000"><b>Total Amount To Pay</b></font></td>
                                                <td><font color="#CC0000"><b><?PHP if ($cur_sym_location == 1) { echo $cur_sym; } echo number_format($amount_to_pay_grand_total,$decimal_symbols); if($cur_sym_location == 2) { echo " " . $cur_sym . " "; } echo " " . $currency; ?></b></font></td>
                                            </tr>
                                        <?PHP } ?>
                                        </tbody>
                                    </table>

                                    <table class="table table-striped table-bordered table-highlight-head">
                                        <tbody>
                                        <tr>
                                            <td>Payable To: <?PHP echo $payto; ?></td>
                                        </tr>
                                        <tr>
                                            <td><?PHP echo $ad1; ?></td>
                                        </tr>
                                        <tr>
                                            <td><?PHP if ($ad2) { ?><?PHP echo $ad2; ?><?PHP } else { ?><?PHP echo $c; ?>, <?PHP echo $s; ?> <?PHP echo $z; ?> - <?PHP echo $coun; ?><?PHP } ?></td>
                                        </tr>
                                        <?PHP if ($ad2) { ?><tr><td><?PHP echo $c; ?>, <?PHP echo $s; ?> <?PHP echo $z; ?> - <?PHP echo $coun; ?></td></tr><?PHP } ?>
                                        </tbody>
                                    </table>

                                    <?PHP
                                } elseif (($getpayid == '3') || ($getpayid > '4')) { ?>

                                    <?PHP if ($amount_to_pay_grand_total > 0) { ?>
                                        <div class="alert alert-info">After completing payment, or other compensation for your affiliate, click the <strong>Archive This Payment</strong> button in step #2, below.</div>
                                    <?PHP } ?>

                                    <table class="table table-bordered">
                                        <tbody>
                                        <tr>
                                            <td width="25%">Payment Amount</td>
                                            <td width="75%"><font color="green"><?PHP if($cur_sym_location == 1) { echo $cur_sym; } echo number_format($pexactd,$decimal_symbols); if($cur_sym_location == 2) { echo " " . $cur_sym . " "; }echo " $currency"; ?></font></td>
                                        </tr>
                                        <?PHP if ($pexacttotaldebs > 0) { ?>
                                            <tr>
                                                <td width="25%">Minus Debit Amount</td>
                                                <td width="75%"><?PHP if ($cur_sym_location == 1) { echo $cur_sym; } echo number_format($pexacttotaldebsd,$decimal_symbols); if($cur_sym_location == 2) { echo " " . $cur_sym . " "; } echo " " . $currency; ?></td>
                                            </tr>
                                            <tr>
                                                <td><font color="#CC0000"><b>Total Amount To Pay</b></font></td>
                                                <td><font color="#CC0000"><b><?PHP if ($cur_sym_location == 1) { echo $cur_sym; } echo number_format($amount_to_pay_grand_total,$decimal_symbols); if($cur_sym_location == 2) { echo " " . $cur_sym . " "; } echo " " . $currency; ?></b></font></td>
                                            </tr>
                                        <?PHP } ?>
                                        </tbody>
                                    </table>

                                <?PHP } } else { $nopaymentmethod = true; ?>
                                <div class="alert alert-danger"><span style="font-size:26px;">ERROR - PAYMENT CANNOT BE COMPLETED!</span><br />This affiliate does not have a payment method selected. Please add a payment method for this account.<br /><br /><a class="btn btn-danger" href="account_details.php?id=<?PHP echo html_output($_REQUEST['id']); ?>&tab=3">Add Payment Method Now</a></div>
                            <?PHP } ?>

                        </div>
                    </div>
                </div>

                <?PHP if (!isset($nopaymentmethod)) { ?>

                    <?PHP if ($amount_to_pay_grand_total > 0) { ?>
                        <div class="col-md-12">
                            <div class="widget box">
                                <div class="widget-header"><h4><i class="icon-money"></i> <font color="#CC0000">Step 2:</font> Archive The Payment</h4></div>
                                <div class="widget-content">
                                    <div class="alert alert-danger">After you've sent the payment to the affiliate in step #1 (above), click the button below to archive the payment. This moves all commissions from this payment to the archive with a <strong>paid</strong> status.</div>
                                    <form class="stdform stdform2" method="post" action="pay_affiliates.php">
                                        <input name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>" type="hidden" />
                                        <input type="hidden" name="archive" value="1">
                                        <input type="hidden" name="id" value="<?PHP echo html_output($_REQUEST['id']); ?>">
                                        <input type="hidden" name="amount" value="<?PHP echo number_format($amount_to_pay_grand_total, $decimal_symbols, '.', ''); ?>">
                                        <input type="hidden" name="sendcode" value="<?PHP echo time(); ?>">
                                        <button class="btn btn-primary btn-lg">Archive This Payment</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    <?PHP } ?>

                <?PHP } ?>

            </div>

            <div class="tab-pane<?php makeActiveTab(2, 'no');?>" id="tab_1_2">
                <div class="col-md-12">
                    <div class="widget box" style="margin-top:20px;">
                        <div class="widget-header"><h4><i class="icon-money"></i> Commissions In This Payment</h4></div>
                        <div class="widget-content">
                            <table class="table valign table-striped table-bordered table-highlight-head">
                                <thead>
                                <th>Commission Date</th>
                                <th>Commission Type</th>
                                <th>Order Number</th>
                                <th>Commission Amount</th>
                                </thead>
                                <tbody>
                                <?PHP
                                $acct = $db->prepare("select * from idevaff_sales where id = ? and approved = '1' and type != '3' ORDER BY record DESC");
                                $acct->execute(array($_REQUEST['id']));
                                while ($qry = $acct->fetch()) {
                                    $indidate=date($dateformat, $qry['code']);
                                    $indiamt=$qry['payment'];
                                    $indiamtd = (number_format($indiamt,$decimal_symbols));
                                    $stat1=$qry['top_tier_tag'];
                                    $stat2=$qry['bonus'];
                                    $stat4=$qry['override'];
                                    $ordnum=$qry['tracking'];
                                    if (!$ordnum) { $ordnum = "N/A"; }
                                    if ($stat1 == 1) { $put = "<font color=\"#CC0000\">Tier Commission</font>"; }
                                    elseif ($stat4 == 1) { $put = "<b>Override Commission</b>"; }
                                    elseif ($stat2 == 1) { $put = "<b>Bonus Commission</b>"; }
                                    else { $put = 'Standard Commission'; }
                                    ?>
                                    <tr>
                                        <td><?PHP echo $indidate; ?></td>
                                        <td><?PHP echo $put; ?></td>
                                        <td><?PHP echo $ordnum; ?></td>
                                        <td><?PHP if ($cur_sym_location == 1) { echo $cur_sym; } echo $indiamtd; if($cur_sym_location == 2) { echo " " . $cur_sym . " "; } echo " " . $currency; ?></td>
                                    </tr>
                                <?PHP } ?>
                                <tr>
                                    <td style="color:#CC0000;">PPC Commissions Do Not Appear In This List</td>
                                    <td></td>
                                    <td style="color:#CC0000; text-align:right;">Total Commissions</td>
                                    <td style="color:#CC0000; font-weight:bold;"><?PHP if ($cur_sym_location == 1) { echo $cur_sym; } echo number_format($pexact,$decimal_symbols); if($cur_sym_location == 2) { echo " " . $cur_sym . " "; } echo " " . $currency; ?></td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="tab-pane<?php makeActiveTab(25, 'no');?>" id="tab_1_25">
                <div class="col-md-12">
                    <div class="widget box" style="margin-top:20px;">
                        <div class="widget-header"><h4><i class="icon-money"></i> Debits In This Payment</h4></div>
                        <div class="widget-content">
                            <table class="table valign table-striped table-bordered table-highlight-head">
                                <thead>
                                <th>Debit Date</th>
                                <th>Debit Reason</th>
                                <th>Debit Amount</th>
                                </thead>
                                <tbody>
                                <?PHP
                                $acctdeb = $db->prepare("select * from idevaff_debit where aff_id = ? ORDER BY id");
                                $acctdeb->execute(array($_REQUEST['id']));
                                while ($qry1 = $acctdeb->fetch()) {
                                    $debitdate=date($dateformat, $qry1['code']);
                                    $debitamt=$qry1['amount'];
                                    $debitamtd = (number_format($debitamt,$decimal_symbols));
                                    $debitreason = ${"debit_reason_" . $qry1['reason']};

                                    ?>
                                    <tr>
                                        <td><?PHP echo $debitdate; ?></td>
                                        <td><?PHP echo $debitreason; ?></td>
                                        <td><?PHP if ($cur_sym_location == 1) { echo $cur_sym; } echo $debitamtd; if($cur_sym_location == 2) { echo " " . $cur_sym . " "; } echo " " . $currency; ?></td>
                                    </tr>
                                <?PHP } ?>
                                <tr>
                                    <td style="color:#CC0000; text-align:right;" colspan="2">Total Debits</td>
                                    <td style="color:#CC0000; font-weight:bold;"><?PHP if ($cur_sym_location == 1) { echo $cur_sym; } echo number_format($pexacttotaldebsd,$decimal_symbols); if($cur_sym_location == 2) { echo " " . $cur_sym . " "; } echo " " . $currency; ?></td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="tab-pane<?php makeActiveTab(3, 'no');?>" id="tab_1_3">
                <div class="col-md-12">
                    <div class="widget box" style="margin-top:20px;">
                        <div class="widget-header"><h4><i class="icon-file-text-alt"></i> Custom Fields</h4></div>
                        <div class="widget-content">
                            <?PHP
                            $getcustomrows = $db->query("select id, title from idevaff_form_fields_custom where display_payment = '1' order by sort");
                            if ($getcustomrows->rowCount()) {
                                while ($qry = $getcustomrows->fetch()) {
                                    $group_id = $qry['id'];
                                    $custom_title = $qry['title'];
                                    $getvars = $db->prepare("select custom_value from idevaff_form_custom_data where custom_id = ? and affid = ?");
                                    $getvars->execute(array($group_id,$_REQUEST['id']));
                                    $getvars = $getvars->fetch();
                                    $custom_value = $getvars['custom_value'] ?? "";
                                    if ($custom_value == null) { $custom_value = "N/A"; }
                                    ?>
                                    <h4><?PHP echo $custom_title; ?></h4>
                                    <?PHP echo $custom_value; ?><br /><br />

                                <?PHP } } else { ?>
                                No custom field answers have been set to display on the payment page.
                            <?PHP } ?>
                        </div>
                    </div>
                </div>
            </div>




        </div>
    </div>







<?PHP include("templates/footer.php"); ?>