<?PHP
include_once("../API/config.php");
include_once("includes/session.check.php");

if (($staff_app_dec_commissions == 'off') && (!isset($_SESSION[$install_directory_name . '_idev_AdminAccount']))) {
    header("Location: staff_notice.php");
    exit();
}

if (isset($_POST['delete'])) {
    $st = $db->prepare("delete from idevaff_general_leads where id = ?");
    $st->execute(array($_POST['delete']));
    $success_message = "<strong>Success!</strong> Lead has been deleted.";
}

$leftSubActiveMenu = 'reports';
include("templates/header.php");

$leads_exist = $db->query("SELECT COUNT(id) FROM idevaff_general_leads");

?>
    <div class="crumbs">
        <ul id="breadcrumbs" class="breadcrumb">
            <li><i class="icon-home"></i> <a href="dashboard.php">Dashboard</a></li>
            <li> Commissions</li>
            <li class="current"><a href="leads.php">Leads Generated</a></li>
        </ul>
        <?PHP include("templates/crumb_right.php"); ?>
    </div>

    <div class="page-header">
        <div class="page-title"><h3>Leads Generated</h3><span>Review all the leads created by your affiliates.</span>
        </div>
        <?PHP include("templates/stats.php"); ?>
    </div>

<?PHP include("includes/notifications.php"); ?>


<?PHP if ($leads_exist->fetchColumn()) { ?>


    <div class="widget box">
        <div class="widget-header">
            <div class="d-flex align-items-center justify-content-between">
                <h4><i class="icon-money"></i> Leads Generated</h4>
                <span>
                    <div class="btn-group">
                          
                          <a href="csv_export.php?data=leads_export" class="btn btn-success btn-sm export-btn" type="button">
                           Export to CSV
                          </a>
                           <button type="button" class="btn btn-sm btn-success dropdown-toggle dropdown-toggle-split pl-2 pr-1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <span class="sr-only">Toggle Dropdown</span>
                          </button>
                          <div class="dropdown-menu py-0" style="min-width: 140px;">
                            <a class="dropdown-item date-range" href="#">Date Range</a>
                          </div>
                          
                    </div>
                    
                </span>
            </div>
            <div class="date-range-div" style="display:none;width: 450px;margin-left: auto;">
                        <form id="export-date-range-form" class="d-flex align-items-center justify-content-between">
                            
                            <div class="form-group">
                                <label>From Date</label>    
                                <input type="date" name="from_date" required class="form-control"/>
                            </div>
                            
                            <div class="form-group">
                                <label>To Date</label>    
                                <input type="date" name="to_date" required class="form-control"/>
                            </div>
                            
                            <div class="form-group">
                                <br>
                                <input type="submit" value="Filter & Export" class="btn btn-success btn-sm"/>
                            </div>
                            
                        </form>
                    </div>
        </div>
        <div class="widget-content">
                <table style="margin-top:0;" class="table table-striped table-bordered table-highlight-head valign" id="dyntable_leads">
                    <thead>
                    <tr>
                        <th>Affiliate ID</th>
                        <th>Username</th>
                        <th>Date</th>
                        <th>Time</th>
                        <th>Country</th>
                        <th>Lead ID</th>
                        <!--<th>Lead Value</th>-->
                        <!--<th>Customer Name</th>-->
                        <!--<th>Customer Email</th>-->
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
        </div>
    </div>



<?PHP } else { ?>

    <div class="widget box" style="margin-top:20px;">
        <div class="widget-header"><h4><i class="icon-picture"></i> Leads Generated</h4></div>
        <div class="widget-content">
            No leads to display.
        </div>
    </div>

<?PHP } ?>

<?PHP include("templates/footer.php"); ?>
<script>
    $(document).on('click','.date-range',function(){
        $(".date-range-div").slideToggle(300);
    });
    
    $("#export-date-range-form").submit(function(e){
        e.preventDefault();
        var from_date = $("input[name='from_date']").val();
        var to_date = $("input[name='to_date']").val();
        var filter = 1;
        window.location.href="csv_export.php?data=leads_export&from_date="+from_date+"&to_date="+to_date+"&filter=1";
        return false;
    });
</script>