<?PHP
if (!defined('admin_includes')) { die(); }
include("session.check.php");

$seo_key = 0;
$hturl = str_replace(".", "\.", $base_url);
$redirect_write = "redirect";
if ($redirect_method == '301') { $redirect_write = "permanent"; }
?>

<div class="col-md-12">

    <div class="bs-callout bs-callout-notes">
        <h4><img src="images/help-notes.png" height="48" width="48" border="none;" /> Operating System: NGINX Rewrite</h4>
        <p>This platform requires the following server configuration.</p>
        <ol class="list-ordered">
            <li>UNIX/Linux web hosting account.</li>
            <li>NGINX web server running.</li>
            <li>Ability to edit the NGINX configuration file.</li>
        </ol>
    </div>

    <div class="widget box" style="margin-top:20px;">
        <div class="widget-header"><h4><i class="icon-link"></i> Instructions</h4></div>
        <div class="widget-content">

            <p style="padding:10px 15px; 10px 15px; background:#f0f0f0; color:#CC0000;">Copy/paste the following code into your configuration file.</p>

            <textarea name="seo_code" class="form-control" rows="16"># iDevAffiliate SEO Rewrite

location /signup- {
  rewrite ^/signup-([0-9]+)\<?PHP echo $seo_link_extension; ?>$ <?PHP echo $hturl; ?>/recruit\.php?ref=$1 <?PHP echo $redirect_write; ?>;
}

location /feed {
    rewrite ^/feed-([0-9]+)-([0-9]+)\<?PHP echo $seo_link_extension; ?>$ <?PHP echo $hturl; ?>/idevaffiliate\.php?id=$1&feed=$2 <?PHP echo $redirect_write; ?>;
}

location /fb {
	rewrite ^/fb([0-9]+)-([0-9]+)\<?PHP echo $seo_link_extension; ?>$ <?PHP echo $hturl; ?>/fb_url\.php?id=$1&page=$2 <?PHP echo $redirect_write; ?>;
}

location / {
  rewrite ^/([0-9]+)-([a-z]+)-([0-9]+)\<?PHP echo $seo_link_extension; ?>$ <?PHP echo $hturl; ?>/idevads\.php?id=$1&ad=$3 <?PHP echo $redirect_write; ?>;
  rewrite ^/([0-9]+)-([a-z]+)-([0-9]+)-([0-9]+)\<?PHP echo $seo_link_extension; ?>$ <?PHP echo $hturl; ?>/idevads\.php?id=$1&ad=$3&page=$4 <?PHP echo $redirect_write; ?>;
  rewrite ^/([0-9]+)\<?PHP echo $seo_link_extension; ?>$ <?PHP echo $hturl; ?>/<?PHP echo $filename; ?>\.php?id=$1 <?PHP echo $redirect_write; ?>;
  rewrite ^/([0-9]+)-([0-9]+)\<?PHP echo $seo_link_extension; ?>$ <?PHP echo $hturl; ?>/<?PHP echo $filename; ?>\.php?id=$1&page=$2 <?PHP echo $redirect_write; ?>;
  rewrite ^/([0-9]+)-([0-9]+)-([0-9]+)\<?PHP echo $seo_link_extension; ?>$ <?PHP echo $hturl; ?>/<?PHP echo $filename; ?>\.php?id=$1&page=$2&set=$3 <?PHP echo $redirect_write; ?>;
  rewrite ^/([0-9]+)-([0-9]+)-([0-9]+)-([0-9]+)\<?PHP echo $seo_link_extension; ?>$ <?PHP echo $hturl; ?>/<?PHP echo $filename; ?>\.php?id=$1&page=$2&set=$3&link=$4 <?PHP echo $redirect_write; ?>;
  rewrite ^/([0-9]+)-([0-9]+)-([0-9]+)-([0-9]+)-([a-zA-Z]+)\<?PHP echo $seo_link_extension; ?>$ <?PHP echo $hturl; ?>/<?PHP echo $filename; ?>\.php?id=$1&page=$2&set=$3&link=$4&keyword=$5 <?PHP echo $redirect_write; ?>;
  rewrite ^/([0-9]+)-([0-9]+)-([0-9]+)-([0-9]+)-([a-zA-Z]+)-([0-9]+)\<?PHP echo $seo_link_extension; ?>$ <?PHP echo $hturl; ?>/<?PHP echo $filename; ?>\.php?id=$1&page=$2&set=$3&link=$4&keyword=$5&custom=$6 <?PHP echo $redirect_write; ?>;
  rewrite ^/([0-9]+)-([0-9]+)-([0-9]+)-([0-9]+)-([a-zA-Z]+)-([0-9]+)-([0-9]+)\<?PHP echo $seo_link_extension; ?>$ <?PHP echo $hturl; ?>/<?PHP echo $filename; ?>\.php?id=$1&page=$2&set=$3&link=$4&keyword=$5&custom=$6&url=$7 <?PHP echo $redirect_write; ?>;
}</textarea>


        </div>
    </div>

</div>




