<?PHP
if (!defined('admin_includes')) { die(); }
include("session.check.php");
?>
<style>
    .loader {
        margin: 10px 10px;
        font-size: 5px;
        width: 1em;
        height: 1em;
        border-radius: 50%;
        position: relative;
        text-indent: -99em;
        -webkit-animation: load5 1.1s infinite ease;
        animation: load5 1.1s infinite ease;
        -webkit-transform: translateZ(0);
        -ms-transform: translateZ(0);
        transform: translateZ(0);
    }
    @-webkit-keyframes load5 {
        0%,
        100% {
            box-shadow: 0em -2.6em 0em 0em #000000, 1.8em -1.8em 0 0em rgba(0,0,0, 0.2), 2.5em 0em 0 0em rgba(0,0,0, 0.2), 1.75em 1.75em 0 0em rgba(0,0,0, 0.2), 0em 2.5em 0 0em rgba(0,0,0, 0.2), -1.8em 1.8em 0 0em rgba(0,0,0, 0.2), -2.6em 0em 0 0em rgba(255, 255, 255, 0.5), -1.8em -1.8em 0 0em rgba(255, 255, 255, 0.7);
        }
        12.5% {
            box-shadow: 0em -2.6em 0em 0em rgba(255, 255, 255, 0.7), 1.8em -1.8em 0 0em #000000, 2.5em 0em 0 0em rgba(0,0,0, 0.2), 1.75em 1.75em 0 0em rgba(0,0,0, 0.2), 0em 2.5em 0 0em rgba(0,0,0, 0.2), -1.8em 1.8em 0 0em rgba(0,0,0, 0.2), -2.6em 0em 0 0em rgba(0,0,0, 0.2), -1.8em -1.8em 0 0em rgba(255, 255, 255, 0.5);
        }
        25% {
            box-shadow: 0em -2.6em 0em 0em rgba(255, 255, 255, 0.5), 1.8em -1.8em 0 0em rgba(255, 255, 255, 0.7), 2.5em 0em 0 0em #000000, 1.75em 1.75em 0 0em rgba(0,0,0, 0.2), 0em 2.5em 0 0em rgba(0,0,0, 0.2), -1.8em 1.8em 0 0em rgba(0,0,0, 0.2), -2.6em 0em 0 0em rgba(0,0,0, 0.2), -1.8em -1.8em 0 0em rgba(0,0,0, 0.2);
        }
        37.5% {
            box-shadow: 0em -2.6em 0em 0em rgba(0,0,0, 0.2), 1.8em -1.8em 0 0em rgba(255, 255, 255, 0.5), 2.5em 0em 0 0em rgba(255, 255, 255, 0.7), 1.75em 1.75em 0 0em #000000, 0em 2.5em 0 0em rgba(0,0,0, 0.2), -1.8em 1.8em 0 0em rgba(0,0,0, 0.2), -2.6em 0em 0 0em rgba(0,0,0, 0.2), -1.8em -1.8em 0 0em rgba(0,0,0, 0.2);
        }
        50% {
            box-shadow: 0em -2.6em 0em 0em rgba(0,0,0, 0.2), 1.8em -1.8em 0 0em rgba(0,0,0, 0.2), 2.5em 0em 0 0em rgba(255, 255, 255, 0.5), 1.75em 1.75em 0 0em rgba(255, 255, 255, 0.7), 0em 2.5em 0 0em #000000, -1.8em 1.8em 0 0em rgba(0,0,0, 0.2), -2.6em 0em 0 0em rgba(0,0,0, 0.2), -1.8em -1.8em 0 0em rgba(0,0,0, 0.2);
        }
        62.5% {
            box-shadow: 0em -2.6em 0em 0em rgba(0,0,0, 0.2), 1.8em -1.8em 0 0em rgba(0,0,0, 0.2), 2.5em 0em 0 0em rgba(0,0,0, 0.2), 1.75em 1.75em 0 0em rgba(255, 255, 255, 0.5), 0em 2.5em 0 0em rgba(255, 255, 255, 0.7), -1.8em 1.8em 0 0em #000000, -2.6em 0em 0 0em rgba(0,0,0, 0.2), -1.8em -1.8em 0 0em rgba(0,0,0, 0.2);
        }
        75% {
            box-shadow: 0em -2.6em 0em 0em rgba(0,0,0, 0.2), 1.8em -1.8em 0 0em rgba(0,0,0, 0.2), 2.5em 0em 0 0em rgba(0,0,0, 0.2), 1.75em 1.75em 0 0em rgba(0,0,0, 0.2), 0em 2.5em 0 0em rgba(255, 255, 255, 0.5), -1.8em 1.8em 0 0em rgba(255, 255, 255, 0.7), -2.6em 0em 0 0em #000000, -1.8em -1.8em 0 0em rgba(0,0,0, 0.2);
        }
        87.5% {
            box-shadow: 0em -2.6em 0em 0em rgba(0,0,0, 0.2), 1.8em -1.8em 0 0em rgba(0,0,0, 0.2), 2.5em 0em 0 0em rgba(0,0,0, 0.2), 1.75em 1.75em 0 0em rgba(0,0,0, 0.2), 0em 2.5em 0 0em rgba(0,0,0, 0.2), -1.8em 1.8em 0 0em rgba(255, 255, 255, 0.5), -2.6em 0em 0 0em rgba(255, 255, 255, 0.7), -1.8em -1.8em 0 0em #000000;
        }
    }
    @keyframes load5 {
        0%,
        100% {
            box-shadow: 0em -2.6em 0em 0em #000000, 1.8em -1.8em 0 0em rgba(0,0,0, 0.2), 2.5em 0em 0 0em rgba(0,0,0, 0.2), 1.75em 1.75em 0 0em rgba(0,0,0, 0.2), 0em 2.5em 0 0em rgba(0,0,0, 0.2), -1.8em 1.8em 0 0em rgba(0,0,0, 0.2), -2.6em 0em 0 0em rgba(255, 255, 255, 0.5), -1.8em -1.8em 0 0em rgba(255, 255, 255, 0.7);
        }
        12.5% {
            box-shadow: 0em -2.6em 0em 0em rgba(255, 255, 255, 0.7), 1.8em -1.8em 0 0em #000000, 2.5em 0em 0 0em rgba(0,0,0, 0.2), 1.75em 1.75em 0 0em rgba(0,0,0, 0.2), 0em 2.5em 0 0em rgba(0,0,0, 0.2), -1.8em 1.8em 0 0em rgba(0,0,0, 0.2), -2.6em 0em 0 0em rgba(0,0,0, 0.2), -1.8em -1.8em 0 0em rgba(255, 255, 255, 0.5);
        }
        25% {
            box-shadow: 0em -2.6em 0em 0em rgba(255, 255, 255, 0.5), 1.8em -1.8em 0 0em rgba(255, 255, 255, 0.7), 2.5em 0em 0 0em #000000, 1.75em 1.75em 0 0em rgba(0,0,0, 0.2), 0em 2.5em 0 0em rgba(0,0,0, 0.2), -1.8em 1.8em 0 0em rgba(0,0,0, 0.2), -2.6em 0em 0 0em rgba(0,0,0, 0.2), -1.8em -1.8em 0 0em rgba(0,0,0, 0.2);
        }
        37.5% {
            box-shadow: 0em -2.6em 0em 0em rgba(0,0,0, 0.2), 1.8em -1.8em 0 0em rgba(255, 255, 255, 0.5), 2.5em 0em 0 0em rgba(255, 255, 255, 0.7), 1.75em 1.75em 0 0em #000000, 0em 2.5em 0 0em rgba(0,0,0, 0.2), -1.8em 1.8em 0 0em rgba(0,0,0, 0.2), -2.6em 0em 0 0em rgba(0,0,0, 0.2), -1.8em -1.8em 0 0em rgba(0,0,0, 0.2);
        }
        50% {
            box-shadow: 0em -2.6em 0em 0em rgba(0,0,0, 0.2), 1.8em -1.8em 0 0em rgba(0,0,0, 0.2), 2.5em 0em 0 0em rgba(255, 255, 255, 0.5), 1.75em 1.75em 0 0em rgba(255, 255, 255, 0.7), 0em 2.5em 0 0em #000000, -1.8em 1.8em 0 0em rgba(0,0,0, 0.2), -2.6em 0em 0 0em rgba(0,0,0, 0.2), -1.8em -1.8em 0 0em rgba(0,0,0, 0.2);
        }
        62.5% {
            box-shadow: 0em -2.6em 0em 0em rgba(0,0,0, 0.2), 1.8em -1.8em 0 0em rgba(0,0,0, 0.2), 2.5em 0em 0 0em rgba(0,0,0, 0.2), 1.75em 1.75em 0 0em rgba(255, 255, 255, 0.5), 0em 2.5em 0 0em rgba(255, 255, 255, 0.7), -1.8em 1.8em 0 0em #000000, -2.6em 0em 0 0em rgba(0,0,0, 0.2), -1.8em -1.8em 0 0em rgba(0,0,0, 0.2);
        }
        75% {
            box-shadow: 0em -2.6em 0em 0em rgba(0,0,0, 0.2), 1.8em -1.8em 0 0em rgba(0,0,0, 0.2), 2.5em 0em 0 0em rgba(0,0,0, 0.2), 1.75em 1.75em 0 0em rgba(0,0,0, 0.2), 0em 2.5em 0 0em rgba(255, 255, 255, 0.5), -1.8em 1.8em 0 0em rgba(255, 255, 255, 0.7), -2.6em 0em 0 0em #000000, -1.8em -1.8em 0 0em rgba(0,0,0, 0.2);
        }
        87.5% {
            box-shadow: 0em -2.6em 0em 0em rgba(0,0,0, 0.2), 1.8em -1.8em 0 0em rgba(0,0,0, 0.2), 2.5em 0em 0 0em rgba(0,0,0, 0.2), 1.75em 1.75em 0 0em rgba(0,0,0, 0.2), 0em 2.5em 0 0em rgba(0,0,0, 0.2), -1.8em 1.8em 0 0em rgba(255, 255, 255, 0.5), -2.6em 0em 0 0em rgba(255, 255, 255, 0.7), -1.8em -1.8em 0 0em #000000;
        }
    }

</style>
<div class="crumbs">
    <ul id="breadcrumbs" class="breadcrumb">
        <li><i class="icon-home"></i> <a href="dashboard.php">Dashboard</a></li>
        <li> General Settings</li>
        <li class="current"> <a href="setup.php?action=16" title="">Customer Tracking</a></li>
    </ul>
    <?PHP include("templates/crumb_right.php"); ?>
</div>

<div class="page-header">
    <div class="page-title"><h3>Customer Tracking</h3><span>Define your affiliate/customer tracking duration and adjust tracking preferences.</span></div>
    <?PHP include("templates/stats.php"); ?>
</div>

<?PHP include("notifications.php"); ?>

<div class="tabbable tabbable-custom">
    <ul class="nav nav-tabs">
        <li><a <?php makeActiveTab(1);?> href="#tab_1_1" data-toggle="tab">Customer Tracking Settings</a></li>
        <li><a <?php makeActiveTab(2);?> href="#tab_1_2" data-toggle="tab">IP Settings</a></li>
        <li><a data-toggle="modal" href="#video_tutorial"><i class="icon-play"></i> Video Tutorial</a></li>
    </ul>

    <div class="modal fade" id="video_tutorial">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title">Video Tutorial: Customer Tracking</h4>
                </div>
                <div class="modal-body">
                    <div class="video-container">
                        <iframe src="//player.vimeo.com/video/85581505" frameborder="0" width="560" height="315" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <div class="tab-content">

        <div class="tab-pane<?php makeActiveTab(1, 'no');?>" id="tab_1_1">
            <div class="col-md-12">
                <div class="widget box" style="margin-top:20px;">
                    <div class="widget-header"><h4><i class="icon-user"></i> Customer Tracking Settings</h4></div>
                    <div class="widget-content">
                        <form class="form-horizontal row-border" method="post" action="setup.php">
                            <input name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>" type="hidden" />
                            <div class="form-group row">
                                <label class="col-md-3 control-label">Customer Tracking Duration</label>
                                <div class="col-md-9"><input style="display:inline-block" type="text" name="exp1" value="<?PHP echo html_output($ex1); ?>" class="form-control input-width-small">
                                    <select style="display: inline-block" class="form-control input-width-small" name="exp2">
                                        <option value="1" <?PHP if ($ex2=='1'){?> selected="selected"<?PHP } ?>>Minutes</option>
                                        <option value="2" <?PHP if ($ex2=='2'){?> selected="selected"<?PHP } ?>>Hours</option>
                                        <option value="3" <?PHP if ($ex2=='3'){?> selected="selected"<?PHP } ?>>Days</option>
                                        <option value="4" <?PHP if ($ex2=='4'){?> selected="selected"<?PHP } ?>>Years</option></select> <span class="help-block">Set to 50 years for lifetime.</span>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-md-3 control-label">Customer Tracking Method</label>
                                <div class="col-md-4"><select class="form-control" name="use_cookies" />
                                    <option value="1" <?PHP if($use_cookies=='1'){?> selected="selected"<?PHP } ?>>IP Logs and Cookies (default)</option>
                                    <option value="0" <?PHP if($use_cookies=='0'){?> selected="selected"<?PHP } ?>>IP Logs Only</option>
                                    </select></div>
                            </div>

                            <div class="form-group row">
                                <label class="col-md-3 control-label">Email Address Tracking</label>
                                <div class="col-md-4"><select class="form-control" name="email_tracking" />
                                    <option value="1" <?PHP if($email_tracking=='1'){?> selected="selected"<?PHP } ?>>Yes</option>
                                    <option value="0" <?PHP if($email_tracking=='0'){?> selected="selected"<?PHP } ?>>No</option>
                                    </select> <span class="help-block">Before enabling, <a href="https://help.idevaffiliate.com/customer-tracking-email-address/" target="_blank" style="color:blue;">visit the documentation</a> on this feature.</span>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-md-3 control-label">Crediting Style</label>
                                <div class="col-md-4"><select name="aff_lock" class="form-control">
                                        <option value="0" <?PHP if($aff_lock=='0'){?> selected="selected"<?PHP } ?>>First To Send Visitor Gets Credit</option>
                                        <option value="1" <?PHP if($aff_lock=='1'){?> selected="selected"<?PHP } ?>>Last To Send Visitor Gets Credit</option>
                                    </select></div>
                            </div>
                            <div class="form-actions">
                                <input type="submit" value="Save Settings" class="btn btn-primary">
                            </div>
                            <input type="hidden" name="action" value="16">
                            <input type="hidden" name="cfg" value="9">
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="tab-pane<?php makeActiveTab(2, 'no');?>" id="tab_1_2">
            <div class="col-md-12"style="margin-top:10px;">

                <?PHP if (defined('CLOUD')) { ?>
                    <div class="alert alert-info">Please do not alter settings here unless advised by a support technician.</div>
                <?PHP } ?>

                <div class="widget box" style="margin-top:20px;">
                    <div class="widget-header"><h4><i class="icon-user"></i> IP Address Settings</h4></div>
                    <div class="widget-content">
                        <form class="form-horizontal row-border" method="post" action="setup.php">
                            <input name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>" type="hidden" />
                            <div class="form-group row">
                                <label class="col-md-3 control-label">IP Setting</label>
                                <div class="col-md-4"><select class="form-control" name="ip_setting">
                                        <option value="REMOTE_ADDR" <?PHP if ($ip_setting == "REMOTE_ADDR") { ?> selected <?PHP } ?>>REMOTE_ADDR</option>
                                        <option value="HTTP_X_FORWARDED_FOR" <?PHP if ($ip_setting == "HTTP_X_FORWARDED_FOR") { ?> selected <?PHP } ?>>HTTP_X_FORWARDED_FOR</option>
                                        <option value="HTTP_CLIENT_IP" <?PHP if ($ip_setting == "HTTP_CLIENT_IP") { ?> selected <?PHP } ?>>HTTP_CLIENT_IP</option>
                                        <option value="HTTP_X_CLUSTER_CLIENT_IP" <?PHP if ($ip_setting == "HTTP_X_CLUSTER_CLIENT_IP") { ?> selected <?PHP } ?>>HTTP_X_CLUSTER_CLIENT_IP</option>
                                        <option value="HTTP_CF_CONNECTING_IP" <?PHP if ($ip_setting == "HTTP_CF_CONNECTING_IP") { ?> selected <?PHP } ?>>HTTP_CF_CONNECTING_IP (CloudFlare Users Only)</option>
                                        <option value="HTTP_X_SUCURI_CLIENTIP" <?PHP if ($ip_setting == "HTTP_X_SUCURI_CLIENTIP") { ?> selected <?PHP } ?>>HTTP_X_SUCURI_CLIENTIP (Sucuri Users Only)</option>
                                        <option value="HTTP_X_SP_FORWARDED_IP" <?PHP if ($ip_setting == "HTTP_X_SP_FORWARDED_IP") { ?> selected <?PHP } ?>>HTTP_X_SP_FORWARDED_IP (StackPath WAF Users Only)</option>
                                    </select></div>
                            </div>
                            <?PHP if (defined('CLOUD')) { ?>
                                <div class="form-group row">
                                    <label class="col-md-3 control-label">IPv6 Support</label>
                                    <div class="col-md-4"><select class="form-control" name="ipv6">
                                            <option value="0" <?PHP if ($ipv6 == 0) { ?> selected <?PHP } ?>>Enabled</option>
                                            <option value="1" <?PHP if ($ipv6 == 1) { ?> selected <?PHP } ?>>Disabled</option>
                                        </select></div>
                                </div>
                            <?PHP } ?>
                            <div class="form-actions">
                                <input type="submit" value="Save Setting" class="btn btn-primary">
                            </div>
                            <input type="hidden" name="action" value="16">
                            <input type="hidden" name="cfg" value="91">
                            <input type="hidden" name="tab" value="2">
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="bs-callout bs-callout-notes">
                    <h4><img src="images/help-notes.png" height="48" width="48" border="none;" /> IP Setting Notes</h4>
                    <div class="alert alert-warning">If the IP address below matches your computer's IP address, your system is configured properly.</div>
                    <table class="table valign table-striped table-bordered table-highlight-head">
                        <tbody>
                        <tr>
                            <td width="25%"><strong>Current Setting</strong></td>
                            <td width="75%"><?PHP echo html_output($ip_setting); ?></td>
                        </tr>
                        <tr>
                            <td width="25%"><strong>IP Address On This Computer</strong></td>
                            <td width="75%" style="color:#CC0000;" id="ip_address_on_this_computer">
                                <?php
                                if($ipv6 == 0):
                                    echo html_output($ip_addr);
                                else:
                                    ?>
                                    <div class="loader"></div>
                                <?php
                                endif;
                                ?>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>

    </div>
</div>
<script>
    <?php
    if($ipv6==1):
    ?>
    $.get('https://idevipaddress.com/ip.php',function(data){
        $("#ip_address_on_this_computer").html(data);
    });
    <?php endif; ?>
</script>





