<?PHP
// FILE INCLUDE VALIDATION
if (!defined('IDEV_FILE_AUTH')) {
    die('Unauthorized Access');
}
// -------------------------------------------------------------------------------------------------
include("session.check.php");
?>

<script>
    new Clipboard('[data-clipboard-text]');
</script>
<div class="crumbs">
    <ul id="breadcrumbs" class="breadcrumb">
        <li><i class="icon-home"></i> <a href="dashboard.php">Dashboard</a></li>
        <li> Tools</li>
        <li class="current"><a href="setup.php?action=44" title="">API</a></li>
    </ul>
    <?PHP include("templates/crumb_right.php"); ?>
</div>

<div class="page-header">
    <div class="page-title"><h3>API</h3><span>For advanced users only. Limited support available.</span></div>
    <?PHP include("templates/stats.php"); ?>
</div>

<?PHP include("notifications.php"); ?>

<div class="tabbable tabbable-custom">
    <ul class="nav nav-tabs">
        <li><a <?php makeActiveTab(1); ?> href="#tab_1_1" data-toggle="tab">Basic API</a></li>
        <li><a <?php makeActiveTab(4); ?> href="#tab_1_4" data-toggle="tab">RESTful API</a></li>
    </ul>

    <div class="tab-content">

        <div class="tab-pane<?php makeActiveTab(1, 'no'); ?>" id="tab_1_1">

<div class="tabbable tabbable-custom" style="margin:20px;">
<ul class="nav nav-tabs">
<li><a class="tab-pane<?php makeActiveTab(7); ?>  active" href="#tab_2_7" data-toggle="tab">Basic API</a></li>
<li><a class="tab-pane<?php makeActiveTab(8); ?>" href="#tab_2_8" data-toggle="tab">API Secret Key</a></li>
</ul>

<div class="tab-content">

<div class="tab-pane<?php makeActiveTab(7, 'no'); ?> active" id="tab_2_7">
    <div class="col-md-12">
        <div class="widget box" style="margin-top:20px;">
            <div class="widget-header"><h4><i class="icon-group"></i>Basic API Scripts</h4></div>
                <div class="widget-content">
                    <form class="form-horizontal row-border" method="post" action="setup.php">
                        <div class="form-group row" style="margin-top:-5px;">
                            <label class="col-md-3 control-label">Choose An API Script</label>
                            <div class="col-md-4"><select class="form-control" name="chosen_api">

                                    <OPTGROUP label="General">
                                    <option
                                        value="1"<?PHP if ((isset($_REQUEST['chosen_api'])) && ($_REQUEST['chosen_api'] == 1)) {
                                        echo " selected";
                                    } ?>>Reset Payout Levels Each Month
                                    </option>
                                    </OPTGROUP>
                                    <OPTGROUP label="Affiliates">
                                        <option
                                                value="3"<?PHP if ((isset($_REQUEST['chosen_api'])) && ($_REQUEST['chosen_api'] == 3)) {
                                            echo " selected";
                                        } ?>>Create An Account
                                        </option>
                                        <option
                                                value="7"<?PHP if ((isset($_REQUEST['chosen_api'])) && ($_REQUEST['chosen_api'] == 7)) {
                                            echo " selected";
                                        } ?>>New Account API Trigger
                                        </option>
                                        <option
                                                value="8"<?PHP if ((isset($_REQUEST['chosen_api'])) && ($_REQUEST['chosen_api'] == 8)) {
                                            echo " selected";
                                        } ?>>Terminate An Affiliate Account
                                        </option>
                                    </OPTGROUP>
                                    <OPTGROUP label="Commissions">
                                        <option
                                                value="2"<?PHP if ((isset($_REQUEST['chosen_api'])) && ($_REQUEST['chosen_api'] == 2)) {
                                            echo " selected";
                                        } ?>>Create A Commission
                                        </option>
                                        <option
                                                value="4"<?PHP if ((isset($_REQUEST['chosen_api'])) && ($_REQUEST['chosen_api'] == 4)) {
                                            echo " selected";
                                        } ?>>Remove / Decline A Commission
                                        </option>
                                        <option
                                                value="6"<?PHP if ((isset($_REQUEST['chosen_api'])) && ($_REQUEST['chosen_api'] == 6)) {
                                            echo " selected";
                                        } ?>>Approve A Commission
                                        </option>
                                        <option
                                                value="10"<?PHP if ((isset($_REQUEST['chosen_api'])) && ($_REQUEST['chosen_api'] == 10)) {
                                            echo " selected";
                                        } ?>>Edit A Commission Amount
                                        </option>
                                        <option
                                                value="11"<?PHP if ((isset($_REQUEST['chosen_api'])) && ($_REQUEST['chosen_api'] == 11)) {
                                            echo " selected";
                                        } ?>>Edit A Sale Amount
                                        </option>
                                        <option
                                                value="12"<?PHP if ((isset($_REQUEST['chosen_api'])) && ($_REQUEST['chosen_api'] == 12)) {
                                            echo " selected";
                                        } ?>>Edit An Order Number
                                        </option>
                                    </OPTGROUP>
                                    <OPTGROUP label="Custom">
                                        <option
                                                value="9"<?PHP if ((isset($_POST['chosen_api'])) && ($_POST['chosen_api'] == 9)) {
                                            echo " selected";
                                        } ?>>Create Your Own
                                        </option>
                                    </OPTGROUP>





                                </select></div>
                        </div>
                        <div class="form-actions">
                            <input type="submit" value="View Instructions" class="btn btn-primary">
                        </div>
                        <input type="hidden" name="action" value="44">
                    <input name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>" type="hidden" /></form>
						
						
                </div>
            </div>
        </div>

						
						
						
						
						
            <?PHP if (isset($_REQUEST['chosen_api'])) { ?>
                <?PHP if ($_REQUEST['chosen_api'] == 1) { ?>

                    <div class="col-md-12">
                        <div class="widget box" style="margin-top:20px;">
                            <div class="widget-header"><h4><i class="icon-code"></i> Reset Payout Levels Each Months
                                </h4></div>
                            <div class="widget-content">
                                <div class="well"><strong>Script Location:
                                        API/scripts/payout_level_reset.php</strong><br/><br/>By default, new accounts
                                    start in payout level 1. If you're using the performance rewards feature or are
                                    manually moving payout levels up for your affiliates, you can use this function to
                                    automatically reset all affiliate accounts back to payout level 1 on the 1st of each
                                    month.<br/><br/>In order to use this feature, you must setup a cron job on your web
                                    hosting server. This is very easy to do and usually only takes a couple minutes. A
                                    cron Job will trigger the defined file as often as you tell it to. You can usually
                                    find an area in your web hosting control panel labeled cron Jobs. Click on that link
                                    and create one of the following cron jobs. Set the following cron job to run once
                                    per day, at midnight.<br/><br/>Note: <font color="#CC0000">Choose the appropriate
                                        code based on the server configuration for your web hosting account.</font>
                                </div>
                                <table class="table valign table-striped table-bordered table-highlight-head">
                                    <tbody>
                                    <tr>
                                        <td><strong>Option A: wget</strong></td>
                                    </tr>
                                    <tr>
                                        <td><input type="text" name="cron" class="form-control"
                                                   value="wget -q -O /dev/null <?PHP echo $base_url; ?>/API/scripts/payout_level_reset.php?secret=<?PHP echo $secret; ?>">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><strong>Option B: curl</strong></td>
                                    </tr>
                                    <tr>
                                        <td><input type="text" name="cron" class="form-control"
                                                   value="curl -s -o /dev/null <?PHP echo $base_url; ?>/API/scripts/payout_level_reset.php?secret=<?PHP echo $secret; ?>">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><strong>Option C: fetch</strong></td>
                                    </tr>
                                    <tr>
                                        <td><input type="text" name="cron" class="form-control"
                                                   value="fetch -o /dev/null <?PHP echo $base_url; ?>/API/scripts/payout_level_reset.php?secret=<?PHP echo $secret; ?>">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><strong>Option D: lynx</strong></td>
                                    </tr>
                                    <tr>
                                        <td><input type="text" name="cron" class="form-control"
                                                   value="lynx > /dev/null -dump <?PHP echo $base_url; ?>/API/scripts/payout_level_reset.php?secret=<?PHP echo $secret; ?>">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><strong>Setup Note</strong><br/>If you have trouble creating this procedure,
                                            contact your web hosting provider and show them these 4 lines of code and
                                            ask them which one should be used.&nbsp; They will know what you mean and
                                            should help you get this setup.
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                <?PHP } elseif ($_REQUEST['chosen_api'] == 2) {
// CREATE A COMMISSION
                    ?>
                    <div class="col-md-12">
                        <div class="widget box" style="margin-top:20px;">
                            <div class="widget-header"><h4><i class="icon-code"></i> Generate A Commission</h4></div>
                            <div class="widget-content">

                                <div class="well"><strong>Script Location: /sale.php</strong><br/><br/>This is the
                                    normal sale.php file and cannot be altered. Using this script, you can create a
                                    commission anytime you want, from any location you want. This file will accept both
                                    _POST data and _REQUEST data. Pass in the variables to this script to create the
                                    commission. To create a commission, simply call (<font
                                        color="#CC0000"><?PHP echo $base_url; ?>/sale.php</font>) and send the required
                                    variables into this file. This file does not require the secret key to be passed in
                                    because it already has built-in security protection.<br/><br/><font color="#CC0000">Example
                                        Call:</font> <?PHP echo $base_url; ?>
                                    /sale.php?idev_saleamt=99.99&idev_ordernum=abc-123&ip_address=111.111.111.11<br/>PHP
                                    Example: Post the above URL using cURL.
                                </div>
                                <div class="alert alert-danger"><strong>Required Variables for Identification</strong> -
                                    Only One Required
                                </div>
                                <table class="table valign table-striped table-bordered table-highlight-head">
                                    <thead>
                                    <tr>
                                        <th>Variable Name</th>
                                        <th>Data Type</th>
                                        <th>Notes / Values / Switches</th>
                                        <th>URL Example</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>ip_address</td>
                                        <td>Numerical</td>
                                        <td>This is the customer's IP address.</td>
                                        <td>ip_address=111.111.111.11</td>
                                    </tr>
                                    <tr>
                                        <td>affiliate_id</td>
                                        <td>Numerical</td>
                                        <td>This is the referring affiliate's ID.</td>
                                        <td>affiliate_id=650</td>
                                    </tr>
                                    </tbody>
                                </table>

                                <div class="well">Since it's likely you will be calling this file from a 3rd party
                                    system in the background after an invoice is paid or payment is made, you need to
                                    "force feed" iDevAffiliate the affiliate to credit. This can be done by literally
                                    telling iDevAffiliate which affiliate to credit (<strong>affiliate_id</strong>) or
                                    iDevAffiliate can do it for you based on tracking logs but it will need the
                                    customer's IP address (<strong>ip_address</strong>).<br/><br/><font color="#CC0000">Important
                                        Note:</font> If you are setting this function to trigger for a recurring
                                    payment, you need to pass the original IP address that the customer had at the time
                                    of his/her <strong><u>first</u></strong> purchase. This is the IP that we have
                                    stored in iDevAffiliate so we need it to lookup the original referring affiliate.
                                </div>
                                <div class="alert alert-danger"><strong>Required Variables for Commission
                                        Processing</strong> - Only One Required
                                </div>
                                <table class="table valign table-striped table-bordered table-highlight-head">
                                    <thead>
                                    <tr>
                                        <th>Variable Name</th>
                                        <th>Data Type</th>
                                        <th>Notes / Values / Switches</th>
                                        <th>URL Example</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>idev_saleamt</td>
                                        <td>Numerical</td>
                                        <td>This is the sub/total sale amount.</td>
                                        <td>idev_saleamt=99.99</td>
                                    </tr>
                                    <tr>
                                        <td>idev_commission</td>
                                        <td>Numerical</td>
                                        <td>This is a forced commission amount.</td>
                                        <td>idev_commission=45.00</td>
                                    </tr>
                                    </tbody>
                                </table>

                                <div class="well">By passing the sub/total sale amount (<strong>idev_saleamt</strong>),
                                    iDevAffiliate will calculate the commission normally based on your commission payout
                                    settings. If you want to calculate the commission amount yourself, you can pass it
                                    directly in using the (<strong>idev_commission</strong>) method. This method will
                                    override all commission payout settings.
                                </div>
                                <div class="alert alert-info"><strong>Optional Variables</strong></div>
                                <table class="table valign table-striped table-bordered table-highlight-head">
                                    <thead>
                                    <tr>
                                        <th>Variable Name</th>
                                        <th>Data Type</th>
                                        <th>Notes / Values / Switches</th>
                                        <th>URL Example</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>idev_ordernum</td>
                                        <td>Alpahnumeric</td>
                                        <td>This is the order number.</td>
                                        <td>idev_ordernum=abc-123</td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                <?PHP } elseif ($_REQUEST['chosen_api'] == 3) {
// CREATE AN AFFILIATE ACCOUNT
                    ?>
                    <div class="col-md-12">
                        <div class="widget box" style="margin-top:20px;">
                            <div class="widget-header"><h4><i class="icon-code"></i> Create An Affiliate Account</h4>
                            </div>
                            <div class="widget-content">
                                <div class="well"><strong>Script Location:
                                        /API/scripts/new_affiliate.php</strong><br/><strong>Data Validation Location:
                                        API/scripts/new_affiliate_validation.php</strong><br/><br/>Please feel free to
                                    modify this script to meet your needs. Using this script, you can create new
                                    affiliate accounts from your own application. This script will accept both _POST
                                    data and _REQUEST data. Pass in the variables to this script to create the new
                                    account. <strong>New Account</strong> emails will go out just like normal. To create
                                    an account, simply call (<font color="#CC0000"><?PHP echo $base_url; ?>
                                        /API/scripts/new_affiliate.php</font>) and send the required variables into this
                                    file. In order to use this API script, you must also pass in your secret key. This
                                    variable name is called <strong>secret</strong> and you can find it <a
                                        href="idev_info.php">here</a>.<br/><br/><font color="#CC0000">Example
                                        Call:</font> <?PHP echo $base_url; ?>
                                    /API/scripts/new_affiliate.php?secret=<?PHP echo $secret; ?>
                                    &username=testuser...<br/>You can also POST this data using any method you want.
                                </div>
                                <div class="alert alert-danger"><strong>Required Variables</strong></div>
                                <table class="table valign table-striped table-bordered table-highlight-head">
                                    <thead>
                                    <tr>
                                        <th>Variable Name</th>
                                        <th>Data Type</th>
                                        <th>Notes / Values / Switches</th>
                                        <th>URL Example</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>secret</td>
                                        <td>Numbers Only</td>
                                        <td>This is your secret key found in the tab above.</td>
                                        <td>secret=<?PHP echo html_output($secret); ?></td>
                                    </tr>
                                    <tr>
                                        <td>username</td>
                                        <td>Numbers, Letters & Underscores Only</td>
                                        <td>Must be a minimum <?PHP echo html_output($user_min); ?> characters in
                                            length.
                                        </td>
                                        <td>username=bailey08</td>
                                    </tr>
                                    <tr>
                                        <td>password</td>
                                        <td>Numbers, Letters & Underscores Only</td>
                                        <td>Must be a minimum <?PHP echo html_output($pass_min); ?> characters in
                                            length.
                                        </td>
                                        <td>password=makemoney</td>
                                    </tr>
                                    <tr>
                                        <td>email</td>
                                        <td>Must Be An Emaill Address</td>
                                        <td>None</td>
                                        <td>email=ferrari@porsche.com</td>
                                    </tr>
                                </table>

                                <div class="alert alert-info"><strong>Optional Variables</strong> - Note: The <font
                                        color="#CC0000">%20</font> in the examples represent a SPACE in a URL string.
                                </div>
                                <table class="table valign table-striped table-bordered table-highlight-head">
                                    <thead>
                                    <tr>
                                        <th>Variable Name</th>
                                        <th>Data Type</th>
                                        <th>Notes / Values / Switches</th>
                                        <th>URL Example</th>
                                    </tr>
                                    </thead>
                                    <tr>
                                        <td>approved</td>
                                        <td>Numbers Only</td>
                                        <td>1 = approved, 0 = not approved</td>
                                        <td>approved=1</td>
                                    </tr>
                                    <tr>
                                        <td>payout_type</td>
                                        <td>Numbers Only</td>
                                        <td>1 = Percentage, 2 = Flat Rate , 3 = PPC</td>
                                        <td>payout_type=1</td>
                                    </tr>
                                    <tr>
                                        <td>payout_level</td>
                                        <td>Numbers Only</td>
                                        <td>None</td>
                                        <td>payout_level=1</td>
                                    </tr>
                                    <tr>
                                        <td>use_paypal</td>
                                        <td>Numbers Only</td>
                                        <td>1 = yes, 0 = no</td>
                                        <td>use_paypal=1</td>
                                    </tr>
                                    <tr>
                                        <td>paypal_account</td>
                                        <td>Must Be An Emaill Address</td>
                                        <td>This is a PayPal account/address.</td>
                                        <td>paypal_account=acct@site.com</td>
                                    </tr>
                                    <tr>
                                        <td>first_name</td>
                                        <td>Letters Only</td>
                                        <td>None</td>
                                        <td>first_name=bob</td>
                                    </tr>
                                    <tr>
                                        <td>last_name</td>
                                        <td>Letters Only</td>
                                        <td>None</td>
                                        <td>last_name=jones</td>
                                    </tr>
                                    <tr>
                                        <td>company</td>
                                        <td>Normal Characters In A Company Name</td>
                                        <td>None</td>
                                        <td>company=jones,<font color="#CC0000">%20</font>Inc.</td>
                                    </tr>
                                    <tr>
                                        <td>payable</td>
                                        <td>Letters Only</td>
                                        <td>Make checks payable to.</td>
                                        <td>payable=bob<font color="#CC0000">%20</font>jones</td>
                                    </tr>
                                    <tr>
                                        <td>tax_id</td>
                                        <td>Letters, Numbers & Dashes</td>
                                        <td>Tax ID, SSN or VAT</td>
                                        <td>tax_id=555-55-5555</td>
                                    </tr>
                                    <tr>
                                        <td>website</td>
                                        <td>Must Be A Website Address</td>
                                        <td>None</td>
                                        <td>website=http://www.site.com</td>
                                    </tr>
                                    <tr>
                                        <td>address_1</td>
                                        <td>Letters & Numbers</td>
                                        <td>Address Line One</td>
                                        <td>address_1=123<font color="#CC0000">%20</font>Main<font
                                                color="#CC0000">%20</font>St.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>address_2</td>
                                        <td>Letters & Numbers</td>
                                        <td>Address Line Two</td>
                                        <td>address_2=Apt.<font color="#CC0000">%20</font>C</td>
                                    </tr>
                                    <tr>
                                        <td>city</td>
                                        <td>Letters & Numbers</td>
                                        <td>None</td>
                                        <td>city=dallas</td>
                                    </tr>
                                    <tr>
                                        <td>state</td>
                                        <td>Letters</td>
                                        <td>Abbr. or Full</td>
                                        <td>state=FL</td>
                                    </tr>
                                    <tr>
                                        <td>zip</td>
                                        <td>Numbers</td>
                                        <td>None</td>
                                        <td>zip=91355</td>
                                    </tr>
                                    <tr>
                                        <td>country</td>
                                        <td>Letters Only</td>
                                        <td>2 Letters - Abbr: US, CA, JP, etc.</td>
                                        <td>country=US</td>
                                    </tr>
                                    <tr>
                                        <td>phone</td>
                                        <td>Letters & Dashes</td>
                                        <td>None</td>
                                        <td>phone=444-444-4444</td>
                                    </tr>
                                    <tr>
                                        <td>fax</td>
                                        <td>Letters & Dashes</td>
                                        <td>None</td>
                                        <td>fax=555-555-5555</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                <?PHP } elseif ($_REQUEST['chosen_api'] == 4) { ?>
                    <div class="col-md-12">
                        <div class="widget box" style="margin-top:20px;">
                            <div class="widget-header"><h4><i class="icon-code"></i> Remove A Commission</h4></div>
                            <div class="widget-content">

                                <div class="well"><strong>Script Location: API/scripts/terminate_commission.php</strong><br/><br/>Please
                                    feel free to modify this script to meet your needs. Using this script, you can
                                    remove (decline & delete) a commission directly from your 3rd party application.
                                    This includes both commissions that are pending approval and those that have already
                                    been approved. This script will accept both _POST data and _REQUEST data. Pass in
                                    the variables to this script to remove the commission. To remove a commission,
                                    simply call (<font color="#CC0000"><?PHP echo $base_url; ?>
                                        /API/scripts/terminate_commission.php</font>) and send the required variables
                                    into this file.&nbsp; In order to use this API script, you must also pass in your
                                    secret key.&nbsp; This variable name is called <strong>secret</strong> and you can
                                    find it <a href="idev_info.php">here</a>.<br/><br/><font color="#CC0000">Example
                                        Call:</font> <?PHP echo $base_url; ?>
                                    /API/scripts/terminate_commission.php?secret=<?PHP echo $secret; ?>
                                    &order_number=abc-123<br/>You can also POST this data using any method you want.
                                </div>
                                <div class="alert alert-danger"><strong>Required Variables</strong></div>
                                <table class="table valign table-striped table-bordered table-highlight-head">
                                    <thead>
                                    <tr>
                                        <th>Variable Name</th>
                                        <th>Data Type</th>
                                        <th>Notes / Values / Switches</th>
                                        <th>URL Example</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>secret</td>
                                        <td>Numbers Only</td>
                                        <td>This is your secret key found in the tab above.</td>
                                        <td>secret=<?PHP echo html_output($secret); ?></td>
                                    </tr>
                                    <tr>
                                        <td>order_number</td>
                                        <td>Alphanumeric</td>
                                        <td>This is the original order number.</td>
                                        <td>order_number=abc-123</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                <?PHP } elseif ($_REQUEST['chosen_api'] == 6) { ?>
                    <div class="col-md-12">
                        <div class="widget box" style="margin-top:20px;">
                            <div class="widget-header"><h4><i class="icon-code"></i> Approve A Commission</h4></div>
                            <div class="widget-content">
                                <div class="well"><strong>Script Location:
                                        API/scripts/approve_commission.php</strong><br/><br/>Please feel free to modify
                                    this script to meet your needs. Using this script, you can approve a commission
                                    directly from your 3rd party application. This script will accept both _POST data
                                    and _REQUEST data. Pass in the variables to this script to remove the commission. To
                                    approve a commission, simply call (<font color="#CC0000"><?PHP echo $base_url; ?>
                                        /API/scripts/approve_commission.php</font>) and send the required variables into
                                    this file. In order to use this API script, you must also pass in your secret key.
                                    This variable name is called <strong>secret</strong> and you can find it <a
                                        href="idev_info.php">here</a>.<br/><br/>This script will automatically perform
                                    the following functions.<br/>- Approve the commission.<br/>- Create a tier
                                    commission if needed.<br/>- Process performance rewards (if enabled).<br/>- Update
                                    marketing statistics (if enabled).<br/>- Send affiliate(s) email notifications.<br/><br/><font
                                        color="#CC0000">Example Call:</font> <?PHP echo $base_url; ?>
                                    /API/scripts/approve_commission.php?secret=<?PHP echo $secret; ?>
                                    &order_number=abc-123<br/>You can also POST this data using any method you want.
                                </div>
                                <div class="alert alert-danger"><strong>Required Variables</strong></div>
                                <table class="table valign table-striped table-bordered table-highlight-head">
                                    <thead>
                                    <tr>
                                        <th>Variable Name</th>
                                        <th>Data Type</th>
                                        <th>Notes / Values / Switches</th>
                                        <th>URL Example</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>secret</td>
                                        <td>Numbers Only</td>
                                        <td>This is your secret key found in the tab above.</td>
                                        <td>secret=<?PHP echo html_output($secret); ?></td>
                                    </tr>
                                    <tr>
                                        <td>order_number</td>
                                        <td>Alphanumeric</td>
                                        <td>This is the original order number.</td>
                                        <td>order_number=abc-123</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                <?PHP } elseif ($_REQUEST['chosen_api'] == 7) { ?>
                    <div class="col-md-12">
                        <div class="widget box" style="margin-top:20px;">
                            <div class="widget-header"><h4><i class="icon-code"></i> New Account API Trigger</h4></div>
                            <div class="widget-content">
                                <form class="form-horizontal row-border" method="post" action="setup.php">
                                    <input type="hidden" name="action" value="44">
                                    <input type="hidden" name="chosen_api" value="7">
                                    <input type="hidden" name="cfg" value="125">
                                    <div class="well">This feature will allow you to create your own API script that
                                        will be called upon successful affiliate account creation. Simply enable this
                                        feature and see the notes below to learn how to create a custom API that will be
                                        triggered after new accounts are created.
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-md-3 control-label">New Account API Trigger</label>
                                        <div class="col-md-3"><select class="form-control" name="signup_api">
                                                <option value="1" <?PHP if ($signup_api == 1) { ?> selected <?PHP } ?>>
                                                    Enabled
                                                </option>
                                                <option value="0" <?PHP if ($signup_api == 0) { ?> selected <?PHP } ?>>
                                                    Disabled
                                                </option>
                                            </select></div>
                                    </div>
                                    <div class="form-actions">
                                        <input type="submit" value="Save Settings" class="btn btn-primary">
                                    </div>
                                <input name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>" type="hidden" /></form>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="bs-callout bs-callout-notes">
                            <h4><img src="images/help-notes.png" height="48" width="48" border="none;"/> New Account API
                                Trigger Notes</h4>
                            <p>You can edit the <strong>API/scripts/<font
                                        color="#CC0000">new_account_API_trigger.php</font></strong> file. Anything you
                                put into this file will be called upon successful completion of the signup form OR a
                                completed <strong>new_affiliate.php</strong> API call. This file also has pre-defined
                                affiliate variables you can use to customize your API functions. Simply enabling this
                                feature will actually do nothing unless you edit the <strong>API/scripts/<font
                                        color="#CC0000">new_account_API_trigger.php</font></strong> file with your own
                                code. It's your custom code in this file that will be called upon signup completion. If
                                needed, please consult a programmer to help with code creation in this file.</p>
                        </div>
                    </div>

                <?PHP } elseif ($_REQUEST['chosen_api'] == 8) { ?>
                    <div class="col-md-12">
                        <div class="widget box" style="margin-top:20px;">
                            <div class="widget-header"><h4><i class="icon-code"></i> Terminate An Affiliate Account</h4>
                            </div>
                            <div class="widget-content">
                                <div class="well"><strong>Script Location:
                                        API/scripts/terminate_affiliate.php</strong><br/><br/>Please feel free to modify
                                    this script to meet your needs. Using this script, you can terminate an affiliate
                                    account. This script will accept both _POST data and _REQUEST data. Pass in the
                                    variables to this script to remove the affiliate account. To remove an account,
                                    simply call (<font color="#CC0000"><?PHP echo $base_url; ?>
                                        /API/scripts/terminate_affiliate.php</font>) and send the required variables
                                    into this file. In order to use this API script, you must also pass in your secret
                                    key. This variable name is called <strong>secret</strong> and you can find it <a
                                        href="idev_info.php">here</a>.

                                    <br/><br/>
                                    <div class="alert alert-success">Account Termination Note</div>
                                    Just like a regular account termination, the account will be moved to the <a
                                        href="accounts_declined.php">Declined Accounts</a> list unless its a Facebook
                                    created account in which case it will be permanently removed. You can also override
                                    this by adding the optional variable <strong>force_delete</strong> with a value of
                                    <strong>true</strong> (see below in red). Using this optional variable, the account
                                    will be permanently deleted.
                                    <br/><br/>
                                    <font color="#CC0000">Example Call:</font> <?PHP echo $base_url; ?>
                                    /API/scripts/terminate_affiliate.php?secret=<?PHP echo $secret; ?>
                                    &affiliate_id=123<font color="#CC0000">&force_delete=true</font><br/>- You can also
                                    POST this data using any method you want.
                                </div>
                                <div class="alert alert-danger"><strong>Required Variables</strong></div>
                                <table class="table valign table-striped table-bordered table-highlight-head">
                                    <thead>
                                    <tr>
                                        <th>Variable Name</th>
                                        <th>Data Type</th>
                                        <th>Notes / Values / Switches</th>
                                        <th>URL Example</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>secret</td>
                                        <td>Numbers Only</td>
                                        <td>This is your secret key found in the tab above.</td>
                                        <td>secret=<?PHP echo html_output($secret); ?></td>
                                    </tr>
                                    <tr>
                                        <td>affiliate_id</td>
                                        <td>Numeric</td>
                                        <td>This is the affiliate ID number.</td>
                                        <td>affiliate_id=123</td>
                                    </tr>
                                </table>

                                <div class="alert alert-info" style="margin-top:15px;"><strong>Optional
                                        Variables</strong></div>
                                <table class="table valign table-striped table-bordered table-highlight-head">
                                    <thead>
                                    <tr>
                                        <th>Variable Name</th>
                                        <th>Data Type</th>
                                        <th>Notes / Values / Switches</th>
                                        <th>URL Example</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>force_delete</td>
                                        <td>alpha</td>
                                        <td>Forces permanent account termination.</td>
                                        <td>force_delete=true</td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                <?PHP } elseif ($_REQUEST['chosen_api'] == 9) { ?>
				                    <div class="col-md-12">
                        <div class="widget box" style="margin-top:20px;">
                            <div class="widget-header"><h4><i class="icon-code"></i> Create Your Own</h4>
                            </div>
                            <div class="widget-content">
							<a href="https://www.idevlibrary.com/docs/API.pdf" target="_blank" class="btn btn-success">View Tutorial</a>
                            </div>
                        </div>
                    </div>


                <?PHP } elseif ($_REQUEST['chosen_api'] == 10) { ?>
                    <div class="col-md-12">
                        <div class="widget box" style="margin-top:20px;">
                            <div class="widget-header"><h4><i class="icon-code"></i> Edit A Commission Amount</h4></div>
                            <div class="widget-content">
                                <div class="well"><strong>Script Location:
                                        API/scripts/update_commission.php</strong><br/><br/>

                                    <strong>Purpose: </strong> Update a commission amount on an existing commission.

                                    <br/><br/>Using this script, you can update a commission amount
                                    directly from your 3rd party application. This script will accept both _POST data
                                    and _REQUEST data. Pass in the variables to this script to update the commission. To
                                    update a commission, call (<span style="color:#CC0000;"><?PHP echo $base_url; ?>
                                        /API/scripts/update_commission.php</span>) and send the required variables into
                                    this file. In order to use this API script, you must also pass in your secret key.
                                    <br/><br/><strong>Example Call:</strong>
                                    <br /><span style="color:#CC0000;"><?PHP echo $base_url; ?>/API/scripts/update_commission.php?secret=<?PHP echo $secret; ?>&order_number=abc-123&new_commission_amount=14.50</span>
                                    <br/><br/>You can also POST this data using any method you want.
                                    <br/><br/><strong>NOTE:</strong> You are updating the commission amount on the commission having the order number (order_number) you are passing. You can only update a commission amount if the commission is currently pending approval. Once the commission is approved or paid, you cannot alter the commission amount.
                                    <br/><br/><span style="color:#CC0000; font-weight:bold;">PRO TIP!</span> Use this update in conjunction with the <a href="setup.php?action=44&chosen_api=11" style="color:blue;">sale amount</a> update like this:<br />
                                    <span style="color:#CC0000;"><?PHP echo $base_url; ?>/API/scripts/update_commission.php?secret=<?PHP echo $secret; ?>&order_number=abc-123&new_commission_amount=14.50<strong>&new_sale_amount=99.99</strong></span>
                                </div>
                                <div class="alert alert-danger"><strong>Required Variables</strong></div>
                                <table class="table valign table-striped table-bordered table-highlight-head">
                                    <thead>
                                    <tr>
                                        <th>Variable Name</th>
                                        <th>Data Type</th>
                                        <th>Notes / Values / Switches</th>
                                        <th>URL Example</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>secret</td>
                                        <td>Numbers Only</td>
                                        <td>This is your secret key. Click <strong>API Secret Key</strong> above.</td>
                                        <td>secret=<?PHP echo html_output($secret); ?></td>
                                    </tr>
                                    <tr>
                                        <td>order_number</td>
                                        <td>Alphanumeric</td>
                                        <td>This is the original order number.</td>
                                        <td>order_number=abc-123</td>
                                    </tr>
                                    <tr>
                                        <td>new_commission_amount</td>
                                        <td>Numeric</td>
                                        <td>This is the new sale amount.</td>
                                        <td>new_commission_amount=14.50</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                <?PHP } elseif ($_REQUEST['chosen_api'] == 11) { ?>
                    <div class="col-md-12">
                        <div class="widget box" style="margin-top:20px;">
                            <div class="widget-header"><h4><i class="icon-code"></i> Edit A Sale Amount</h4></div>
                            <div class="widget-content">
                                <div class="well"><strong>Script Location:
                                        API/scripts/update_commission.php</strong><br/><br/>

                                    <strong>Purpose: </strong> Update a sale amount shown on a commission record.

                                    <br/><br/>Using this script, you can update a sale amount (shown on the commission record)
                                    directly from your 3rd party application. This script will accept both _POST data
                                    and _REQUEST data. Pass in the variables to this script to update the commission. To
                                    update a commission, call (<span style="color:#CC0000;"><?PHP echo $base_url; ?>
                                        /API/scripts/update_commission.php</span>) and send the required variables into
                                    this file. In order to use this API script, you must also pass in your secret key.
                                    <br/><br/><strong>Example Call:</strong><br/><span style="color:#CC0000;"><?PHP echo $base_url; ?>/API/scripts/update_commission.php?secret=<?PHP echo $secret; ?>&order_number=abc-123&new_sale_amount=99.99</span>
                                    <br/><br/>You can also POST this data using any method you want.
                                    <br/><br/><strong>NOTE:</strong> You are updating the sale amount on the commission having the order number (order_number) you are passing. You can only update a sale amount if the commission is currently pending approval. Once the commission is approved or paid, you cannot alter the sale amount.
                                    <br/><br/><span style="color:#CC0000; font-weight:bold;">PRO TIP!</span> Use this update in conjunction with the <a href="setup.php?action=44&chosen_api=10" style="color:blue;">commission amount</a> update like this:<br />
                                    <span style="color:#CC0000;"><?PHP echo $base_url; ?>/API/scripts/update_commission.php?secret=<?PHP echo $secret; ?>&order_number=abc-123&new_sale_amount=99.99<strong>&new_commission_amount=14.50</strong></span>
                                </div>
                                <div class="alert alert-danger"><strong>Required Variables</strong></div>
                                <table class="table valign table-striped table-bordered table-highlight-head">
                                    <thead>
                                    <tr>
                                        <th>Variable Name</th>
                                        <th>Data Type</th>
                                        <th>Notes / Values / Switches</th>
                                        <th>URL Example</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>secret</td>
                                        <td>Numbers Only</td>
                                        <td>This is your secret key. Click <strong>API Secret Key</strong> above.</td>
                                        <td>secret=<?PHP echo html_output($secret); ?></td>
                                    </tr>
                                    <tr>
                                        <td>order_number</td>
                                        <td>Alphanumeric</td>
                                        <td>This is the original order number.</td>
                                        <td>order_number=abc-123</td>
                                    </tr>
                                    <tr>
                                        <td>new_sale_amount</td>
                                        <td>Numeric</td>
                                        <td>This is the new sale amount.</td>
                                        <td>new_sale_amount=14.50</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                <?PHP } elseif ($_REQUEST['chosen_api'] == 12) { ?>
                    <div class="col-md-12">
                        <div class="widget box" style="margin-top:20px;">
                            <div class="widget-header"><h4><i class="icon-code"></i> Edit An Order Number</h4></div>
                            <div class="widget-content">
                                <div class="well"><strong>Script Location:
                                        API/scripts/update_commission.php</strong><br/><br/>

                                    <strong>Purpose: </strong> Update an order number shown on a commission record.

                                    <br/><br/>Using this script, you can update an order number (shown on the commission record)
                                    directly from your 3rd party application. This script will accept both _POST data
                                    and _REQUEST data. Pass in the variables to this script to update the commission. To
                                    update a commission, call (<span style="color:#CC0000;"><?PHP echo $base_url; ?>
                                        /API/scripts/update_commission.php</span>) and send the required variables into
                                    this file. In order to use this API script, you must also pass in your secret key.
                                    <br/><br/><strong>Example Call:</strong><br/><span style="color:#CC0000;"><?PHP echo $base_url; ?>/API/scripts/update_commission.php?secret=<?PHP echo $secret; ?>&order_number=abc-123&new_order_number=xyz-678</span>
                                    <br/><br/>You can also POST this data using any method you want.
                                    <br/><br/><strong>NOTE:</strong> You are updating the order number on the commission having the current order number (order_number) you are passing. You can only update an order number if the commission is currently pending approval. Once the commission is approved or paid, you cannot alter the order number.
                                    <br/><br/><span style="color:#CC0000; font-weight:bold;">PRO TIP!</span> Use this update in conjunction with the <a href="setup.php?action=44&chosen_api=10" style="color:blue;">commission amount</a> and <a href="setup.php?action=44&chosen_api=11" style="color:blue;">sale amount</a> update like this:<br />
                                    <span style="color:#CC0000;"><?PHP echo $base_url; ?>/API/scripts/update_commission.php?secret=<?PHP echo $secret; ?>&order_number=abc-123&new_order_number=xyz-678<strong>&new_commission_amount=14.50</strong><strong>&new_sale_amount=414.50</strong></span>
                                </div>
                                <div class="alert alert-danger"><strong>Required Variables</strong></div>
                                <table class="table valign table-striped table-bordered table-highlight-head">
                                    <thead>
                                    <tr>
                                        <th>Variable Name</th>
                                        <th>Data Type</th>
                                        <th>Notes / Values / Switches</th>
                                        <th>URL Example</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>secret</td>
                                        <td>Numbers Only</td>
                                        <td>This is your secret key. Click <strong>API Secret Key</strong> above.</td>
                                        <td>secret=<?PHP echo html_output($secret); ?></td>
                                    </tr>
                                    <tr>
                                        <td>order_number</td>
                                        <td>Alphanumeric</td>
                                        <td>This is the original order number.</td>
                                        <td>order_number=abc-123</td>
                                    </tr>
                                    <tr>
                                        <td>new_sale_amount</td>
                                        <td>Numeric</td>
                                        <td>This is the new sale amount.</td>
                                        <td>new_sale_amount=14.50</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                <?PHP }
            } ?>






</div>

    <div class="tab-pane<?php makeActiveTab(8, 'no'); ?>" id="tab_2_8">
<div class="col-md-12">
<div class="widget box" style="margin-top:20px;">
<div class="widget-header"><h4><i class="icon-group"></i> API Secret Key</h4></div>
<div class="widget-content">

                        <div class="alert alert-warning">Your secret key is used by API files and CRON
                            jobs to access files. It is designed to ensure only you are accessing the files. If you
                            reset this key,
                            you need to make sure you update any CRON jobs or API calls that use this key. <strong>It's
                                only advisable to reset this key if you believe it has become compromised.</strong><br/><br/>
                            <button class="btn btn-warning secret-btn" data-clipboard-text="<?PHP echo html_output($secret); ?>">
                                Copy API Key To Clipboard
                            </button>
                        </div>

                        <form class="form-horizontal row-border" method="post" action="setup.php">
                            <div></div>
                            <div class="form-group row">
                                <label class="col-md-3 control-label">Secret Key</label>
                                <div class="col-md-4"><input type="text" name="my_secret_number"
                                                             value="<?PHP echo html_output($secret); ?>"
                                                             class="form-control" readonly></div>
                            </div>
                            <div class="form-actions">
                                <input type="submit" value="Generate A New Secret Key" class="btn btn-primary">
                            </div>
                            <input type="hidden" name="action" value="44">
                            <input type="hidden" name="tab" value="1">
                            <input type="hidden" name="#tab_2_7" value="">
                            <input type="hidden" name="cfg" value="157">
                        <input name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>" type="hidden" /></form>
                    </div>
                </div>
            </div>
			
</div>
</div>
</div>

</div>



        <div class="tab-pane<?php makeActiveTab(4, 'no'); ?>" id="tab_1_4">

            <div class="col-md-12">
                <div class="widget box" style="margin-top:20px;">
                    <?php
                    $query = $db->prepare("SELECT * FROM `idevaff_admin` WHERE `record` = ? LIMIT 1");
                    $query->execute([
                        $_SESSION[$install_directory_name.'_idev_AdminAccount']
                    ]);
                    $isEnabled = true;
                    $data = [];
                    if (!$query->rowCount() || $query->rowCount() == 0) {
                        $isEnabled = false;
                    } else {
                        $data = $query->fetch(PDO::FETCH_ASSOC);
                    }

                    $data['api_key'] = $data['api_key'] ?? "";
                    if ($data['api_key'] == '') {
                        $isEnabled = false;
                    }
                    ?>
                    <div class="widget-header"><h4><i class="icon-unlock-alt"></i> <span
                                id="apiTitle"><?php echo((!$isEnabled) ? 'Enable REST API' : 'REST API Details'); ?></span>
                        </h4></div>
                    <div class="widget-content">
					
			
                        <div id="api_access_disabled" style="<?php echo((!$isEnabled) ? 'display: none;' : ''); ?>">
						
                        <div class="alert alert-warning">Your REST API key is used by API files for processing. It is designed to ensure only <strong>you</strong> are accessing the API files. If you
                            reset this key, you need to make sure you update any API calls that use this key. <strong>It's only advisable to reset this key if you believe it has become compromised.</strong> 
							To reset the key, disable the REST API feature. Then, enable it again. You will get a new key.<br/><br/>
                            <button class="btn btn-warning" data-clipboard-text="<?PHP echo html_output($data['api_key']); ?>">
                                Copy REST API Key To Clipboard
                            </button>
                        </div>
						                            
<div class="form-group row">
<label class="col-md-3 control-label">REST API Key</label>
<div class="col-md-9"><input type="text" name="my_secret_number" value="<?PHP echo html_output($data['api_key']); ?>" class="form-control input-width-xxlarge" readonly></div>

<div class="col-md-12" style="padding-top:80px;">

                            <button class="btn btn-sm btn-danger" onclick="disableApi(this)" data-admin_id="<?php echo $_SESSION[$install_directory_name.'_idev_AdminAccount']; ?>">Disable REST API Access</button>
							<a href="https://dev.idevaffiliate.com/rest_api.php" target="_blank"><button class="btn btn-sm btn-success">REST API Documentation</button></a>
							
</div></div>

                        </div>
                        <div id="api_access_enabled" style="<?php echo(($isEnabled) ? 'display: none;' : ''); ?>">
                            <button class="btn btn-sm btn-primary" onclick="enableApi(this)" data-admin_id="<?php echo $_SESSION[$install_directory_name.'_idev_AdminAccount']; ?>">Enable REST API Access</button>
							<a href="https://dev.idevaffiliate.com/rest_api.php" target="_blank"><button class="btn btn-sm btn-success">REST API Documentation</button></a>
                        </div>
						
						
							
                    </div>
                    <script>
                        function processService(admin_id, value, callback) {
                            $.ajax({
                                url: 'includes/api/allow_access.php',
                                type: 'POST',
                                data: {
                                    allowApiAccess: value,
                                    admin_id: admin_id
                                },
                                dataType: 'json',
                                success: function (res) {
                                    if (!res.bool) {
                                        console.log(res.message);
                                        return;
                                    }
                                    callback(res);
                                }
                            });
                        }
                        function enableApi(object) {
                            var admin_id = $(object).attr('data-admin_id');
                            processService(admin_id, 'enable', function (res) {
                                $('#api_access_enabled').hide();
                                $('#tab_1_4 input[name="my_secret_number"]').val(res.access_key);
                                $('#tab_1_4 [data-clipboard-text]').attr('data-clipboard-text', res.access_key);

                                var clipboard = new Clipboard('#tab_1_4 button[data-clipboard-text]', {
                                    text: function(trigger) {
                                        // Some sort of string needs to be returned, so we can include a space if input is empty.
                                        var text = $('#tab_1_4 input[name="my_secret_number"]').val() || ' ';
                                        // Need to do parsing and manipulation of the text and copy the result to clipboard. (The result may be empty)
                                        return text;
                                    }
                                });

                                $('#apiTitle').text('REST API Credential');
                                $('#api_access_disabled').show();
                            });
                        }
                        function disableApi(object) {
                            var admin_id = $(object).attr('data-admin_id');
                            processService(admin_id, 'disable', function (res) {
                                $('#api_access_disabled').hide();
                                $('#apiTitle').text('Enable REST API');
                                $('#api_access_enabled').show();
                            });
                        }
                    </script>
                </div>
            </div>
        </div>

    </div>
</div>





