<?php

function getTotalAmount($data)
{
    $calculatedValue = 0;
    foreach ($data as $key => $value) {
        $calculatedValue += $value['amount'];
    }
    return $calculatedValue;
}
require_once('authorized.php');
$request = new Zend\Http\PhpEnvironment\Request();
$aff_id = $request->getQuery('aff_id', 0);
$apiUserID = $aff_id;
if($apiUserID != 0){
    $query_syntax = "SELECT * FROM `idevaff_payments` WHERE `id` = ?";
    $queryObj = $db->prepare($query_syntax);
    $queryObj->execute([
        $apiUserID
    ]);
} else {
    $query_syntax = "SELECT * FROM `idevaff_payments`";
    $queryObj = $db->prepare($query_syntax);
    $queryObj->execute([
        $apiUserID
    ]);
}
if (!$queryObj->rowCount() || $queryObj->rowCount() == 0) {
    echo json_encode([
        'message' => 'No Payments available.',
        'bool' => false
    ]);
    die();
}
$paymentData = $queryObj->fetchAll(PDO::FETCH_ASSOC);
$totalAmount = getTotalAmount($paymentData);

if ( !empty($paymentData) ) {
    foreach ($paymentData as $index => $row) {
        $paymentData[$index]['stamp'] = date($dateformat.' '. $timeformat, $row['stamp']);
        unset($paymentData[$index]['export'], $paymentData[$index]['code']);
    }
}

echo json_encode([
    'message' => 'Successfully retrieved payments.',
    'payments' => [
        'total' => $totalAmount,
        'complete_data' => $paymentData
    ],
    'bool' => true
]);
