<?php

use Zend\Config\Factory;
use Zend\Http\PhpEnvironment\Request;
use \Firebase\JWT\JWT;

$isAuthorized = false;
require_once('vendor/autoload.php');
$config = Factory::fromFile('config/config.php', true);
require_once('config/config.main.php');
$request = new Request();
$authHeader = $request->getHeader('authorization');
$authHeader = $authHeader ? $authHeader : $_SERVER['REDIRECT_HTTP_AUTHORIZATION'];
if (!$authHeader) {
    echo json_encode([
        'message' => 'Token not found in request.',
        'bool' => false
    ]);
    die();
}
if(is_object($authHeader)){
    list($jwt) = sscanf($authHeader->toString(), 'Authorization: Bearer %s');
} else {
    list($jwt) = sscanf($authHeader, 'Bearer %s');
}
if (!$jwt) {
    echo json_encode([
        'message' => 'Something went wrong in this request. Please try again.',
        'bool' => false
    ]);
    die();
}

//$secretKey = base64_decode('93081ef6aa1f69cf8aaf4a26e1ade51d98540bf3730ac94f1d4de55135519310');
//die(var_dump($secretKey));

try {
    /*
     * decode the jwt using the key from config
     */
    $secretKey = base64_decode(SITE_KEY);

    $token = JWT::decode($jwt, $secretKey, ['HS512']);
    $isAuthorized = true;

} catch (Exception $e) {
    /*
     * the token was not able to be decoded.
     * this is likely because the signature was not able to be verified (tampered token)
     */
    echo json_encode([
        'message' => 'Unauthorized Token',
        'bool' => false
    ]);
    die();
}