<?php
use Zend\Config\Factory;
use Zend\Http\PhpEnvironment\Request;
use \Firebase\JWT\JWT;
require_once('vendor/autoload.php');
$config = Factory::fromFile('config/config.php', true);
require_once('config/config.main.php');
$request = new Request();

if (isset($_REQUEST)) {
    $api_key = $_REQUEST['api_secret'];
    if (!$api_key) {
        echo json_encode([
            'message' => 'Api Access or Secret Key is required.',
            'bool' => false
        ]);
        die();
    }
    $query_syntax = "SELECT * FROM `idevaff_admin` WHERE `api_key` = ? LIMIT 1";
    $queryObj = $db->prepare($query_syntax);
    $queryObj->execute([
        $api_key
    ]);
    $noPermissionError = [
        'message' => 'You don\'t have permission to use this api.',
        'bool' => false
    ];
    if (!$queryObj->rowCount() || $queryObj->rowCount() == 0) {
        echo json_encode($noPermissionError);
        die();
    }
    $apiData = $queryObj->fetch(PDO::FETCH_ASSOC);

    $apiData['record'] = $apiData['record'] ?? "";

//    $query_syntax = "SELECT * FROM `idevaff_api_access` WHERE `access_key` = ? LIMIT 1";
//    $queryObj = $db->prepare($query_syntax);
//    $queryObj->execute([
//        $api_key
//    ]);
//    $noPermissionError = [
//        'message' => 'You don\'t have permission to use this api.',
//        'bool' => false
//    ];
//    if (!$queryObj->rowCount() || $queryObj->rowCount() == 0) {
//        echo json_encode($noPermissionError);
//        die();
//    }
//    $apiData = $queryObj->fetch(PDO::FETCH_ASSOC);
//    if ($apiData['isEnabled'] != 'enabled') {
//        echo json_encode($noPermissionError);
//        die();
//    }
//    $query_syntax = "SELECT * FROM `idevaff_affiliates` WHERE `id` = ? LIMIT 1";
//    $queryObj = $db->prepare($query_syntax);
//    $queryObj->execute([
//        $apiData['affiliate_id']
//    ]);
//    if (!$queryObj->rowCount() || $queryObj->rowCount() == 0) {
//        echo json_encode([
//            'message' => 'User not exists.',
//            'bool' => false
//        ]);
//        die();
//    }
//    $userData = $queryObj->fetch(PDO::FETCH_ASSOC);
//    unset($userData['tax_id_ssn']);

//    $tokenId = base64_encode(mcrypt_create_iv(32));
    $tokenId = base64_encode(random_bytes(32));
    $issuedAt = time();
    $notBefore = $issuedAt;             //Adding 10 seconds
//    $expire = $notBefore + 60;            // Adding 60 seconds
    $expire = $notBefore + 3600000;            // Adding 1 hour
    $serverName = $config->get('webhost'); // Retrieve the server name from config file
    $data = [
        'iat' => $issuedAt,         // Issued at: time when the token was generated
        'jti' => $tokenId,          // Json Token Id: an unique identifier for the token
        'iss' => $serverName,       // Issuer
        'nbf' => $notBefore,        // Not before
        'exp' => $expire,           // Expire
        'data' => [                  // Data related to the signer user
            'userId' => $apiData['record'] // userid from the users table
        ]
    ];
    $secretKey = base64_decode(SITE_KEY);
    $jwt = JWT::encode(
        $data,      //Data to be encoded in the JWT
        $secretKey, // The signing key
        'HS512'     // Algorithm used to sign the token, see https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40#section-3
    );
    echo json_encode([
        'message' => 'Successfully Login',
//        'user' => $userData,
        'admin_id' => $apiData['record'],
        'token' => $jwt,
        'bool' => true
    ]);
} else {
    echo json_encode([
        'message' => 'This file only accept post request.',
        'bool' => false
    ]);
}

