<?php
use Zend\Config\Factory;
use Zend\Http\PhpEnvironment\Request;
use \Firebase\JWT\JWT;

require_once('vendor/autoload.php');

$config = Factory::fromFile('config/config.php', true);
require_once('config/config.main.php');
$request = new Request();
if ($request->isPost()) {

    $api_key = $request->getPost('api_secret');
    if (!$api_key) {
        echo json_encode([
            'message' => 'Api Access or Secret Key is required.',
            'bool' => false
        ]);
        die();
    }

    $userName = $request->getPost('userid');
    $password = $request->getPost('password');
    $login_ok = false;
    $passcheck = $password;
    $query = "select * from idevaff_affiliates where username = ? LIMIT 1";
    $result = $db->prepare($query);
    $result->execute([
        $userName
    ]);
    if ($result->rowCount()) {
        $row = $result->fetch();
        if (array_key_exists('user_key', $row) && $row['user_key'] != '') {
            //applying new hashing technique
            $hash = $row['password'] ?? "";
            $user_key = $row['user_key'] ?? "";
            //check without SITE_KEY
            $password_to_check = $user_key . $passcheck;
            if (password_verify($password_to_check, $hash)) {
                $login_ok = true;
                //check in future password need rehashed
                if (password_needs_rehash($hash, PASSWORD_DEFAULT)) {
                    // If so, create a new hash, and replace the old one
                    $newHash = password_hash($user_key . $passcheck, PASSWORD_DEFAULT);
                    //store new hash to database
                    $sql = "UPDATE `idevaff_affiliates` set `password`= ? WHERE id = ?";
                    $q = $db->prepare($sql);
                    $q->execute([$newHash, $row['id']]);
                }
            } else {
                $password_to_check = SITE_KEY . $passcheck . $row['user_key'];
                if (password_verify($password_to_check, $hash)) {
                    $login_ok = true;
                    //rehash password
                    $user_key = substr(strtr(base64_encode(sha1(microtime(true), true)), '+', '.'), 0, 22); //store this to database as user_key
                    $password_enc = password_hash($user_key . $passcheck, PASSWORD_DEFAULT);

                    $sql = "UPDATE `idevaff_affiliates` set `user_key`=?, `password`=? WHERE id = ?";
                    $q = $db->prepare($sql);
                    $q->execute([$user_key, $password_enc, $row['id']]);
                }
            }
        } else {
            $passcheck = sha1('idev_secret' . $password);
            if ($row['password'] === $passcheck) {
                $login_ok = true;
                //rehash password
                $user_key = substr(strtr(base64_encode(sha1(microtime(true), true)), '+', '.'), 0, 22); //store this to database as user_key
                $password_enc = password_hash($user_key . $password, PASSWORD_DEFAULT);

                $sql = "UPDATE `idevaff_affiliates` set `user_key`=?, `password`=? WHERE id = ?";
                $q = $db->prepare($sql);
                $q->execute([
                    $user_key,
                    $password_enc,
                    $row['id']
                ]);
            }
        }
        if (!$login_ok) {
            die(json_encode([
                'message' => 'Password is incorrect.',
                'bool' => false
            ]));
        }
        $tokenId = base64_encode(random_bytes(32));
        $issuedAt = time();
        $notBefore = $issuedAt;             //Adding 10 seconds
//        $expire = $notBefore + 3600000;            // Adding 1 hour
        $expire = $notBefore + 7200000;            // Adding 2 hour
        $serverName = $config->get('webhost'); // Retrieve the server name from config file
        $data = [
            'iat' => $issuedAt,         // Issued at: time when the token was generated
            'jti' => $tokenId,          // Json Token Id: an unique identifier for the token
            'iss' => $serverName,       // Issuer
            'nbf' => $notBefore,        // Not before
            'exp' => $expire,           // Expire
            'data' => [                  // Data related to the signer user
                'affiliate_id' => $row['id'] // userid from the users table
            ]
        ];
        $secretKey = base64_decode(SITE_KEY);
        $jwt = JWT::encode(
            $data,      //Data to be encoded in the JWT
            $secretKey, // The signing key
            'HS512'     // Algorithm used to sign the token, see https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40#section-3
        );
        echo json_encode([
            'message' => 'Successfully Login. This token will expire in 2 hours',
            'affiliate_id' => $row['id'],
            'token' => $jwt,
            'bool' => true
        ]);
    } else {
        echo json_encode([
            'message' => 'No User Found.',
            'bool' => false
        ]);
    }
} else {
    echo json_encode([
        'message' => 'This file only accept post request.',
        'bool' => false
    ]);
}